/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import com.uber.m3.tally.Scope;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.temporal.internal.BackoffThrottler;
import io.temporal.internal.worker.AdjustableSemaphore;
import io.temporal.internal.worker.BasePoller;
import io.temporal.internal.worker.ExecutorThreadFactory;
import io.temporal.internal.worker.PollScaleReportHandle;
import io.temporal.internal.worker.PollerOptions;
import io.temporal.internal.worker.ScalingTask;
import io.temporal.internal.worker.ShutdownManager;
import io.temporal.internal.worker.ShutdownableTaskExecutor;
import io.temporal.internal.worker.SlotReservationData;
import io.temporal.internal.worker.Throttler;
import io.temporal.internal.worker.TrackingSlotSupplier;
import io.temporal.worker.tuning.PollerBehaviorAutoscaling;
import io.temporal.worker.tuning.SlotPermit;
import io.temporal.worker.tuning.SlotReleaseReason;
import io.temporal.worker.tuning.SlotSupplierFuture;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AsyncPoller<T extends ScalingTask>
extends BasePoller<T> {
    private static final Logger log = LoggerFactory.getLogger(AsyncPoller.class);
    private final TrackingSlotSupplier<?> slotSupplier;
    private final SlotReservationData slotReservationData;
    private final List<PollTaskAsync<T>> asyncTaskPollers;
    private final PollerOptions pollerOptions;
    private final PollerBehaviorAutoscaling pollerBehavior;
    private final Scope workerMetricsScope;
    private Throttler pollRateThrottler;
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler = new BasePoller.PollerUncaughtExceptionHandler();
    private final PollQueueBalancer pollerBalancer = new PollQueueBalancer();

    AsyncPoller(TrackingSlotSupplier<?> slotSupplier, SlotReservationData slotReservationData, PollTaskAsync<T> asyncTaskPoller, ShutdownableTaskExecutor<T> taskExecutor, PollerOptions pollerOptions, Scope workerMetricsScope) {
        this(slotSupplier, slotReservationData, Collections.singletonList(asyncTaskPoller), taskExecutor, pollerOptions, workerMetricsScope);
    }

    AsyncPoller(TrackingSlotSupplier<?> slotSupplier, SlotReservationData slotReservationData, List<PollTaskAsync<T>> asyncTaskPollers, ShutdownableTaskExecutor<T> taskExecutor, PollerOptions pollerOptions, Scope workerMetricsScope) {
        super(taskExecutor);
        Objects.requireNonNull(slotSupplier, "slotSupplier cannot be null");
        Objects.requireNonNull(slotReservationData, "slotReservation data should not be null");
        Objects.requireNonNull(asyncTaskPollers, "asyncTaskPollers should not be null");
        if (asyncTaskPollers.isEmpty()) {
            throw new IllegalArgumentException("asyncTaskPollers must contain at least one poller");
        }
        Objects.requireNonNull(pollerOptions, "pollerOptions should not be null");
        Objects.requireNonNull(workerMetricsScope, "workerMetricsScope should not be null");
        this.slotSupplier = slotSupplier;
        this.slotReservationData = slotReservationData;
        this.asyncTaskPollers = asyncTaskPollers;
        if (!(pollerOptions.getPollerBehavior() instanceof PollerBehaviorAutoscaling)) {
            throw new IllegalArgumentException("PollerBehavior " + pollerOptions.getPollerBehavior() + " is not supported for AsyncPoller. Only PollerBehaviorAutoscaling is supported.");
        }
        this.pollerBehavior = (PollerBehaviorAutoscaling)pollerOptions.getPollerBehavior();
        this.pollerOptions = pollerOptions;
        this.workerMetricsScope = workerMetricsScope;
    }

    @Override
    public boolean start() {
        if (this.pollerOptions.getMaximumPollRatePerSecond() > 0.0) {
            this.pollRateThrottler = new Throttler("poller", this.pollerOptions.getMaximumPollRatePerSecond(), this.pollerOptions.getMaximumPollRateIntervalMilliseconds());
        }
        ScheduledExecutorService exec = Executors.newScheduledThreadPool(this.asyncTaskPollers.size() + 1, new ExecutorThreadFactory(this.pollerOptions.getPollThreadNamePrefix(), this.pollerOptions.getUncaughtExceptionHandler()));
        this.pollExecutor = exec;
        for (PollTaskAsync asyncTaskPoller : this.asyncTaskPollers) {
            log.info("Starting async poller: {}", (Object)asyncTaskPoller.getLabel());
            AdjustableSemaphore pollerSemaphore = new AdjustableSemaphore(this.pollerBehavior.getInitialConcurrentTaskPollers());
            PollScaleReportHandle pollScaleReportHandle = new PollScaleReportHandle(this.pollerBehavior.getMinConcurrentTaskPollers(), this.pollerBehavior.getMaxConcurrentTaskPollers(), this.pollerBehavior.getInitialConcurrentTaskPollers(), newTarget -> {
                log.debug("Updating maximum number of pollers for {} to: {}", (Object)asyncTaskPoller.getLabel(), newTarget);
                pollerSemaphore.setMaxPermits((int)newTarget);
            });
            PollQueueTask pollQueue = new PollQueueTask(asyncTaskPoller, pollerSemaphore, pollScaleReportHandle);
            this.pollerBalancer.addPoller(asyncTaskPoller.getLabel());
            exec.execute(pollQueue);
            exec.scheduleAtFixedRate(pollScaleReportHandle, 0L, 100L, TimeUnit.MILLISECONDS);
        }
        return true;
    }

    @Override
    public CompletableFuture<Void> shutdown(ShutdownManager shutdownManager, boolean interruptTasks) {
        return super.shutdown(shutdownManager, interruptTasks).thenApply(f -> {
            for (PollTaskAsync<T> asyncTaskPoller : this.asyncTaskPollers) {
                try {
                    log.debug("Shutting down async poller: {}", (Object)asyncTaskPoller.getLabel());
                    asyncTaskPoller.cancel(new RuntimeException("Shutting down poller"));
                }
                catch (Throwable e) {
                    log.error("Error while cancelling poll task", e);
                }
            }
            return null;
        });
    }

    @ThreadSafe
    class PollQueueBalancer {
        Map<String, Integer> taskCounts = new HashMap<String, Integer>();
        private final Lock balancerLock = new ReentrantLock();
        private final Condition balancerCondition = this.balancerLock.newCondition();

        PollQueueBalancer() {
        }

        void startPoll(String pollerName) {
            this.balancerLock.lock();
            Integer currentPolls = this.taskCounts.compute(pollerName, (k, v) -> v + 1);
            if (currentPolls == 1) {
                this.balancerCondition.signalAll();
            }
            this.balancerLock.unlock();
        }

        void endPoll(String pollerName) {
            this.balancerLock.lock();
            if (!this.taskCounts.containsKey(pollerName)) {
                this.balancerLock.unlock();
                return;
            }
            Integer currentPolls = this.taskCounts.compute(pollerName, (k, v) -> v - 1);
            if (currentPolls == 0) {
                this.balancerCondition.signalAll();
            }
            this.balancerLock.unlock();
        }

        void addPoller(String pollerName) {
            this.balancerLock.lock();
            this.taskCounts.put(pollerName, 0);
            this.balancerCondition.signalAll();
            this.balancerLock.unlock();
        }

        void removePoller(String pollerName) {
            this.balancerLock.lock();
            this.taskCounts.remove(pollerName);
            this.balancerCondition.signalAll();
            this.balancerLock.unlock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void balance(String p) throws InterruptedException {
            while (!AsyncPoller.this.shouldTerminate()) {
                this.balancerLock.lock();
                try {
                    if (this.taskCounts.get(p) == 0) {
                        return;
                    }
                    boolean allOtherTasksHavePolls = true;
                    for (String task : this.taskCounts.keySet()) {
                        if (Objects.equals(task, p) || this.taskCounts.get(task) != 0) continue;
                        allOtherTasksHavePolls = false;
                        break;
                    }
                    if (!allOtherTasksHavePolls) {
                        this.balancerCondition.await();
                        continue;
                    }
                    return;
                }
                finally {
                    this.balancerLock.unlock();
                }
            }
        }
    }

    class PollQueueTask
    implements Runnable {
        private final PollTaskAsync<T> asyncTaskPoller;
        private final PollScaleReportHandle<T> pollScaleReportHandle;
        private final AdjustableSemaphore pollerSemaphore;
        private final BackoffThrottler pollBackoffThrottler;
        private boolean abort = false;

        PollQueueTask(PollTaskAsync<T> asyncTaskPoller, AdjustableSemaphore pollerSemaphore, PollScaleReportHandle<T> pollScaleReportHandle) {
            this.asyncTaskPoller = asyncTaskPoller;
            this.pollBackoffThrottler = new BackoffThrottler(AsyncPoller.this.pollerOptions.getBackoffInitialInterval(), AsyncPoller.this.pollerOptions.getBackoffCongestionInitialInterval(), AsyncPoller.this.pollerOptions.getBackoffMaximumInterval(), AsyncPoller.this.pollerOptions.getBackoffCoefficient(), AsyncPoller.this.pollerOptions.getBackoffMaximumJitterCoefficient());
            this.pollerSemaphore = pollerSemaphore;
            this.pollScaleReportHandle = pollScaleReportHandle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                boolean pollRequestMade;
                boolean pollerSemaphoreAcquired;
                SlotPermit permit;
                block37: {
                    block38: {
                        block35: {
                            block36: {
                                block34: {
                                    if (this.abort) {
                                        return;
                                    }
                                    permit = null;
                                    pollerSemaphoreAcquired = false;
                                    pollRequestMade = false;
                                    try {
                                        SlotSupplierFuture future;
                                        CountDownLatch suspender;
                                        long throttleMs = this.pollBackoffThrottler.getSleepTime();
                                        if (throttleMs > 0L) {
                                            Thread.sleep(throttleMs);
                                        }
                                        if (AsyncPoller.this.pollRateThrottler != null) {
                                            AsyncPoller.this.pollRateThrottler.throttle();
                                        }
                                        if ((suspender = (CountDownLatch)AsyncPoller.this.suspendLatch.get()) != null) {
                                            if (log.isDebugEnabled()) {
                                                log.debug("poll task suspending latchCount=" + suspender.getCount());
                                            }
                                            suspender.await();
                                        }
                                        if (AsyncPoller.this.shouldTerminate()) continue;
                                        AsyncPoller.this.pollerBalancer.balance(this.asyncTaskPoller.getLabel());
                                        if (AsyncPoller.this.shouldTerminate()) continue;
                                        try {
                                            future = AsyncPoller.this.slotSupplier.reserveSlot(AsyncPoller.this.slotReservationData);
                                        }
                                        catch (Exception e2) {
                                            log.warn("Error while trying to reserve a slot", e2.getCause());
                                            if (!pollRequestMade) {
                                                if (permit != null) {
                                                    AsyncPoller.this.slotSupplier.releaseSlot(SlotReleaseReason.neverUsed(), permit);
                                                }
                                                if (pollerSemaphoreAcquired) {
                                                    this.pollerSemaphore.release();
                                                }
                                            }
                                            if (!AsyncPoller.this.shouldTerminate()) continue;
                                            AsyncPoller.this.pollerBalancer.removePoller(this.asyncTaskPoller.getLabel());
                                            this.abort = true;
                                            log.info("Poll loop is terminated: {} - {}", (Object)AsyncPoller.this.getClass().getSimpleName(), (Object)this.asyncTaskPoller.getLabel());
                                            continue;
                                        }
                                        permit = BasePoller.getSlotPermitAndHandleInterrupts(future, AsyncPoller.this.slotSupplier);
                                        if (permit == null || AsyncPoller.this.shouldTerminate()) {
                                            if (pollRequestMade) break block34;
                                            if (permit != null) {
                                                AsyncPoller.this.slotSupplier.releaseSlot(SlotReleaseReason.neverUsed(), permit);
                                            }
                                            if (!pollerSemaphoreAcquired) break block34;
                                            this.pollerSemaphore.release();
                                            break block34;
                                        }
                                        this.pollerSemaphore.acquire();
                                        pollerSemaphoreAcquired = true;
                                        if (AsyncPoller.this.shouldTerminate()) {
                                            if (pollRequestMade) break block35;
                                            break block36;
                                        }
                                        AsyncPoller.this.workerMetricsScope.counter("temporal_poller_start").inc(1L);
                                        SlotPermit finalPermit = permit;
                                        CompletableFuture pollRequest = this.asyncTaskPoller.poll(permit);
                                        pollRequestMade = true;
                                        AsyncPoller.this.pollerBalancer.startPoll(this.asyncTaskPoller.getLabel());
                                        ((CompletableFuture)pollRequest.handle((task, e) -> {
                                            AsyncPoller.this.pollerBalancer.endPoll(this.asyncTaskPoller.getLabel());
                                            if (e instanceof CompletionException) {
                                                e = e.getCause();
                                            }
                                            this.pollerSemaphore.release();
                                            this.pollScaleReportHandle.report((ScalingTask)task, (Throwable)e);
                                            if (e != null) {
                                                AsyncPoller.this.uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), (Throwable)e);
                                                this.pollBackoffThrottler.failure(e instanceof StatusRuntimeException ? ((StatusRuntimeException)((Object)e)).getStatus().getCode() : Status.Code.UNKNOWN);
                                                AsyncPoller.this.slotSupplier.releaseSlot(SlotReleaseReason.neverUsed(), finalPermit);
                                                return null;
                                            }
                                            if (task != null) {
                                                AsyncPoller.this.taskExecutor.process(task);
                                            } else {
                                                AsyncPoller.this.slotSupplier.releaseSlot(SlotReleaseReason.neverUsed(), finalPermit);
                                            }
                                            this.pollBackoffThrottler.success();
                                            return null;
                                        })).exceptionally(throwable -> {
                                            log.error("Error while trying to poll task", throwable);
                                            return null;
                                        });
                                        if (pollRequestMade) break block37;
                                        break block38;
                                    }
                                    catch (PollTaskAsyncAbort ab) {
                                        this.abort = true;
                                        continue;
                                    }
                                    catch (Throwable e3) {
                                        if (e3 instanceof InterruptedException) {
                                            Thread.currentThread().interrupt();
                                        }
                                        AsyncPoller.this.uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), e3);
                                        continue;
                                    }
                                }
                                if (!AsyncPoller.this.shouldTerminate()) continue;
                                AsyncPoller.this.pollerBalancer.removePoller(this.asyncTaskPoller.getLabel());
                                this.abort = true;
                                log.info("Poll loop is terminated: {} - {}", (Object)AsyncPoller.this.getClass().getSimpleName(), (Object)this.asyncTaskPoller.getLabel());
                                continue;
                            }
                            if (permit != null) {
                                AsyncPoller.this.slotSupplier.releaseSlot(SlotReleaseReason.neverUsed(), permit);
                            }
                            if (pollerSemaphoreAcquired) {
                                this.pollerSemaphore.release();
                            }
                        }
                        if (!AsyncPoller.this.shouldTerminate()) continue;
                        AsyncPoller.this.pollerBalancer.removePoller(this.asyncTaskPoller.getLabel());
                        this.abort = true;
                        log.info("Poll loop is terminated: {} - {}", (Object)AsyncPoller.this.getClass().getSimpleName(), (Object)this.asyncTaskPoller.getLabel());
                        continue;
                    }
                    if (permit != null) {
                        AsyncPoller.this.slotSupplier.releaseSlot(SlotReleaseReason.neverUsed(), permit);
                    }
                    if (pollerSemaphoreAcquired) {
                        this.pollerSemaphore.release();
                    }
                }
                if (!AsyncPoller.this.shouldTerminate()) continue;
                AsyncPoller.this.pollerBalancer.removePoller(this.asyncTaskPoller.getLabel());
                this.abort = true;
                log.info("Poll loop is terminated: {} - {}", (Object)AsyncPoller.this.getClass().getSimpleName(), (Object)this.asyncTaskPoller.getLabel());
                continue;
                finally {
                    if (!pollRequestMade) {
                        if (permit != null) {
                            AsyncPoller.this.slotSupplier.releaseSlot(SlotReleaseReason.neverUsed(), permit);
                        }
                        if (pollerSemaphoreAcquired) {
                            this.pollerSemaphore.release();
                        }
                    }
                    if (!AsyncPoller.this.shouldTerminate()) continue;
                    AsyncPoller.this.pollerBalancer.removePoller(this.asyncTaskPoller.getLabel());
                    this.abort = true;
                    log.info("Poll loop is terminated: {} - {}", (Object)AsyncPoller.this.getClass().getSimpleName(), (Object)this.asyncTaskPoller.getLabel());
                    continue;
                }
                break;
            }
        }
    }

    public static interface PollTaskAsync<TT> {
        public CompletableFuture<TT> poll(SlotPermit var1) throws PollTaskAsyncAbort;

        default public void cancel(Throwable cause) {
        }

        default public String getLabel() {
            return "PollTaskAsync";
        }
    }

    public static class PollTaskAsyncAbort
    extends Exception {
        PollTaskAsyncAbort(String message) {
            super(message);
        }
    }
}

