/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import com.google.protobuf.Timestamp;
import com.uber.m3.tally.Scope;
import io.temporal.api.common.v1.WorkerVersionCapabilities;
import io.temporal.api.taskqueue.v1.TaskQueue;
import io.temporal.api.workflowservice.v1.GetSystemInfoResponse;
import io.temporal.api.workflowservice.v1.PollNexusTaskQueueRequest;
import io.temporal.api.workflowservice.v1.PollNexusTaskQueueResponse;
import io.temporal.api.workflowservice.v1.PollNexusTaskQueueResponseOrBuilder;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.worker.MultiThreadedPoller;
import io.temporal.internal.worker.NexusTask;
import io.temporal.internal.worker.SlotReservationData;
import io.temporal.internal.worker.TrackingSlotSupplier;
import io.temporal.internal.worker.WorkerVersioningOptions;
import io.temporal.internal.worker.WorkerVersioningProtoUtils;
import io.temporal.serviceclient.MetricsTag;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.worker.PollerTypeMetricsTag;
import io.temporal.worker.tuning.NexusSlotInfo;
import io.temporal.worker.tuning.SlotPermit;
import io.temporal.worker.tuning.SlotReleaseReason;
import io.temporal.worker.tuning.SlotSupplierFuture;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class NexusPollTask
implements MultiThreadedPoller.PollTask<NexusTask> {
    private static final Logger log = LoggerFactory.getLogger(NexusPollTask.class);
    private final WorkflowServiceStubs service;
    private final TrackingSlotSupplier<NexusSlotInfo> slotSupplier;
    private final Scope metricsScope;
    private final PollNexusTaskQueueRequest pollRequest;
    private final AtomicInteger pollGauge = new AtomicInteger();

    public NexusPollTask(@Nonnull WorkflowServiceStubs service, @Nonnull String namespace, @Nonnull String taskQueue, @Nonnull String identity, @Nonnull WorkerVersioningOptions versioningOptions, @Nonnull TrackingSlotSupplier<NexusSlotInfo> slotSupplier, @Nonnull Scope metricsScope, @Nonnull Supplier<GetSystemInfoResponse.Capabilities> serverCapabilities) {
        this.service = Objects.requireNonNull(service);
        this.slotSupplier = slotSupplier;
        this.metricsScope = Objects.requireNonNull(metricsScope);
        PollNexusTaskQueueRequest.Builder pollRequest = PollNexusTaskQueueRequest.newBuilder().setNamespace(namespace).setIdentity(identity).setTaskQueue(TaskQueue.newBuilder().setName(taskQueue));
        if (versioningOptions.getWorkerDeploymentOptions() != null) {
            pollRequest.setDeploymentOptions(WorkerVersioningProtoUtils.deploymentOptionsToProto(versioningOptions.getWorkerDeploymentOptions()));
        } else if (serverCapabilities.get().getBuildIdBasedVersioning()) {
            pollRequest.setWorkerVersionCapabilities(WorkerVersionCapabilities.newBuilder().setBuildId(versioningOptions.getBuildId()).setUseVersioning(versioningOptions.isUsingVersioning()).build());
        }
        this.pollRequest = pollRequest.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NexusTask poll() {
        SlotSupplierFuture future;
        if (log.isTraceEnabled()) {
            log.trace("poll request begin: " + this.pollRequest);
        }
        boolean isSuccessful = false;
        try {
            future = this.slotSupplier.reserveSlot(new SlotReservationData(this.pollRequest.getTaskQueue().getName(), this.pollRequest.getIdentity(), this.pollRequest.getWorkerVersionCapabilities().getBuildId()));
        }
        catch (Exception e) {
            log.warn("Error while trying to reserve a slot for a nexus task", e.getCause());
            return null;
        }
        SlotPermit permit = MultiThreadedPoller.getSlotPermitAndHandleInterrupts(future, this.slotSupplier);
        if (permit == null) {
            return null;
        }
        MetricsTag.tagged((Scope)this.metricsScope, (MetricsTag.TagValue)PollerTypeMetricsTag.PollerType.NEXUS_TASK).gauge("temporal_num_pollers").update((double)this.pollGauge.incrementAndGet());
        try {
            PollNexusTaskQueueResponse response = ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).pollNexusTaskQueue(this.pollRequest);
            if (response == null || response.getTaskToken().isEmpty()) {
                this.metricsScope.counter("temporal_nexus_poll_no_task").inc(1L);
                NexusTask e = null;
                return e;
            }
            Timestamp startedTime = ProtobufTimeUtils.getCurrentProtoTime();
            this.metricsScope.timer("temporal_nexus_task_schedule_to_start_latency").record(ProtobufTimeUtils.toM3Duration(startedTime, response.getRequest().getScheduledTime()));
            isSuccessful = true;
            NexusTask nexusTask = new NexusTask((PollNexusTaskQueueResponseOrBuilder)response, permit, () -> this.slotSupplier.releaseSlot(SlotReleaseReason.taskComplete(), permit));
            return nexusTask;
        }
        finally {
            MetricsTag.tagged((Scope)this.metricsScope, (MetricsTag.TagValue)PollerTypeMetricsTag.PollerType.NEXUS_TASK).gauge("temporal_num_pollers").update((double)this.pollGauge.decrementAndGet());
            if (!isSuccessful) {
                this.slotSupplier.releaseSlot(SlotReleaseReason.neverUsed(), permit);
            }
        }
    }
}

