/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.temporal.worker.tuning.PollerBehavior;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PollerOptions {
    public static final String UNHANDLED_COMMAND_EXCEPTION_MESSAGE = "Failed workflow task due to unhandled command. This error is likely recoverable.";
    private static final PollerOptions DEFAULT_INSTANCE = PollerOptions.newBuilder().build();
    private static final Logger log = LoggerFactory.getLogger(PollerOptions.class);
    private final int maximumPollRateIntervalMilliseconds;
    private final double maximumPollRatePerSecond;
    private final double backoffCoefficient;
    private final double backoffMaximumJitterCoefficient;
    private final Duration backoffInitialInterval;
    private final Duration backoffCongestionInitialInterval;
    private final Duration backoffMaximumInterval;
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private final String pollThreadNamePrefix;
    private final boolean usingVirtualThreads;
    private final ExecutorService pollerTaskExecutorOverride;
    private final PollerBehavior pollerBehavior;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(PollerOptions options) {
        return new Builder(options);
    }

    public static PollerOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    private PollerOptions(int maximumPollRateIntervalMilliseconds, double maximumPollRatePerSecond, double backoffCoefficient, Duration backoffInitialInterval, Duration backoffCongestionInitialInterval, Duration backoffMaximumInterval, double backoffMaximumJitterCoefficient, PollerBehavior pollerBehavior, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, String pollThreadNamePrefix, boolean usingVirtualThreads, ExecutorService pollerTaskExecutorOverride) {
        this.maximumPollRateIntervalMilliseconds = maximumPollRateIntervalMilliseconds;
        this.maximumPollRatePerSecond = maximumPollRatePerSecond;
        this.backoffCoefficient = backoffCoefficient;
        this.backoffInitialInterval = backoffInitialInterval;
        this.backoffCongestionInitialInterval = backoffCongestionInitialInterval;
        this.backoffMaximumInterval = backoffMaximumInterval;
        this.backoffMaximumJitterCoefficient = backoffMaximumJitterCoefficient;
        this.pollerBehavior = pollerBehavior;
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
        this.pollThreadNamePrefix = pollThreadNamePrefix;
        this.usingVirtualThreads = usingVirtualThreads;
        this.pollerTaskExecutorOverride = pollerTaskExecutorOverride;
    }

    public int getMaximumPollRateIntervalMilliseconds() {
        return this.maximumPollRateIntervalMilliseconds;
    }

    public double getMaximumPollRatePerSecond() {
        return this.maximumPollRatePerSecond;
    }

    public double getBackoffCoefficient() {
        return this.backoffCoefficient;
    }

    public Duration getBackoffInitialInterval() {
        return this.backoffInitialInterval;
    }

    public Duration getBackoffCongestionInitialInterval() {
        return this.backoffCongestionInitialInterval;
    }

    public Duration getBackoffMaximumInterval() {
        return this.backoffMaximumInterval;
    }

    public double getBackoffMaximumJitterCoefficient() {
        return this.backoffMaximumJitterCoefficient;
    }

    public PollerBehavior getPollerBehavior() {
        return this.pollerBehavior;
    }

    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.uncaughtExceptionHandler;
    }

    public String getPollThreadNamePrefix() {
        return this.pollThreadNamePrefix;
    }

    public boolean isUsingVirtualThreads() {
        return this.usingVirtualThreads;
    }

    public ExecutorService getPollerTaskExecutorOverride() {
        return this.pollerTaskExecutorOverride;
    }

    public String toString() {
        return "PollerOptions{maximumPollRateIntervalMilliseconds=" + this.maximumPollRateIntervalMilliseconds + ", maximumPollRatePerSecond=" + this.maximumPollRatePerSecond + ", backoffCoefficient=" + this.backoffCoefficient + ", backoffInitialInterval=" + this.backoffInitialInterval + ", backoffCongestionInitialInterval=" + this.backoffCongestionInitialInterval + ", backoffMaximumInterval=" + this.backoffMaximumInterval + ", backoffMaximumJitterCoefficient=" + this.backoffMaximumJitterCoefficient + ", pollerBehavior=" + this.pollerBehavior + ", pollThreadNamePrefix='" + this.pollThreadNamePrefix + ", usingVirtualThreads='" + this.usingVirtualThreads + '\'' + '}';
    }

    public static final class Builder {
        private int maximumPollRateIntervalMilliseconds = 1000;
        private double maximumPollRatePerSecond;
        private double backoffCoefficient = 2.0;
        private Duration backoffInitialInterval = Duration.ofMillis(100L);
        private Duration backoffCongestionInitialInterval = Duration.ofMillis(1000L);
        private Duration backoffMaximumInterval = Duration.ofMinutes(1L);
        private double backoffMaximumJitterCoefficient = 0.1;
        private PollerBehavior pollerBehavior;
        private String pollThreadNamePrefix;
        private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
        private boolean usingVirtualThreads;
        private ExecutorService pollerTaskExecutorOverride;

        private Builder() {
        }

        private Builder(PollerOptions options) {
            if (options == null) {
                return;
            }
            this.maximumPollRateIntervalMilliseconds = options.getMaximumPollRateIntervalMilliseconds();
            this.maximumPollRatePerSecond = options.getMaximumPollRatePerSecond();
            this.backoffCoefficient = options.getBackoffCoefficient();
            this.backoffInitialInterval = options.getBackoffInitialInterval();
            this.backoffCongestionInitialInterval = options.getBackoffCongestionInitialInterval();
            this.backoffMaximumInterval = options.getBackoffMaximumInterval();
            this.backoffMaximumJitterCoefficient = options.getBackoffMaximumJitterCoefficient();
            this.pollerBehavior = options.getPollerBehavior();
            this.pollThreadNamePrefix = options.getPollThreadNamePrefix();
            this.uncaughtExceptionHandler = options.getUncaughtExceptionHandler();
            this.usingVirtualThreads = options.isUsingVirtualThreads();
            this.pollerTaskExecutorOverride = options.getPollerTaskExecutorOverride();
        }

        public Builder setMaximumPollRateIntervalMilliseconds(int maximumPollRateIntervalMilliseconds) {
            this.maximumPollRateIntervalMilliseconds = maximumPollRateIntervalMilliseconds;
            return this;
        }

        public Builder setMaximumPollRatePerSecond(double maximumPollRatePerSecond) {
            this.maximumPollRatePerSecond = maximumPollRatePerSecond;
            return this;
        }

        public Builder setBackoffCoefficient(double backoffCoefficient) {
            this.backoffCoefficient = backoffCoefficient;
            return this;
        }

        public Builder setBackoffInitialInterval(Duration backoffInitialInterval) {
            this.backoffInitialInterval = backoffInitialInterval;
            return this;
        }

        public Builder setBackoffCongestionInitialInterval(Duration backoffCongestionInitialInterval) {
            this.backoffCongestionInitialInterval = backoffCongestionInitialInterval;
            return this;
        }

        public Builder setBackoffMaximumInterval(Duration backoffMaximumInterval) {
            this.backoffMaximumInterval = backoffMaximumInterval;
            return this;
        }

        public Builder setBackoffMaximumJitterCoefficient(double backoffMaximumJitterCoefficient) {
            this.backoffMaximumJitterCoefficient = backoffMaximumJitterCoefficient;
            return this;
        }

        public Builder setPollerBehavior(PollerBehavior pollerBehavior) {
            this.pollerBehavior = pollerBehavior;
            return this;
        }

        public Builder setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            this.uncaughtExceptionHandler = uncaughtExceptionHandler;
            return this;
        }

        public Builder setPollThreadNamePrefix(String pollThreadNamePrefix) {
            this.pollThreadNamePrefix = pollThreadNamePrefix;
            return this;
        }

        public Builder setUsingVirtualThreads(boolean usingVirtualThreads) {
            this.usingVirtualThreads = usingVirtualThreads;
            return this;
        }

        public Builder setPollerTaskExecutorOverride(ExecutorService overrideTaskExecutor) {
            this.pollerTaskExecutorOverride = overrideTaskExecutor;
            return this;
        }

        public PollerOptions build() {
            if (this.uncaughtExceptionHandler == null) {
                this.uncaughtExceptionHandler = (t, e) -> {
                    if (e instanceof RuntimeException && e.getCause() instanceof StatusRuntimeException) {
                        StatusRuntimeException sre = (StatusRuntimeException)e.getCause();
                        if (sre.getStatus().getCode() == Status.Code.INVALID_ARGUMENT && sre.getMessage().startsWith("INVALID_ARGUMENT: UnhandledCommand")) {
                            log.info(PollerOptions.UNHANDLED_COMMAND_EXCEPTION_MESSAGE, e);
                        }
                    } else {
                        log.error("uncaught exception", e);
                    }
                };
            }
            return new PollerOptions(this.maximumPollRateIntervalMilliseconds, this.maximumPollRatePerSecond, this.backoffCoefficient, this.backoffInitialInterval, this.backoffCongestionInitialInterval, this.backoffMaximumInterval, this.backoffMaximumJitterCoefficient, this.pollerBehavior, this.uncaughtExceptionHandler, this.pollThreadNamePrefix, this.usingVirtualThreads, this.pollerTaskExecutorOverride);
        }
    }
}

