/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import io.temporal.api.enums.v1.TaskQueueKind;
import io.temporal.internal.worker.DisableNormalPolling;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class StickyQueueBalancer
implements DisableNormalPolling {
    private final int pollersCount;
    private final boolean stickyQueueEnabled;
    private int stickyPollers = 0;
    private int normalPollers = 0;
    private boolean disableNormalPoll = false;
    private long stickyBacklogSize = 0L;

    public StickyQueueBalancer(int pollersCount, boolean stickyQueueEnabled) {
        this.pollersCount = pollersCount;
        this.stickyQueueEnabled = stickyQueueEnabled;
    }

    public synchronized TaskQueueKind makePoll() {
        if (this.stickyQueueEnabled) {
            if (this.disableNormalPoll) {
                ++this.stickyPollers;
                return TaskQueueKind.TASK_QUEUE_KIND_STICKY;
            }
            if (this.stickyBacklogSize > (long)this.pollersCount || this.stickyPollers <= this.normalPollers) {
                ++this.stickyPollers;
                return TaskQueueKind.TASK_QUEUE_KIND_STICKY;
            }
        }
        ++this.normalPollers;
        return TaskQueueKind.TASK_QUEUE_KIND_NORMAL;
    }

    public synchronized void finishPoll(TaskQueueKind taskQueueKind) {
        switch (taskQueueKind) {
            case TASK_QUEUE_KIND_NORMAL: {
                --this.normalPollers;
                break;
            }
            case TASK_QUEUE_KIND_STICKY: {
                --this.stickyPollers;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid task queue kind: " + taskQueueKind);
            }
        }
    }

    public synchronized void finishPoll(TaskQueueKind taskQueueKind, long backlogSize) {
        this.finishPoll(taskQueueKind);
        if (TaskQueueKind.TASK_QUEUE_KIND_STICKY.equals((Object)taskQueueKind)) {
            this.stickyBacklogSize = backlogSize;
        }
    }

    @Override
    public synchronized void disableNormalPoll() {
        this.disableNormalPoll = true;
    }
}

