/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.worker.tuning;

import com.uber.m3.tally.Gauge;
import com.uber.m3.tally.Scope;
import io.temporal.common.Experimental;
import io.temporal.worker.tuning.JVMSystemResourceInfo;
import io.temporal.worker.tuning.PIDController;
import io.temporal.worker.tuning.ResourceBasedControllerOptions;
import io.temporal.worker.tuning.SystemResourceInfo;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;

@Experimental
public class ResourceBasedController {
    public final ResourceBasedControllerOptions options;
    private final ReentrantLock decisionLock = new ReentrantLock();
    private final PIDController memoryController;
    private final PIDController cpuController;
    private final SystemResourceInfo systemInfoSupplier;
    private Instant lastPidRefresh = Instant.now();
    private final AtomicReference<Metrics> metrics = new AtomicReference();

    public static ResourceBasedController newSystemInfoController(ResourceBasedControllerOptions options) {
        return new ResourceBasedController(options, new JVMSystemResourceInfo());
    }

    public ResourceBasedController(ResourceBasedControllerOptions options, SystemResourceInfo systemInfoSupplier) {
        this.options = options;
        this.systemInfoSupplier = systemInfoSupplier;
        this.memoryController = new PIDController(options.getTargetMemoryUsage(), options.getMemoryPGain(), options.getMemoryIGain(), options.getMemoryDGain());
        this.cpuController = new PIDController(options.getTargetCPUUsage(), options.getCpuPGain(), options.getCpuIGain(), options.getCpuDGain());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean pidDecision() {
        this.decisionLock.lock();
        try {
            double memoryUsage = this.systemInfoSupplier.getMemoryUsagePercent();
            double cpuUsage = this.systemInfoSupplier.getCPUUsagePercent();
            double memoryOutput = this.memoryController.getOutput(this.lastPidRefresh.getEpochSecond(), memoryUsage);
            double cpuOutput = this.cpuController.getOutput(this.lastPidRefresh.getEpochSecond(), cpuUsage);
            this.lastPidRefresh = Instant.now();
            Metrics metrics = this.metrics.get();
            if (metrics != null) {
                metrics.memUsage.update(memoryUsage);
                metrics.cpuUsage.update(cpuUsage);
                metrics.memPidOut.update(memoryOutput);
                metrics.cpuPidOut.update(cpuOutput);
            }
            boolean bl = memoryOutput > this.options.getMemoryOutputThreshold() && cpuOutput > this.options.getCpuOutputThreshold() && this.canReserve();
            return bl;
        }
        finally {
            this.decisionLock.unlock();
        }
    }

    private boolean canReserve() {
        return this.systemInfoSupplier.getMemoryUsagePercent() < this.options.getTargetMemoryUsage();
    }

    public void setMetricsScope(Scope metricsScope) {
        if (this.metrics.get() == null) {
            this.metrics.set(new Metrics(metricsScope));
        }
    }

    private static class Metrics {
        private final Gauge memUsage;
        private final Gauge cpuUsage;
        private final Gauge memPidOut;
        private final Gauge cpuPidOut;

        private Metrics(Scope scope) {
            this.memUsage = scope.gauge("resource_slots_mem_usage");
            this.cpuUsage = scope.gauge("resource_slots_cpu_usage");
            this.memPidOut = scope.gauge("resource_slots_mem_pid_output");
            this.cpuPidOut = scope.gauge("resource_slots_cpu_pid_output");
        }
    }
}

