/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.retryer;

import io.grpc.Context;
import io.grpc.Deadline;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.temporal.api.workflowservice.v1.GetSystemInfoResponse;
import io.temporal.internal.BackoffThrottler;
import io.temporal.internal.retryer.GrpcRetryer;
import io.temporal.internal.retryer.GrpcRetryerUtils;
import io.temporal.serviceclient.RpcRetryOptions;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GrpcAsyncRetryer<R> {
    private static final Logger log = LoggerFactory.getLogger(GrpcRetryer.class);
    private final ScheduledExecutorService executor;
    private final GrpcRetryer.GrpcRetryerOptions options;
    private final GetSystemInfoResponse.Capabilities serverCapabilities;
    private final Supplier<CompletableFuture<R>> function;
    private final BackoffThrottler throttler;
    private final Deadline retriesExpirationDeadline;
    private StatusRuntimeException lastMeaningfulException = null;

    public GrpcAsyncRetryer(ScheduledExecutorService asyncThrottlerExecutor, Supplier<CompletableFuture<R>> function, GrpcRetryer.GrpcRetryerOptions options, GetSystemInfoResponse.Capabilities serverCapabilities) {
        options.validate();
        this.executor = asyncThrottlerExecutor;
        this.options = options;
        this.serverCapabilities = serverCapabilities;
        this.function = function;
        RpcRetryOptions rpcOptions = options.getOptions();
        this.retriesExpirationDeadline = GrpcRetryerUtils.mergeDurationWithAnAbsoluteDeadline(rpcOptions.getExpiration(), options.getDeadline());
        this.throttler = new BackoffThrottler(rpcOptions.getInitialInterval(), rpcOptions.getCongestionInitialInterval(), rpcOptions.getMaximumInterval(), rpcOptions.getBackoffCoefficient(), rpcOptions.getMaximumJitterCoefficient());
    }

    public CompletableFuture<R> retry() {
        CompletableFuture resultCF = new CompletableFuture();
        this.retry(resultCF);
        return resultCF;
    }

    private void retry(CompletableFuture<R> resultCF) {
        CompletableFuture throttleFuture = new CompletableFuture();
        ScheduledFuture ignored = this.executor.schedule(Context.current().wrap(() -> throttleFuture.complete(null)), this.throttler.getSleepTime(), TimeUnit.MILLISECONDS);
        throttleFuture.thenAccept(ignore -> {
            if (this.lastMeaningfulException != null) {
                log.debug("Retrying after failure", (Throwable)this.lastMeaningfulException);
            }
            try {
                CompletableFuture<Object> result = this.function.get();
                if (result == null) {
                    result = CompletableFuture.completedFuture(null);
                }
                result.whenComplete((r, e) -> {
                    if (e == null) {
                        this.throttler.success();
                        resultCF.complete(r);
                    } else {
                        this.throttler.failure(e instanceof StatusRuntimeException ? ((StatusRuntimeException)e).getStatus().getCode() : Status.Code.UNKNOWN);
                        this.failOrRetry((Throwable)e, resultCF);
                    }
                });
            }
            catch (Throwable e2) {
                this.throttler.failure(e2 instanceof StatusRuntimeException ? ((StatusRuntimeException)e2).getStatus().getCode() : Status.Code.UNKNOWN);
                this.failOrRetry(e2, resultCF);
            }
        });
    }

    private void failOrRetry(Throwable currentException, CompletableFuture<R> resultCF) {
        if (!((currentException = GrpcAsyncRetryer.unwrapCompletionException(currentException)) instanceof StatusRuntimeException)) {
            resultCF.completeExceptionally(currentException);
            return;
        }
        StatusRuntimeException statusRuntimeException = (StatusRuntimeException)currentException;
        RuntimeException finalException = GrpcRetryerUtils.createFinalExceptionIfNotRetryable(statusRuntimeException, this.options.getOptions(), this.serverCapabilities);
        if (finalException != null) {
            log.debug("Final exception, throwing", (Throwable)finalException);
            resultCF.completeExceptionally(finalException);
            return;
        }
        this.lastMeaningfulException = GrpcRetryerUtils.lastMeaningfulException(statusRuntimeException, this.lastMeaningfulException);
        if (GrpcRetryerUtils.ranOutOfRetries(this.options.getOptions(), this.throttler.getAttemptCount(), this.retriesExpirationDeadline, Context.current().getDeadline())) {
            log.debug("Out of retries, throwing", (Throwable)this.lastMeaningfulException);
            resultCF.completeExceptionally((Throwable)this.lastMeaningfulException);
        } else {
            this.retry(resultCF);
        }
    }

    private static Throwable unwrapCompletionException(Throwable e) {
        return e instanceof CompletionException ? e.getCause() : e;
    }
}

