/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.serviceclient;

import com.uber.m3.tally.Scope;
import com.uber.m3.tally.Stopwatch;
import com.uber.m3.util.ImmutableMap;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServiceDescriptor;
import io.grpc.Status;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.serviceclient.LongPollUtil;
import io.temporal.serviceclient.MetricsTag;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

class GrpcMetricsInterceptor
implements ClientInterceptor {
    private static final Map<Status.Code, Map<String, String>> STATUS_CODE_TAGS;
    private final Scope defaultScope;
    private final Map<MethodDescriptor<?, ?>, Map<String, String>> methodTags;

    GrpcMetricsInterceptor(Scope scope) {
        this.defaultScope = scope.tagged(MetricsTag.defaultTags("none"));
        ServiceDescriptor descriptor = WorkflowServiceGrpc.getServiceDescriptor();
        String serviceName = descriptor.getName();
        HashMap<MethodDescriptor, ImmutableMap> methodTags = new HashMap<MethodDescriptor, ImmutableMap>();
        Collection methods = descriptor.getMethods();
        for (MethodDescriptor method : methods) {
            int beginIndex = serviceName.length() + 1;
            String name = method.getFullMethodName().substring(beginIndex);
            ImmutableMap tags = new ImmutableMap.Builder(1).put((Object)"operation", (Object)name).build();
            methodTags.put(method, tags);
        }
        this.methodTags = Collections.unmodifiableMap(methodTags);
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        Scope scope = (Scope)callOptions.getOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY);
        if (scope == null) {
            scope = this.defaultScope;
        }
        Map<String, String> tags = this.methodTags.get(method);
        scope = scope.tagged(tags);
        return new MetricsClientCall<ReqT, RespT>(next, method, callOptions, scope);
    }

    static {
        EnumMap codeTags = new EnumMap(Status.Code.class);
        Arrays.stream(Status.Code.values()).forEach(code -> codeTags.put((Status.Code)code, new ImmutableMap.Builder(1).put((Object)"status_code", (Object)code.name()).build()));
        STATUS_CODE_TAGS = Collections.unmodifiableMap(codeTags);
    }

    private static class MetricsClientCall<ReqT, RespT>
    extends ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT> {
        private final Scope metricsScope;
        private final Stopwatch sw;
        private final boolean longPoll;

        MetricsClientCall(Channel next, MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Scope metricsScope) {
            super(next.newCall(method, callOptions));
            this.metricsScope = metricsScope;
            this.longPoll = LongPollUtil.isLongPoll(method, callOptions);
            if (this.longPoll) {
                metricsScope.counter("temporal_long_request").inc(1L);
                this.sw = metricsScope.timer("temporal_long_request_latency").start();
            } else {
                metricsScope.counter("temporal_request").inc(1L);
                this.sw = metricsScope.timer("temporal_request_latency").start();
            }
        }

        public void sendMessage(ReqT message) {
            super.sendMessage(message);
        }

        public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
            ForwardingClientCallListener.SimpleForwardingClientCallListener listener = new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onClose(Status status, Metadata trailers) {
                    try {
                        super.onClose(status, trailers);
                    }
                    finally {
                        sw.stop();
                        if (!status.isOk()) {
                            Scope scope = metricsScope.tagged((Map)STATUS_CODE_TAGS.get(status.getCode()));
                            if (longPoll) {
                                scope.counter("temporal_long_request_failure").inc(1L);
                            } else {
                                scope.counter("temporal_request_failure").inc(1L);
                            }
                        }
                    }
                }
            };
            super.start((ClientCall.Listener)listener, headers);
        }
    }
}

