/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.serviceclient.rpcretry;

import io.temporal.serviceclient.RpcRetryOptions;
import java.time.Duration;

public class DefaultStubServiceOperationRpcRetryOptions {
    public static final Duration INITIAL_INTERVAL = Duration.ofMillis(50L);
    public static final Duration CONGESTION_INITIAL_INTERVAL = Duration.ofMillis(1000L);
    public static final Duration EXPIRATION_INTERVAL = Duration.ofMinutes(1L);
    public static final Duration MAXIMUM_INTERVAL;
    public static final double BACKOFF = 2.0;
    public static final double MAXIMUM_JITTER_COEFFICIENT = 0.1;
    public static final RpcRetryOptions INSTANCE;

    public static RpcRetryOptions.Builder getBuilder() {
        return RpcRetryOptions.newBuilder().setInitialInterval(INITIAL_INTERVAL).setCongestionInitialInterval(CONGESTION_INITIAL_INTERVAL).setExpiration(EXPIRATION_INTERVAL).setBackoffCoefficient(2.0).setMaximumInterval(MAXIMUM_INTERVAL).setMaximumJitterCoefficient(0.1);
    }

    static {
        Duration maxInterval = EXPIRATION_INTERVAL.dividedBy(10L);
        if (maxInterval.compareTo(INITIAL_INTERVAL) < 0) {
            maxInterval = INITIAL_INTERVAL;
        }
        MAXIMUM_INTERVAL = maxInterval;
        INSTANCE = DefaultStubServiceOperationRpcRetryOptions.getBuilder().validateBuildWithDefaults();
    }
}

