/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.buffer;

import io.netty.buffer.ByteBuf;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.buffer.impl.BufferImpl;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.ClusterSerializable;
import io.vertx.core.shareddata.Shareable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Objects;

@VertxGen
public interface Buffer
extends ClusterSerializable,
Shareable {
    public static Buffer buffer() {
        return BufferImpl.buffer();
    }

    public static Buffer buffer(int initialSizeHint) {
        return BufferImpl.buffer(initialSizeHint);
    }

    public static Buffer buffer(String string) {
        return BufferImpl.buffer(string);
    }

    public static Buffer buffer(String string, String enc) {
        return BufferImpl.buffer(string, enc);
    }

    @GenIgnore(value={"permitted-type"})
    public static Buffer buffer(byte[] bytes) {
        return BufferImpl.buffer(bytes);
    }

    @Deprecated
    @GenIgnore(value={"permitted-type"})
    public static Buffer buffer(ByteBuf byteBuf) {
        Objects.requireNonNull(byteBuf);
        return BufferImpl.buffer(byteBuf);
    }

    public String toString();

    public String toString(String var1);

    @GenIgnore(value={"permitted-type"})
    public String toString(Charset var1);

    public JsonObject toJsonObject();

    public JsonArray toJsonArray();

    default public Object toJsonValue() {
        return Json.CODEC.fromBuffer(this, Object.class);
    }

    @Deprecated
    default public Object toJson() {
        return this.toJsonValue();
    }

    public byte getByte(int var1);

    public short getUnsignedByte(int var1);

    public int getInt(int var1);

    public int getIntLE(int var1);

    public long getUnsignedInt(int var1);

    public long getUnsignedIntLE(int var1);

    public long getLong(int var1);

    public long getLongLE(int var1);

    public double getDouble(int var1);

    public float getFloat(int var1);

    public short getShort(int var1);

    public short getShortLE(int var1);

    public int getUnsignedShort(int var1);

    public int getUnsignedShortLE(int var1);

    public int getMedium(int var1);

    public int getMediumLE(int var1);

    public int getUnsignedMedium(int var1);

    public int getUnsignedMediumLE(int var1);

    @GenIgnore(value={"permitted-type"})
    public byte[] getBytes();

    @GenIgnore(value={"permitted-type"})
    public byte[] getBytes(int var1, int var2);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public Buffer getBytes(byte[] var1);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public Buffer getBytes(byte[] var1, int var2);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public Buffer getBytes(int var1, int var2, byte[] var3);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public Buffer getBytes(int var1, int var2, byte[] var3, int var4);

    public Buffer getBuffer(int var1, int var2);

    public String getString(int var1, int var2, String var3);

    public String getString(int var1, int var2);

    @Fluent
    public Buffer appendBuffer(Buffer var1);

    @Fluent
    public Buffer appendBuffer(Buffer var1, int var2, int var3);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public Buffer appendBytes(byte[] var1);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public Buffer appendBytes(byte[] var1, int var2, int var3);

    @Fluent
    public Buffer appendByte(byte var1);

    @Fluent
    public Buffer appendUnsignedByte(short var1);

    @Fluent
    public Buffer appendInt(int var1);

    @Fluent
    public Buffer appendIntLE(int var1);

    @Fluent
    public Buffer appendUnsignedInt(long var1);

    @Fluent
    public Buffer appendUnsignedIntLE(long var1);

    @Fluent
    public Buffer appendMedium(int var1);

    @Fluent
    public Buffer appendMediumLE(int var1);

    @Fluent
    public Buffer appendLong(long var1);

    @Fluent
    public Buffer appendLongLE(long var1);

    @Fluent
    public Buffer appendShort(short var1);

    @Fluent
    public Buffer appendShortLE(short var1);

    @Fluent
    public Buffer appendUnsignedShort(int var1);

    @Fluent
    public Buffer appendUnsignedShortLE(int var1);

    @Fluent
    public Buffer appendFloat(float var1);

    @Fluent
    public Buffer appendDouble(double var1);

    @Fluent
    public Buffer appendString(String var1, String var2);

    @Fluent
    public Buffer appendString(String var1);

    @Fluent
    public Buffer setByte(int var1, byte var2);

    @Fluent
    public Buffer setUnsignedByte(int var1, short var2);

    @Fluent
    public Buffer setInt(int var1, int var2);

    @Fluent
    public Buffer setIntLE(int var1, int var2);

    @Fluent
    public Buffer setUnsignedInt(int var1, long var2);

    @Fluent
    public Buffer setUnsignedIntLE(int var1, long var2);

    @Fluent
    public Buffer setMedium(int var1, int var2);

    @Fluent
    public Buffer setMediumLE(int var1, int var2);

    @Fluent
    public Buffer setLong(int var1, long var2);

    @Fluent
    public Buffer setLongLE(int var1, long var2);

    @Fluent
    public Buffer setDouble(int var1, double var2);

    @Fluent
    public Buffer setFloat(int var1, float var2);

    @Fluent
    public Buffer setShort(int var1, short var2);

    @Fluent
    public Buffer setShortLE(int var1, short var2);

    @Fluent
    public Buffer setUnsignedShort(int var1, int var2);

    @Fluent
    public Buffer setUnsignedShortLE(int var1, int var2);

    @Fluent
    public Buffer setBuffer(int var1, Buffer var2);

    @Fluent
    public Buffer setBuffer(int var1, Buffer var2, int var3, int var4);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public Buffer setBytes(int var1, ByteBuffer var2);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public Buffer setBytes(int var1, byte[] var2);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public Buffer setBytes(int var1, byte[] var2, int var3, int var4);

    @Fluent
    public Buffer setString(int var1, String var2);

    @Fluent
    public Buffer setString(int var1, String var2, String var3);

    public int length();

    @Override
    public Buffer copy();

    public Buffer slice();

    public Buffer slice(int var1, int var2);

    @Deprecated
    @GenIgnore(value={"permitted-type"})
    public ByteBuf getByteBuf();
}

