/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.pgclient.impl.PgPoolOptions;
import io.vertx.pgclient.spi.PgDriver;
import io.vertx.sqlclient.ClientBuilder;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.impl.ClientBuilderBase;
import io.vertx.sqlclient.spi.Driver;
import java.util.function.Supplier;

@VertxGen
public interface PgBuilder {
    public static Pool pool(Handler<ClientBuilder<Pool>> block) {
        return ClientBuilder.pool((Driver)PgDriver.INSTANCE, block);
    }

    public static ClientBuilder<Pool> pool() {
        return ClientBuilder.pool((Driver)PgDriver.INSTANCE);
    }

    public static SqlClient client(Handler<ClientBuilder<SqlClient>> handler) {
        ClientBuilder<SqlClient> builder = PgBuilder.client();
        handler.handle(builder);
        return (SqlClient)builder.build();
    }

    public static ClientBuilder<SqlClient> client() {
        return new ClientBuilderBase<SqlClient>((Driver)PgDriver.INSTANCE){

            public ClientBuilder<SqlClient> with(PoolOptions options) {
                if (options != null) {
                    options = new PgPoolOptions(options).setPipelined(true);
                }
                return super.with(options);
            }

            protected SqlClient create(Vertx vertx, Supplier<Future<SqlConnectOptions>> databases, PoolOptions poolOptions) {
                return this.driver.createPool(vertx, databases, poolOptions);
            }
        };
    }
}

