/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.sqlclient.PropertyKind;
import io.vertx.sqlclient.SqlResult;
import io.vertx.sqlclient.impl.PropertyKindMap;
import io.vertx.sqlclient.impl.QueryResultHandler;
import io.vertx.sqlclient.impl.RowDesc;
import io.vertx.sqlclient.impl.SqlResultBase;
import java.util.function.Function;

public class QueryResultBuilder<T, R extends SqlResultBase<T>, L extends SqlResult<T>>
implements QueryResultHandler<T>,
Promise<Boolean> {
    private final Promise<L> handler;
    private final Function<T, R> factory;
    public R first;
    private R current;
    private Throwable failure;
    private boolean suspended;

    QueryResultBuilder(Function<T, R> factory, PromiseInternal<L> handler) {
        this.factory = factory;
        this.handler = handler;
    }

    @Override
    public void handleResult(int updatedCount, int size, RowDesc desc, T result, Throwable failure) {
        if (failure != null) {
            this.failure = failure;
        } else {
            SqlResultBase r = (SqlResultBase)this.factory.apply(result);
            r.updated = updatedCount;
            r.size = size;
            r.columnNames = desc != null ? desc.columnNames() : null;
            r.columnDescriptors = desc != null ? desc.columnDescriptor() : null;
            this.handleResult(r);
        }
    }

    private void handleResult(R result) {
        R c = this.current;
        if (c == null) {
            this.first = result;
            this.current = result;
        } else {
            ((SqlResultBase)c).next = result;
            this.current = result;
        }
    }

    @Override
    public <V> void addProperty(PropertyKind<V> property, V value) {
        R r = this.current;
        if (r != null) {
            if (((SqlResultBase)r).properties == null) {
                ((SqlResultBase)r).properties = new PropertyKindMap();
            }
            ((SqlResultBase)r).properties.put(property, value);
        }
    }

    public boolean tryComplete(Boolean result) {
        this.suspended = result;
        if (this.failure != null) {
            return this.tryFail(this.failure);
        }
        return this.handler.tryComplete(this.first);
    }

    public boolean tryFail(Throwable cause) {
        return this.handler.tryFail(cause);
    }

    public Future<Boolean> future() {
        return this.handler.future().map(l -> this.isSuspended());
    }

    public boolean isSuspended() {
        return this.suspended;
    }
}

