/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.spring.boot.starter.actuate;

import java.util.HashMap;
import java.util.Map;
import me.ahoo.cosid.IdGenerator;
import me.ahoo.cosid.provider.IdGeneratorProvider;
import me.ahoo.cosid.stat.generator.IdGeneratorStat;
import org.springframework.boot.actuate.endpoint.annotation.DeleteOperation;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;

@Endpoint(id="cosid")
public class CosIdEndpoint {
    private final IdGeneratorProvider idGeneratorProvider;

    public CosIdEndpoint(IdGeneratorProvider idGeneratorProvider) {
        this.idGeneratorProvider = idGeneratorProvider;
    }

    @ReadOperation
    public Map<String, IdGeneratorStat> stat() {
        HashMap<String, IdGeneratorStat> statMap = new HashMap<String, IdGeneratorStat>();
        for (Map.Entry entry : this.idGeneratorProvider.entries()) {
            IdGeneratorStat stat = ((IdGenerator)entry.getValue()).stat();
            statMap.put((String)entry.getKey(), stat);
        }
        return statMap;
    }

    @ReadOperation
    public IdGeneratorStat getStat(@Selector String name) {
        IdGenerator idGenerator = this.idGeneratorProvider.getRequired(name);
        return idGenerator.stat();
    }

    @DeleteOperation
    public IdGeneratorStat remove(@Selector String name) {
        IdGenerator idGenerator = this.idGeneratorProvider.remove(name);
        return idGenerator.stat();
    }
}

