/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.spring.boot.starter.machine;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Objects;
import me.ahoo.cosid.machine.ClockBackwardsSynchronizer;
import me.ahoo.cosid.machine.DefaultClockBackwardsSynchronizer;
import me.ahoo.cosid.machine.DefaultMachineIdGuarder;
import me.ahoo.cosid.machine.HostAddressSupplier;
import me.ahoo.cosid.machine.InstanceId;
import me.ahoo.cosid.machine.LocalMachineStateStorage;
import me.ahoo.cosid.machine.MachineId;
import me.ahoo.cosid.machine.MachineIdDistributor;
import me.ahoo.cosid.machine.MachineIdGuarder;
import me.ahoo.cosid.machine.MachineStateStorage;
import me.ahoo.cosid.machine.ManualMachineIdDistributor;
import me.ahoo.cosid.machine.k8s.StatefulSetMachineIdDistributor;
import me.ahoo.cosid.spring.boot.starter.ConditionalOnCosIdEnabled;
import me.ahoo.cosid.spring.boot.starter.CosIdProperties;
import me.ahoo.cosid.spring.boot.starter.machine.ConditionalOnCosIdMachineEnabled;
import me.ahoo.cosid.spring.boot.starter.machine.CosIdLifecycleMachineIdDistributor;
import me.ahoo.cosid.spring.boot.starter.machine.CosIdLifecycleMachineIdGuarder;
import me.ahoo.cosid.spring.boot.starter.machine.MachineProperties;
import me.ahoo.cosid.util.ProcessId;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnCosIdEnabled
@ConditionalOnCosIdMachineEnabled
@EnableConfigurationProperties(value={MachineProperties.class})
public class CosIdMachineAutoConfiguration {
    private final CosIdProperties cosIdProperties;
    private final MachineProperties machineProperties;

    public CosIdMachineAutoConfiguration(CosIdProperties cosIdProperties, MachineProperties machineProperties) {
        this.cosIdProperties = cosIdProperties;
        this.machineProperties = machineProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public InstanceId instanceId(HostAddressSupplier hostAddressSupplier) {
        boolean stable = Boolean.TRUE.equals(this.machineProperties.getStable());
        if (!Strings.isNullOrEmpty((String)this.machineProperties.getInstanceId())) {
            return InstanceId.of((String)this.machineProperties.getInstanceId(), (boolean)stable);
        }
        int port = ProcessId.CURRENT.getProcessId();
        if (Objects.nonNull(this.machineProperties.getPort()) && this.machineProperties.getPort() > 0) {
            port = this.machineProperties.getPort();
        }
        return InstanceId.of((String)hostAddressSupplier.getHostAddress(), (int)port, (boolean)stable);
    }

    @Bean
    @ConditionalOnMissingBean(value={MachineId.class})
    public MachineId machineId(MachineIdDistributor machineIdDistributor, InstanceId instanceId) {
        int machineId = machineIdDistributor.distribute(this.cosIdProperties.getNamespace(), this.machineProperties.getMachineBit(), instanceId, this.machineProperties.getSafeGuardDuration()).getMachineId();
        return new MachineId(machineId);
    }

    @Bean
    @ConditionalOnMissingBean
    public MachineStateStorage machineStateStorage() {
        if (Boolean.TRUE.equals(this.machineProperties.getStable())) {
            return new LocalMachineStateStorage(this.machineProperties.getStateStorage().getLocal().getStateLocation());
        }
        return MachineStateStorage.IN_MEMORY;
    }

    @Bean
    @ConditionalOnMissingBean
    public ClockBackwardsSynchronizer clockBackwardsSynchronizer() {
        MachineProperties.ClockBackwards clockBackwards = this.machineProperties.getClockBackwards();
        Preconditions.checkNotNull((Object)clockBackwards, (Object)"cosid.machine.clockBackwards can not be null.");
        return new DefaultClockBackwardsSynchronizer(clockBackwards.getSpinThreshold(), clockBackwards.getBrokenThreshold());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"cosid.machine.distributor.type"}, matchIfMissing=true, havingValue="manual")
    public ManualMachineIdDistributor machineIdDistributor(MachineStateStorage localMachineState, ClockBackwardsSynchronizer clockBackwardsSynchronizer) {
        MachineProperties.Manual manual = this.machineProperties.getDistributor().getManual();
        Preconditions.checkNotNull((Object)manual, (Object)"cosid.machine.distributor.manual can not be null.");
        Integer machineId = manual.getMachineId();
        Preconditions.checkNotNull((Object)machineId, (Object)"cosid.machine.distributor.manual.machineId can not be null.");
        Preconditions.checkArgument((machineId >= 0 ? 1 : 0) != 0, (Object)"cosid.machine.distributor.manual.machineId can not be less than 0.");
        return new ManualMachineIdDistributor(machineId.intValue(), localMachineState, clockBackwardsSynchronizer);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"cosid.machine.distributor.type"}, havingValue="stateful_set")
    public StatefulSetMachineIdDistributor statefulSetMachineIdDistributor(MachineStateStorage localMachineState, ClockBackwardsSynchronizer clockBackwardsSynchronizer) {
        return new StatefulSetMachineIdDistributor(localMachineState, clockBackwardsSynchronizer);
    }

    @Bean
    @ConditionalOnMissingBean
    public CosIdLifecycleMachineIdDistributor cosIdLifecycleMachineIdDistributor(InstanceId instanceId, MachineIdDistributor machineIdDistributor) {
        return new CosIdLifecycleMachineIdDistributor(this.cosIdProperties, instanceId, machineIdDistributor);
    }

    @Bean
    @ConditionalOnMissingBean
    public MachineIdGuarder machineIdGuarder(MachineIdDistributor machineIdDistributor) {
        MachineProperties.Guarder guarder = this.machineProperties.getGuarder();
        if (!guarder.isEnabled()) {
            return MachineIdGuarder.NONE;
        }
        return new DefaultMachineIdGuarder(machineIdDistributor, DefaultMachineIdGuarder.executorService(), guarder.getInitialDelay(), guarder.getDelay(), this.machineProperties.getSafeGuardDuration());
    }

    @Bean
    @ConditionalOnMissingBean
    public CosIdLifecycleMachineIdGuarder cosIdLifecycleMachineIdGuarder(InstanceId instanceId, MachineIdGuarder machineIdGuarder) {
        return new CosIdLifecycleMachineIdGuarder(this.cosIdProperties, instanceId, machineIdGuarder);
    }
}

