/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.spring.boot.starter.machine;

import java.time.Duration;
import me.ahoo.cosid.machine.DefaultMachineIdGuarder;
import me.ahoo.cosid.machine.LocalMachineStateStorage;
import me.ahoo.cosid.machine.MachineIdDistributor;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="cosid.machine")
public class MachineProperties {
    public static final String PREFIX = "cosid.machine";
    private boolean enabled = false;
    private Boolean stable;
    private Integer port;
    private String instanceId;
    private int machineBit = 10;
    private StateStorage stateStorage = new StateStorage();
    private Distributor distributor = new Distributor();
    private Guarder guarder = new Guarder();
    private ClockBackwards clockBackwards = new ClockBackwards();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getStable() {
        return this.stable;
    }

    public void setStable(Boolean stable) {
        this.stable = stable;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public int getMachineBit() {
        return this.machineBit;
    }

    public void setMachineBit(int machineBit) {
        this.machineBit = machineBit;
    }

    public StateStorage getStateStorage() {
        return this.stateStorage;
    }

    public void setStateStorage(StateStorage stateStorage) {
        this.stateStorage = stateStorage;
    }

    public Distributor getDistributor() {
        return this.distributor;
    }

    public void setDistributor(Distributor distributor) {
        this.distributor = distributor;
    }

    public Guarder getGuarder() {
        return this.guarder;
    }

    public MachineProperties setGuarder(Guarder guarder) {
        this.guarder = guarder;
        return this;
    }

    public ClockBackwards getClockBackwards() {
        return this.clockBackwards;
    }

    public void setClockBackwards(ClockBackwards clockBackwards) {
        this.clockBackwards = clockBackwards;
    }

    public Duration getSafeGuardDuration() {
        Guarder guarder = this.getGuarder();
        if (guarder.isEnabled()) {
            return guarder.getSafeGuardDuration();
        }
        return MachineIdDistributor.FOREVER_SAFE_GUARD_DURATION;
    }

    public static class StateStorage {
        private Local local = new Local();

        public Local getLocal() {
            return this.local;
        }

        public void setLocal(Local local) {
            this.local = local;
        }

        public static class Local {
            private String stateLocation = LocalMachineStateStorage.DEFAULT_STATE_LOCATION_PATH;

            public String getStateLocation() {
                return this.stateLocation;
            }

            public void setStateLocation(String stateLocation) {
                this.stateLocation = stateLocation;
            }
        }
    }

    public static class Distributor {
        public static final String TYPE = "cosid.machine.distributor.type";
        private Type type = Type.MANUAL;
        private Manual manual;
        private Redis redis = new Redis();
        private Mongo mongo = new Mongo();

        public Type getType() {
            return this.type;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public Manual getManual() {
            return this.manual;
        }

        public void setManual(Manual manual) {
            this.manual = manual;
        }

        public Redis getRedis() {
            return this.redis;
        }

        public void setRedis(Redis redis) {
            this.redis = redis;
        }

        public Mongo getMongo() {
            return this.mongo;
        }

        public void setMongo(Mongo mongo) {
            this.mongo = mongo;
        }

        public static enum Type {
            MANUAL,
            STATEFUL_SET,
            JDBC,
            MONGO,
            REDIS,
            ZOOKEEPER,
            PROXY;

        }
    }

    public static class Guarder {
        private boolean enabled = true;
        private Duration initialDelay = DefaultMachineIdGuarder.DEFAULT_INITIAL_DELAY;
        private Duration delay = DefaultMachineIdGuarder.DEFAULT_DELAY;
        private Duration safeGuardDuration = Duration.ofMinutes(5L);

        public boolean isEnabled() {
            return this.enabled;
        }

        public Guarder setEnabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Duration getInitialDelay() {
            return this.initialDelay;
        }

        public Guarder setInitialDelay(Duration initialDelay) {
            this.initialDelay = initialDelay;
            return this;
        }

        public Duration getDelay() {
            return this.delay;
        }

        public Guarder setDelay(Duration delay) {
            this.delay = delay;
            return this;
        }

        public Duration getSafeGuardDuration() {
            return this.safeGuardDuration;
        }

        public Guarder setSafeGuardDuration(Duration safeGuardDuration) {
            this.safeGuardDuration = safeGuardDuration;
            return this;
        }
    }

    public static class ClockBackwards {
        private int spinThreshold = 1;
        private int brokenThreshold = 500;

        public int getSpinThreshold() {
            return this.spinThreshold;
        }

        public void setSpinThreshold(int spinThreshold) {
            this.spinThreshold = spinThreshold;
        }

        public int getBrokenThreshold() {
            return this.brokenThreshold;
        }

        public void setBrokenThreshold(int brokenThreshold) {
            this.brokenThreshold = brokenThreshold;
        }
    }

    public static class Mongo {
        private String database = "cosid_db";

        public String getDatabase() {
            return this.database;
        }

        public void setDatabase(String database) {
            this.database = database;
        }
    }

    public static class Redis {
        private Duration timeout = Duration.ofSeconds(1L);

        public Duration getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Duration timeout) {
            this.timeout = timeout;
        }
    }

    public static class Manual {
        private Integer machineId;

        public Integer getMachineId() {
            return this.machineId;
        }

        public void setMachineId(Integer machineId) {
            this.machineId = machineId;
        }
    }
}

