/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.activiti.bpmn.converter.BaseBpmnXMLConverter;
import org.activiti.bpmn.converter.child.BaseChildElementParser;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.IOParameter;
import org.apache.commons.lang3.StringUtils;

public class CallActivityXMLConverter
extends BaseBpmnXMLConverter {
    protected Map<String, BaseChildElementParser> childParserMap = new HashMap<String, BaseChildElementParser>();

    public CallActivityXMLConverter() {
        InParameterParser inParameterParser = new InParameterParser();
        this.childParserMap.put(inParameterParser.getElementName(), inParameterParser);
        OutParameterParser outParameterParser = new OutParameterParser();
        this.childParserMap.put(outParameterParser.getElementName(), outParameterParser);
    }

    @Override
    public Class<? extends BaseElement> getBpmnElementType() {
        return CallActivity.class;
    }

    @Override
    protected String getXMLElementName() {
        return "callActivity";
    }

    @Override
    protected BaseElement convertXMLToElement(XMLStreamReader xtr, BpmnModel model) throws Exception {
        CallActivity callActivity = new CallActivity();
        BpmnXMLUtil.addXMLLocation((BaseElement)callActivity, xtr);
        callActivity.setCalledElement(xtr.getAttributeValue(null, "calledElement"));
        callActivity.setBusinessKey(xtr.getAttributeValue("http://activiti.org/bpmn", "businessKey"));
        callActivity.setInheritBusinessKey(Boolean.parseBoolean(xtr.getAttributeValue("http://activiti.org/bpmn", "inheritBusinessKey")));
        callActivity.setInheritVariables(Boolean.valueOf(xtr.getAttributeValue("http://activiti.org/bpmn", "inheritVariables")).booleanValue());
        this.parseChildElements(this.getXMLElementName(), (BaseElement)callActivity, this.childParserMap, model, xtr);
        return callActivity;
    }

    @Override
    protected void writeAdditionalAttributes(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        CallActivity callActivity = (CallActivity)element;
        if (StringUtils.isNotEmpty((CharSequence)callActivity.getCalledElement())) {
            xtw.writeAttribute("calledElement", callActivity.getCalledElement());
        }
        if (StringUtils.isNotEmpty((CharSequence)callActivity.getBusinessKey())) {
            this.writeQualifiedAttribute("businessKey", callActivity.getBusinessKey(), xtw);
        }
        if (callActivity.isInheritBusinessKey()) {
            this.writeQualifiedAttribute("inheritBusinessKey", "true", xtw);
        }
        if (callActivity.isInheritVariables()) {
            xtw.writeAttribute("http://activiti.org/bpmn", "inheritVariables", String.valueOf(callActivity.isInheritVariables()));
        }
    }

    @Override
    protected boolean writeExtensionChildElements(BaseElement element, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        CallActivity callActivity = (CallActivity)element;
        didWriteExtensionStartElement = this.writeIOParameters("in", callActivity.getInParameters(), didWriteExtensionStartElement, xtw);
        didWriteExtensionStartElement = this.writeIOParameters("out", callActivity.getOutParameters(), didWriteExtensionStartElement, xtw);
        return didWriteExtensionStartElement;
    }

    @Override
    protected void writeAdditionalChildElements(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
    }

    private boolean writeIOParameters(String elementName, List<IOParameter> parameterList, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        if (parameterList.isEmpty()) {
            return didWriteExtensionStartElement;
        }
        for (IOParameter ioParameter : parameterList) {
            if (!didWriteExtensionStartElement) {
                xtw.writeStartElement("extensionElements");
                didWriteExtensionStartElement = true;
            }
            xtw.writeStartElement("activiti", elementName, "http://activiti.org/bpmn");
            if (StringUtils.isNotEmpty((CharSequence)ioParameter.getSource())) {
                this.writeDefaultAttribute("source", ioParameter.getSource(), xtw);
            }
            if (StringUtils.isNotEmpty((CharSequence)ioParameter.getSourceExpression())) {
                this.writeDefaultAttribute("sourceExpression", ioParameter.getSourceExpression(), xtw);
            }
            if (StringUtils.isNotEmpty((CharSequence)ioParameter.getTarget())) {
                this.writeDefaultAttribute("target", ioParameter.getTarget(), xtw);
            }
            xtw.writeEndElement();
        }
        return didWriteExtensionStartElement;
    }

    public class OutParameterParser
    extends BaseChildElementParser {
        @Override
        public String getElementName() {
            return "out";
        }

        @Override
        public void parseChildElement(XMLStreamReader xtr, BaseElement parentElement, BpmnModel model) throws Exception {
            String source = xtr.getAttributeValue(null, "source");
            String sourceExpression = xtr.getAttributeValue(null, "sourceExpression");
            String target = xtr.getAttributeValue(null, "target");
            if ((StringUtils.isNotEmpty((CharSequence)source) || StringUtils.isNotEmpty((CharSequence)sourceExpression)) && StringUtils.isNotEmpty((CharSequence)target)) {
                IOParameter parameter = new IOParameter();
                if (StringUtils.isNotEmpty((CharSequence)sourceExpression)) {
                    parameter.setSourceExpression(sourceExpression);
                } else {
                    parameter.setSource(source);
                }
                parameter.setTarget(target);
                ((CallActivity)parentElement).getOutParameters().add(parameter);
            }
        }
    }

    public class InParameterParser
    extends BaseChildElementParser {
        @Override
        public String getElementName() {
            return "in";
        }

        @Override
        public void parseChildElement(XMLStreamReader xtr, BaseElement parentElement, BpmnModel model) throws Exception {
            String source = xtr.getAttributeValue(null, "source");
            String sourceExpression = xtr.getAttributeValue(null, "sourceExpression");
            String target = xtr.getAttributeValue(null, "target");
            if ((StringUtils.isNotEmpty((CharSequence)source) || StringUtils.isNotEmpty((CharSequence)sourceExpression)) && StringUtils.isNotEmpty((CharSequence)target)) {
                IOParameter parameter = new IOParameter();
                if (StringUtils.isNotEmpty((CharSequence)sourceExpression)) {
                    parameter.setSourceExpression(sourceExpression);
                } else {
                    parameter.setSource(source);
                }
                parameter.setTarget(target);
                ((CallActivity)parentElement).getInParameters().add(parameter);
            }
        }
    }
}

