/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.runtime.conf;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleAbstractTypeResolver;
import com.fasterxml.jackson.databind.module.SimpleModule;
import org.activiti.runtime.api.EmptyResult;
import org.activiti.runtime.api.Payload;
import org.activiti.runtime.api.Result;
import org.activiti.runtime.api.model.VariableInstance;
import org.activiti.runtime.api.model.impl.VariableInstanceImpl;
import org.activiti.runtime.conf.PayloadMixIn;
import org.activiti.runtime.conf.ResultMixIn;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@PropertySource(value={"classpath:conf/rest-jackson-configuration.properties"})
public class CommonModelAutoConfiguration {
    @Bean
    public Module customizeCommonModelObjectMapper() {
        SimpleModule module = new SimpleModule("mapCommonModelInterfaces", Version.unknownVersion());
        SimpleAbstractTypeResolver resolver = new SimpleAbstractTypeResolver(){

            public JavaType resolveAbstractType(DeserializationConfig config, BeanDescription typeDesc) {
                return this.findTypeMapping(config, typeDesc.getType());
            }
        };
        resolver.addMapping(VariableInstance.class, VariableInstanceImpl.class);
        module.setAbstractTypes(resolver);
        module.setMixInAnnotation(Payload.class, PayloadMixIn.class);
        module.setMixInAnnotation(Result.class, ResultMixIn.class);
        module.registerSubtypes(new NamedType[]{new NamedType(EmptyResult.class, EmptyResult.class.getSimpleName())});
        return module;
    }
}

