/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.activiti.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.process.ActivityImpl;

public class BoundaryEventActivityBehavior
extends FlowNodeActivityBehavior {
    protected boolean interrupting;
    protected String activityId;

    public BoundaryEventActivityBehavior() {
    }

    public BoundaryEventActivityBehavior(boolean interrupting, String activityId) {
        this.interrupting = interrupting;
        this.activityId = activityId;
    }

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        ActivityImpl boundaryActivity = executionEntity.getProcessDefinition().findActivity(this.activityId);
        ActivityImpl interruptedActivity = executionEntity.getActivity();
        executionEntity.setActivity(boundaryActivity);
        List<PvmTransition> outgoingTransitions = boundaryActivity.getOutgoingTransitions();
        ArrayList<ActivityExecution> interruptedExecutions = null;
        if (this.interrupting) {
            if (executionEntity.getSubProcessInstance() != null) {
                executionEntity.getSubProcessInstance().deleteCascade(executionEntity.getDeleteReason());
            }
            interruptedExecutions = new ArrayList<ActivityExecution>(executionEntity.getExecutions());
            for (ExecutionEntity executionEntity2 : interruptedExecutions) {
                executionEntity2.deleteCascade("interrupting boundary event '" + execution.getActivity().getId() + "' fired");
            }
            execution.takeAll(outgoingTransitions, interruptedExecutions);
        } else {
            ExecutionEntity executionEntity3 = executionEntity.getParent().isConcurrent() ? executionEntity.getParent() : executionEntity;
            ExecutionEntity outgoingExecution = executionEntity3.createExecution();
            outgoingExecution.setActive(true);
            outgoingExecution.setScope(false);
            outgoingExecution.setConcurrent(true);
            outgoingExecution.takeAll(outgoingTransitions, Collections.EMPTY_LIST);
            outgoingExecution.remove();
            executionEntity.setActivity(interruptedActivity);
        }
    }

    public boolean isInterrupting() {
        return this.interrupting;
    }

    public void setInterrupting(boolean interrupting) {
        this.interrupting = interrupting;
    }
}

