/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.diagram;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.bpmn.diagram.Bpmn20NamespaceContext;
import org.activiti.engine.repository.DiagramElement;
import org.activiti.engine.repository.DiagramLayout;
import org.activiti.engine.repository.DiagramNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProcessDiagramLayoutFactory {
    private static final int GREY_THRESHOLD = 175;

    public DiagramLayout getProcessDiagramLayout(InputStream bpmnXmlStream, InputStream imageStream) {
        Document bpmnModel = this.parseXml(bpmnXmlStream);
        return this.getBpmnProcessDiagramLayout(bpmnModel, imageStream);
    }

    public DiagramLayout getBpmnProcessDiagramLayout(Document bpmnModel, InputStream imageStream) {
        DiagramNode diagramBoundsImage;
        if (imageStream == null) {
            return null;
        }
        DiagramNode diagramBoundsXml = this.getDiagramBoundsFromBpmnDi(bpmnModel);
        if (this.isExportedFromAdonis50(bpmnModel)) {
            int offsetTop = 29;
            int offsetBottom = 61;
            diagramBoundsImage = this.getDiagramBoundsFromImage(imageStream, offsetTop, offsetBottom);
        } else {
            diagramBoundsImage = this.getDiagramBoundsFromImage(imageStream);
        }
        HashMap<String, DiagramNode> listOfBounds = new HashMap<String, DiagramNode>();
        listOfBounds.put(diagramBoundsXml.getId(), diagramBoundsXml);
        listOfBounds.putAll(this.fixFlowNodePositionsIfModelFromAdonis(bpmnModel, this.getElementBoundsFromBpmnDi(bpmnModel)));
        Map<String, DiagramElement> listOfBoundsForImage = this.transformBoundsForImage(diagramBoundsImage, diagramBoundsXml, listOfBounds);
        return new DiagramLayout(listOfBoundsForImage);
    }

    protected Document parseXml(InputStream bpmnXmlStream) {
        Document bpmnModel;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            bpmnModel = builder.parse(bpmnXmlStream);
        }
        catch (Exception e) {
            throw new ActivitiException("Error while parsing BPMN model.", e);
        }
        return bpmnModel;
    }

    protected DiagramNode getDiagramBoundsFromBpmnDi(Document bpmnModel) {
        Double minX = null;
        Double minY = null;
        Double maxX = null;
        Double maxY = null;
        NodeList setOfBounds = bpmnModel.getElementsByTagNameNS("http://www.omg.org/spec/DD/20100524/DC", "Bounds");
        int i = 0;
        while (i < setOfBounds.getLength()) {
            Element element = (Element)setOfBounds.item(i);
            Double x = Double.valueOf(element.getAttribute("x"));
            Double y = Double.valueOf(element.getAttribute("y"));
            Double width = Double.valueOf(element.getAttribute("width"));
            Double height = Double.valueOf(element.getAttribute("height"));
            if (x != 0.0 || y != 0.0 || width != 0.0 || height != 0.0) {
                if (minX == null || x < minX) {
                    minX = x;
                }
                if (minY == null || y < minY) {
                    minY = y;
                }
                if (maxX == null || maxX < x + width) {
                    maxX = x + width;
                }
                if (maxY == null || maxY < y + height) {
                    maxY = y + height;
                }
            }
            ++i;
        }
        NodeList waypoints = bpmnModel.getElementsByTagNameNS("http://www.omg.org/spec/DD/20100524/DI", "waypoint");
        int i2 = 0;
        while (i2 < waypoints.getLength()) {
            Element waypoint = (Element)waypoints.item(i2);
            Double x = Double.valueOf(waypoint.getAttribute("x"));
            Double y = Double.valueOf(waypoint.getAttribute("y"));
            if (minX == null || x < minX) {
                minX = x;
            }
            if (minY == null || y < minY) {
                minY = y;
            }
            if (maxX == null || maxX < x) {
                maxX = x;
            }
            if (maxY == null || maxY < y) {
                maxY = y;
            }
            ++i2;
        }
        DiagramNode diagramBounds = new DiagramNode("BPMNDiagram");
        diagramBounds.setX(minX);
        diagramBounds.setY(minY);
        diagramBounds.setWidth(maxX - minX);
        diagramBounds.setHeight(maxY - minY);
        return diagramBounds;
    }

    protected DiagramNode getDiagramBoundsFromImage(InputStream imageStream) {
        return this.getDiagramBoundsFromImage(imageStream, 0, 0);
    }

    protected DiagramNode getDiagramBoundsFromImage(InputStream imageStream, int offsetTop, int offsetBottom) {
        BufferedImage image;
        try {
            image = ImageIO.read(imageStream);
        }
        catch (IOException e) {
            throw new ActivitiException("Error while reading process diagram image.", e);
        }
        DiagramNode diagramBoundsImage = this.getDiagramBoundsFromImage(image, offsetTop, offsetBottom);
        return diagramBoundsImage;
    }

    protected DiagramNode getDiagramBoundsFromImage(BufferedImage image, int offsetTop, int offsetBottom) {
        int width = image.getWidth();
        int height = image.getHeight();
        TreeMap<Integer, Boolean> rowIsWhite = new TreeMap<Integer, Boolean>();
        TreeMap<Integer, Boolean> columnIsWhite = new TreeMap<Integer, Boolean>();
        int row = 0;
        while (row < height) {
            if (!rowIsWhite.containsKey(row)) {
                rowIsWhite.put(row, true);
            }
            if (row <= offsetTop || row > image.getHeight() - offsetBottom) {
                rowIsWhite.put(row, true);
            } else {
                int column = 0;
                while (column < width) {
                    if (!columnIsWhite.containsKey(column)) {
                        columnIsWhite.put(column, true);
                    }
                    int pixel = image.getRGB(column, row);
                    int alpha = pixel >> 24 & 0xFF;
                    int red = pixel >> 16 & 0xFF;
                    int green = pixel >> 8 & 0xFF;
                    int blue = pixel >> 0 & 0xFF;
                    if (alpha != 0 && (red < 175 || green < 175 || blue < 175)) {
                        rowIsWhite.put(row, false);
                        columnIsWhite.put(column, false);
                    }
                    ++column;
                }
            }
            ++row;
        }
        int marginTop = 0;
        int row2 = 0;
        while (row2 < height) {
            if (!((Boolean)rowIsWhite.get(row2)).booleanValue()) break;
            ++marginTop;
            ++row2;
        }
        int marginLeft = 0;
        int column = 0;
        while (column < width) {
            if (!((Boolean)columnIsWhite.get(column)).booleanValue()) break;
            ++marginLeft;
            ++column;
        }
        int marginRight = 0;
        int column2 = width - 1;
        while (column2 >= 0) {
            if (!((Boolean)columnIsWhite.get(column2)).booleanValue()) break;
            ++marginRight;
            --column2;
        }
        int marginBottom = 0;
        int row3 = height - 1;
        while (row3 >= 0) {
            if (!((Boolean)rowIsWhite.get(row3)).booleanValue()) break;
            ++marginBottom;
            --row3;
        }
        DiagramNode diagramBoundsImage = new DiagramNode();
        diagramBoundsImage.setX(Double.valueOf(marginLeft));
        diagramBoundsImage.setY(Double.valueOf(marginTop));
        diagramBoundsImage.setWidth(Double.valueOf(width - marginRight - marginLeft));
        diagramBoundsImage.setHeight(Double.valueOf(height - marginBottom - marginTop));
        return diagramBoundsImage;
    }

    protected Map<String, DiagramNode> getElementBoundsFromBpmnDi(Document bpmnModel) {
        HashMap<String, DiagramNode> listOfBounds = new HashMap<String, DiagramNode>();
        NodeList shapes = bpmnModel.getElementsByTagNameNS("http://www.omg.org/spec/BPMN/20100524/DI", "BPMNShape");
        int i = 0;
        while (i < shapes.getLength()) {
            Element shape = (Element)shapes.item(i);
            String bpmnElementId = shape.getAttribute("bpmnElement");
            NodeList childNodes = shape.getChildNodes();
            int j = 0;
            while (j < childNodes.getLength()) {
                Node childNode = childNodes.item(j);
                if (childNode instanceof Element && "http://www.omg.org/spec/DD/20100524/DC".equals(childNode.getNamespaceURI()) && "Bounds".equals(childNode.getLocalName())) {
                    DiagramNode bounds = this.parseBounds((Element)childNode);
                    bounds.setId(bpmnElementId);
                    listOfBounds.put(bpmnElementId, bounds);
                    break;
                }
                ++j;
            }
            ++i;
        }
        return listOfBounds;
    }

    protected DiagramNode parseBounds(Element boundsElement) {
        DiagramNode bounds = new DiagramNode();
        bounds.setX(Double.valueOf(boundsElement.getAttribute("x")));
        bounds.setY(Double.valueOf(boundsElement.getAttribute("y")));
        bounds.setWidth(Double.valueOf(boundsElement.getAttribute("width")));
        bounds.setHeight(Double.valueOf(boundsElement.getAttribute("height")));
        return bounds;
    }

    protected Map<String, DiagramElement> transformBoundsForImage(DiagramNode diagramBoundsImage, DiagramNode diagramBoundsXml, Map<String, DiagramNode> listOfBounds) {
        HashMap<String, DiagramElement> listOfBoundsForImage = new HashMap<String, DiagramElement>();
        for (Map.Entry<String, DiagramNode> bounds : listOfBounds.entrySet()) {
            listOfBoundsForImage.put(bounds.getKey(), this.transformBoundsForImage(diagramBoundsImage, diagramBoundsXml, bounds.getValue()));
        }
        return listOfBoundsForImage;
    }

    protected DiagramNode transformBoundsForImage(DiagramNode diagramBoundsImage, DiagramNode diagramBoundsXml, DiagramNode elementBounds) {
        double scalingFactorX = diagramBoundsImage.getWidth() / diagramBoundsXml.getWidth();
        double scalingFactorY = diagramBoundsImage.getWidth() / diagramBoundsXml.getWidth();
        DiagramNode elementBoundsForImage = new DiagramNode(elementBounds.getId());
        elementBoundsForImage.setX(Double.valueOf(Math.round((elementBounds.getX() - diagramBoundsXml.getX()) * scalingFactorX + diagramBoundsImage.getX())));
        elementBoundsForImage.setY(Double.valueOf(Math.round((elementBounds.getY() - diagramBoundsXml.getY()) * scalingFactorY + diagramBoundsImage.getY())));
        elementBoundsForImage.setWidth(Double.valueOf(Math.round(elementBounds.getWidth() * scalingFactorX)));
        elementBoundsForImage.setHeight(Double.valueOf(Math.round(elementBounds.getHeight() * scalingFactorY)));
        return elementBoundsForImage;
    }

    protected Map<String, DiagramNode> fixFlowNodePositionsIfModelFromAdonis(Document bpmnModel, Map<String, DiagramNode> elementBoundsFromBpmnDi) {
        if (this.isExportedFromAdonis50(bpmnModel)) {
            HashMap<String, DiagramNode> mapOfFixedBounds = new HashMap<String, DiagramNode>();
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            xPath.setNamespaceContext(new Bpmn20NamespaceContext());
            for (Map.Entry<String, DiagramNode> entry : elementBoundsFromBpmnDi.entrySet()) {
                String elementId = entry.getKey();
                DiagramNode elementBounds = entry.getValue();
                String expression = "local-name(//bpmn:*[@id = '" + elementId + "'])";
                try {
                    XPathExpression xPathExpression = xPath.compile(expression);
                    String elementLocalName = xPathExpression.evaluate(bpmnModel);
                    if (!("participant".equals(elementLocalName) || "lane".equals(elementLocalName) || "textAnnotation".equals(elementLocalName) || "group".equals(elementLocalName))) {
                        elementBounds.setX(elementBounds.getX() - elementBounds.getWidth() / 2.0);
                        elementBounds.setY(elementBounds.getY() - elementBounds.getHeight() / 2.0);
                    }
                }
                catch (XPathExpressionException e) {
                    throw new ActivitiException("Error while evaluating the following XPath expression on a BPMN XML document: '" + expression + "'.", e);
                }
                mapOfFixedBounds.put(elementId, elementBounds);
            }
            return mapOfFixedBounds;
        }
        return elementBoundsFromBpmnDi;
    }

    protected boolean isExportedFromAdonis50(Document bpmnModel) {
        return "ADONIS".equals(bpmnModel.getDocumentElement().getAttribute("exporter")) && "5.0".equals(bpmnModel.getDocumentElement().getAttribute("exporterVersion"));
    }
}

