/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.bpmn.converter.util.CommaSplitter;
import org.activiti.bpmn.model.ActivitiListener;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.ImplementationType;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.TaskListener;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.handler.AbstractActivityBpmnParseHandler;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.form.DefaultTaskFormHandler;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.task.TaskDefinition;
import org.apache.commons.lang3.StringUtils;

public class UserTaskParseHandler
extends AbstractActivityBpmnParseHandler<UserTask> {
    public static final String PROPERTY_TASK_DEFINITION = "taskDefinition";
    private static final String USER = "user";
    private static final String GROUP = "group";
    private static final String COMMA_SPACE = ", ";

    @Override
    public Class<? extends BaseElement> getHandledType() {
        return UserTask.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, UserTask userTask) {
        ActivityImpl activity = this.createActivityOnCurrentScope(bpmnParse, (FlowElement)userTask, "userTask");
        activity.setAsync(userTask.isAsynchronous());
        activity.setExclusive(!userTask.isNotExclusive());
        TaskDefinition taskDefinition = this.parseTaskDefinition(bpmnParse, userTask, userTask.getId(), (ProcessDefinitionEntity)bpmnParse.getCurrentScope().getProcessDefinition());
        activity.setProperty(PROPERTY_TASK_DEFINITION, taskDefinition);
        activity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createUserTaskActivityBehavior(userTask, taskDefinition));
    }

    public TaskDefinition parseTaskDefinition(BpmnParse bpmnParse, UserTask userTask, String taskDefinitionKey, ProcessDefinitionEntity processDefinition) {
        DefaultTaskFormHandler taskFormHandler = new DefaultTaskFormHandler();
        taskFormHandler.parseConfiguration(userTask.getFormProperties(), userTask.getFormKey(), bpmnParse.getDeployment(), processDefinition);
        TaskDefinition taskDefinition = new TaskDefinition(taskFormHandler);
        taskDefinition.setKey(taskDefinitionKey);
        processDefinition.getTaskDefinitions().put(taskDefinitionKey, taskDefinition);
        ExpressionManager expressionManager = bpmnParse.getExpressionManager();
        if (StringUtils.isNotEmpty((CharSequence)userTask.getName())) {
            taskDefinition.setNameExpression(expressionManager.createExpression(userTask.getName()));
        }
        if (StringUtils.isNotEmpty((CharSequence)userTask.getDocumentation())) {
            taskDefinition.setDescriptionExpression(expressionManager.createExpression(userTask.getDocumentation()));
        }
        if (StringUtils.isNotEmpty((CharSequence)userTask.getAssignee())) {
            taskDefinition.setAssigneeExpression(expressionManager.createExpression(userTask.getAssignee()));
        }
        if (StringUtils.isNotEmpty((CharSequence)userTask.getOwner())) {
            taskDefinition.setOwnerExpression(expressionManager.createExpression(userTask.getOwner()));
        }
        for (String candidateUser : userTask.getCandidateUsers()) {
            taskDefinition.addCandidateUserIdExpression(expressionManager.createExpression(candidateUser));
        }
        for (String candidateGroup : userTask.getCandidateGroups()) {
            taskDefinition.addCandidateGroupIdExpression(expressionManager.createExpression(candidateGroup));
        }
        for (ActivitiListener taskListener : userTask.getTaskListeners()) {
            taskDefinition.addTaskListener(taskListener.getEvent(), this.createTaskListener(bpmnParse, taskListener, userTask.getId()));
        }
        if (StringUtils.isNotEmpty((CharSequence)userTask.getDueDate())) {
            taskDefinition.setDueDateExpression(expressionManager.createExpression(userTask.getDueDate()));
        }
        if (StringUtils.isNotEmpty((CharSequence)userTask.getCategory())) {
            taskDefinition.setCategoryExpression(expressionManager.createExpression(userTask.getCategory()));
        }
        if (StringUtils.isNotEmpty((CharSequence)userTask.getPriority())) {
            taskDefinition.setPriorityExpression(expressionManager.createExpression(userTask.getPriority()));
        }
        if (StringUtils.isNotEmpty((CharSequence)userTask.getFormKey())) {
            taskDefinition.setFormKeyExpression(expressionManager.createExpression(userTask.getFormKey()));
        }
        this.parseCustomIdentityLinks(bpmnParse, userTask, taskDefinition);
        return taskDefinition;
    }

    protected TaskListener createTaskListener(BpmnParse bpmnParse, ActivitiListener activitiListener, String taskId) {
        TaskListener taskListener = null;
        if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equalsIgnoreCase(activitiListener.getImplementationType())) {
            taskListener = bpmnParse.getListenerFactory().createClassDelegateTaskListener(activitiListener);
        } else if (ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION.equalsIgnoreCase(activitiListener.getImplementationType())) {
            taskListener = bpmnParse.getListenerFactory().createExpressionTaskListener(activitiListener);
        } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equalsIgnoreCase(activitiListener.getImplementationType())) {
            taskListener = bpmnParse.getListenerFactory().createDelegateExpressionTaskListener(activitiListener);
        }
        return taskListener;
    }

    protected void parseCustomIdentityLinks(BpmnParse bpmnParse, UserTask userTask, TaskDefinition taskDefinition) {
        List resourceLists;
        Map extensionElements = userTask.getExtensionElements();
        if (extensionElements != null && (resourceLists = (List)extensionElements.get("customResource")) != null) {
            for (ExtensionElement resourceList : resourceLists) {
                String resourceType = resourceList.getAttributeValue("http://activiti.org/bpmn", "name");
                Map<String, String> resources = this.getResources(resourceType, userTask);
                if (resources == null) continue;
                Set<Expression> resourceExpression = this.convertToExpressions(false, bpmnParse, resources.get(USER));
                if (resourceExpression != null) {
                    taskDefinition.addCustomUserIdentityLinkExpression(resourceType, resourceExpression);
                }
                if ((resourceExpression = this.convertToExpressions(true, bpmnParse, resources.get(GROUP))) == null) continue;
                taskDefinition.addCustomGroupIdentityLinkExpression(resourceType, resourceExpression);
            }
        }
    }

    protected Set<Expression> convertToExpressions(boolean isGroup, BpmnParse bpmnParse, String resourceExpression) {
        ExpressionManager expressionManager = bpmnParse.getExpressionManager();
        HashSet<Expression> resources = new HashSet<Expression>();
        List resourceList = CommaSplitter.splitCommas((String)resourceExpression);
        if (resourceList != null) {
            for (String resource : resourceList) {
                resources.add(expressionManager.createExpression(resource));
            }
        }
        return resources;
    }

    protected Map<String, String> getResources(String resourceType, UserTask userTask) {
        List resourceElements;
        Map extensions = userTask.getExtensionElements();
        String resourceExpression = null;
        if (extensions != null && (resourceElements = (List)extensions.get("customResource")) != null) {
            for (ExtensionElement resourceElement : resourceElements) {
                if (!resourceType.equals(resourceElement.getAttributeValue("http://activiti.org/bpmn", "name")) || resourceElement == null || (resourceElement = this.getChildElement("resourceAssignmentExpression", resourceElement)) == null || (resourceElement = this.getChildElement("formalExpression", resourceElement)) == null) continue;
                resourceExpression = resourceElement.getElementText();
            }
        }
        return this.generateResourceLists(resourceExpression);
    }

    protected Map<String, String> generateResourceLists(String resourceExpression) {
        HashMap<String, String> resourceLists = null;
        if (resourceExpression != null) {
            StringBuilder userExpression = new StringBuilder(50);
            StringBuilder groupExpression = new StringBuilder(50);
            List assignmentList = CommaSplitter.splitCommas((String)resourceExpression);
            for (String assignmentValue : assignmentList) {
                if ((assignmentValue = StringUtils.trimToNull((String)assignmentValue)) == null) continue;
                if (assignmentValue.startsWith(USER)) {
                    List userList = CommaSplitter.splitCommas((String)assignmentValue.substring(USER.length() + 1, assignmentValue.length() - 1).trim());
                    for (String user : userList) {
                        if (StringUtils.isNotEmpty((CharSequence)userExpression.toString())) {
                            userExpression.append(COMMA_SPACE);
                        }
                        userExpression.append(user);
                    }
                    continue;
                }
                if (assignmentValue.startsWith(GROUP)) {
                    List groupList = CommaSplitter.splitCommas((String)assignmentValue.substring(GROUP.length() + 1, assignmentValue.length() - 1).trim());
                    for (String group : groupList) {
                        if (StringUtils.isNotEmpty((CharSequence)groupExpression.toString())) {
                            groupExpression.append(COMMA_SPACE);
                        }
                        groupExpression.append(group);
                    }
                    continue;
                }
                if (StringUtils.isNotEmpty((CharSequence)groupExpression.toString())) {
                    groupExpression.append(COMMA_SPACE);
                }
                groupExpression.append(assignmentValue);
            }
            resourceLists = new HashMap<String, String>();
            resourceLists.put(USER, userExpression.toString());
            resourceLists.put(GROUP, groupExpression.toString());
        }
        return resourceLists;
    }

    protected ExtensionElement getChildElement(String key, ExtensionElement element) {
        List extensionElements;
        if (element != null && (extensionElements = (List)element.getChildElements().get(key)) != null) {
            return (ExtensionElement)extensionElements.get(0);
        }
        return null;
    }
}

