/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cfg.standalone;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.impl.cfg.TransactionContext;
import org.activiti.engine.impl.cfg.TransactionListener;
import org.activiti.engine.impl.cfg.TransactionState;
import org.activiti.engine.impl.db.DbSqlSession;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneMybatisTransactionContext
implements TransactionContext {
    private static Logger log = LoggerFactory.getLogger(StandaloneMybatisTransactionContext.class);
    protected CommandContext commandContext;
    protected Map<TransactionState, List<TransactionListener>> stateTransactionListeners = null;

    public StandaloneMybatisTransactionContext(CommandContext commandContext) {
        this.commandContext = commandContext;
    }

    @Override
    public void addTransactionListener(TransactionState transactionState, TransactionListener transactionListener) {
        List<TransactionListener> transactionListeners;
        if (this.stateTransactionListeners == null) {
            this.stateTransactionListeners = new HashMap<TransactionState, List<TransactionListener>>();
        }
        if ((transactionListeners = this.stateTransactionListeners.get((Object)transactionState)) == null) {
            transactionListeners = new ArrayList<TransactionListener>();
            this.stateTransactionListeners.put(transactionState, transactionListeners);
        }
        transactionListeners.add(transactionListener);
    }

    @Override
    public void commit() {
        log.debug("firing event committing...");
        this.fireTransactionEvent(TransactionState.COMMITTING);
        log.debug("committing the ibatis sql session...");
        this.getDbSqlSession().commit();
        log.debug("firing event committed...");
        this.fireTransactionEvent(TransactionState.COMMITTED);
    }

    protected void fireTransactionEvent(TransactionState transactionState) {
        if (this.stateTransactionListeners == null) {
            return;
        }
        List<TransactionListener> transactionListeners = this.stateTransactionListeners.get((Object)transactionState);
        if (transactionListeners == null) {
            return;
        }
        for (TransactionListener transactionListener : transactionListeners) {
            transactionListener.execute(this.commandContext);
        }
    }

    private DbSqlSession getDbSqlSession() {
        return this.commandContext.getSession(DbSqlSession.class);
    }

    @Override
    public void rollback() {
        try {
            try {
                try {
                    try {
                        log.debug("firing event rolling back...");
                        this.fireTransactionEvent(TransactionState.ROLLINGBACK);
                    }
                    catch (Throwable exception) {
                        log.info("Exception during transaction: {}", (Object)exception.getMessage());
                        this.commandContext.exception(exception);
                        log.debug("rolling back ibatis sql session...");
                        this.getDbSqlSession().rollback();
                    }
                }
                finally {
                    log.debug("rolling back ibatis sql session...");
                    this.getDbSqlSession().rollback();
                }
            }
            catch (Throwable exception) {
                log.info("Exception during transaction: {}", (Object)exception.getMessage());
                this.commandContext.exception(exception);
                log.debug("firing event rolled back...");
                this.fireTransactionEvent(TransactionState.ROLLED_BACK);
            }
        }
        finally {
            log.debug("firing event rolled back...");
            this.fireTransactionEvent(TransactionState.ROLLED_BACK);
        }
    }
}

