/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.event.logger.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import java.util.Map;
import org.activiti.engine.delegate.event.ActivitiEntityEvent;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.impl.event.logger.handler.EventLoggerEventHandler;
import org.activiti.engine.impl.identity.Authentication;
import org.activiti.engine.impl.persistence.entity.EventLogEntryEntity;

public abstract class AbstractDatabaseEventLoggerEventHandler
implements EventLoggerEventHandler {
    protected ActivitiEvent event;
    protected Date timeStamp;
    protected ObjectMapper objectMapper;

    protected EventLogEntryEntity createEventLogEntry(Map<String, Object> data) {
        return this.createEventLogEntry(null, null, null, null, data);
    }

    protected EventLogEntryEntity createEventLogEntry(String processDefinitionId, String processInstanceId, String executionId, String taskId, Map<String, Object> data) {
        return this.createEventLogEntry(this.event.getType().name(), processDefinitionId, processInstanceId, executionId, taskId, data);
    }

    protected EventLogEntryEntity createEventLogEntry(String type, String processDefinitionId, String processInstanceId, String executionId, String taskId, Map<String, Object> data) {
        try {
            EventLogEntryEntity eventLogEntry = new EventLogEntryEntity();
            eventLogEntry.setProcessDefinitionId(processDefinitionId);
            eventLogEntry.setProcessInstanceId(processInstanceId);
            eventLogEntry.setExecutionId(executionId);
            eventLogEntry.setTaskId(taskId);
            eventLogEntry.setType(type);
            eventLogEntry.setTimeStamp(this.timeStamp);
            this.putInMapIfNotNull(data, "timeStamp", this.timeStamp);
            String userId = Authentication.getAuthenticatedUserId();
            if (userId != null) {
                eventLogEntry.setUserId(userId);
                this.putInMapIfNotNull(data, "userId", userId);
            }
            eventLogEntry.setData(this.objectMapper.writeValueAsBytes(data));
            return eventLogEntry;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void setEvent(ActivitiEvent event) {
        this.event = event;
    }

    @Override
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    @Override
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public <T> T getEntityFromEvent() {
        return (T)((ActivitiEntityEvent)this.event).getEntity();
    }

    public void putInMapIfNotNull(Map<String, Object> map, String key, Object value) {
        if (value != null) {
            map.put(key, value);
        }
    }
}

