/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.history;

import org.activiti.engine.ActivitiIllegalArgumentException;

public enum HistoryLevel {
    NONE("none"),
    ACTIVITY("activity"),
    AUDIT("audit"),
    FULL("full");

    private String key;

    private HistoryLevel(String key) {
        this.key = key;
    }

    public static HistoryLevel getHistoryLevelForKey(String key) {
        HistoryLevel[] historyLevelArray = HistoryLevel.values();
        int n = historyLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            HistoryLevel level = historyLevelArray[n2];
            if (level.key.equals(key)) {
                return level;
            }
            ++n2;
        }
        throw new ActivitiIllegalArgumentException("Illegal value for history-level: " + key);
    }

    public String getKey() {
        return this.key;
    }

    public boolean isAtLeast(HistoryLevel level) {
        return this.compareTo(level) >= 0;
    }
}

