/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.jobexecutor;

import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.bpmn.behavior.BoundaryEventActivityBehavior;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.jobexecutor.JobHandler;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerExecuteNestedActivityJobHandler
implements JobHandler {
    private static Logger log = LoggerFactory.getLogger(TimerExecuteNestedActivityJobHandler.class);
    public static final String TYPE = "timer-transition";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void execute(JobEntity job, String configuration, ExecutionEntity execution, CommandContext commandContext) {
        ActivityImpl borderEventActivity = execution.getProcessDefinition().findActivity(configuration);
        if (borderEventActivity == null) {
            throw new ActivitiException("Error while firing timer: border event activity " + configuration + " not found");
        }
        try {
            if (commandContext.getEventDispatcher().isEnabled()) {
                commandContext.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.TIMER_FIRED, job));
                this.dispatchActivityTimeoutIfNeeded(job, execution, commandContext);
            }
            borderEventActivity.getActivityBehavior().execute(execution);
        }
        catch (RuntimeException e) {
            log.error("exception during timer execution", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error("exception during timer execution", (Throwable)e);
            throw new ActivitiException("exception during timer execution: " + e.getMessage(), e);
        }
    }

    protected void dispatchActivityTimeoutIfNeeded(JobEntity timerEntity, ExecutionEntity execution, CommandContext commandContext) {
        ActivityImpl activity;
        BoundaryEventActivityBehavior boundaryEventActivityBehavior;
        ActivityImpl boundaryEventActivity = execution.getProcessDefinition().findActivity(timerEntity.getJobHandlerConfiguration());
        ActivityBehavior boundaryActivityBehavior = boundaryEventActivity.getActivityBehavior();
        if (boundaryActivityBehavior instanceof BoundaryEventActivityBehavior && (boundaryEventActivityBehavior = (BoundaryEventActivityBehavior)boundaryActivityBehavior).isInterrupting() && (activity = execution.getActivity()) != null && activity.getActivityBehavior() != null) {
            commandContext.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createActivityEvent(ActivitiEventType.ACTIVITY_TIMEOUT, execution.getActivity().getId(), (String)activity.getProperties().get("name"), execution.getId(), execution.getProcessInstanceId(), execution.getProcessDefinitionId(), (String)activity.getProperties().get("type"), activity.getActivityBehavior().getClass().getCanonicalName()));
        }
    }
}

