/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.juel;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.activiti.engine.impl.javax.el.ELContext;
import org.activiti.engine.impl.javax.el.ELException;
import org.activiti.engine.impl.juel.AstNode;
import org.activiti.engine.impl.juel.AstParameters;
import org.activiti.engine.impl.juel.AstRightValue;
import org.activiti.engine.impl.juel.Bindings;
import org.activiti.engine.impl.juel.FunctionNode;
import org.activiti.engine.impl.juel.LocalMessages;

public class AstFunction
extends AstRightValue
implements FunctionNode {
    private final int index;
    private final String name;
    private final AstParameters params;
    private final boolean varargs;

    public AstFunction(String name, int index, AstParameters params) {
        this(name, index, params, false);
    }

    public AstFunction(String name, int index, AstParameters params, boolean varargs) {
        this.name = name;
        this.index = index;
        this.params = params;
        this.varargs = varargs;
    }

    protected Object invoke(Bindings bindings, ELContext context, Object base, Method method) throws InvocationTargetException, IllegalAccessException {
        Class<?>[] types = method.getParameterTypes();
        Object[] params = null;
        if (types.length > 0) {
            params = new Object[types.length];
            if (this.varargs && method.isVarArgs()) {
                int i = 0;
                while (i < params.length - 1) {
                    Object param = this.getParam(i).eval(bindings, context);
                    if (param != null || types[i].isPrimitive()) {
                        params[i] = bindings.convert(param, types[i]);
                    }
                    ++i;
                }
                int varargIndex = types.length - 1;
                Class<?> varargType = types[varargIndex].getComponentType();
                int length = this.getParamCount() - varargIndex;
                Object array = null;
                if (length == 1) {
                    Object param = this.getParam(varargIndex).eval(bindings, context);
                    if (param != null && param.getClass().isArray()) {
                        if (types[varargIndex].isInstance(param)) {
                            array = param;
                        } else {
                            length = Array.getLength(param);
                            array = Array.newInstance(varargType, length);
                            int i2 = 0;
                            while (i2 < length) {
                                Object elem = Array.get(param, i2);
                                if (elem != null || varargType.isPrimitive()) {
                                    Array.set(array, i2, bindings.convert(elem, varargType));
                                }
                                ++i2;
                            }
                        }
                    } else {
                        array = Array.newInstance(varargType, 1);
                        if (param != null || varargType.isPrimitive()) {
                            Array.set(array, 0, bindings.convert(param, varargType));
                        }
                    }
                } else {
                    array = Array.newInstance(varargType, length);
                    int i3 = 0;
                    while (i3 < length) {
                        Object param = this.getParam(varargIndex + i3).eval(bindings, context);
                        if (param != null || varargType.isPrimitive()) {
                            Array.set(array, i3, bindings.convert(param, varargType));
                        }
                        ++i3;
                    }
                }
                params[varargIndex] = array;
            } else {
                int i = 0;
                while (i < params.length) {
                    Object param = this.getParam(i).eval(bindings, context);
                    if (param != null || types[i].isPrimitive()) {
                        params[i] = bindings.convert(param, types[i]);
                    }
                    ++i;
                }
            }
        }
        return method.invoke(base, params);
    }

    @Override
    public Object eval(Bindings bindings, ELContext context) {
        Method method = bindings.getFunction(this.index);
        try {
            return this.invoke(bindings, context, null, method);
        }
        catch (IllegalAccessException e) {
            throw new ELException(LocalMessages.get("error.function.access", this.name), e);
        }
        catch (InvocationTargetException e) {
            throw new ELException(LocalMessages.get("error.function.invocation", this.name), e.getCause());
        }
    }

    public String toString() {
        return this.name;
    }

    @Override
    public void appendStructure(StringBuilder b, Bindings bindings) {
        b.append(bindings != null && bindings.isFunctionBound(this.index) ? "<fn>" : this.name);
        this.params.appendStructure(b, bindings);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isVarArgs() {
        return this.varargs;
    }

    @Override
    public int getParamCount() {
        return this.params.getCardinality();
    }

    protected AstNode getParam(int i) {
        return this.params.getChild(i);
    }

    @Override
    public int getCardinality() {
        return 1;
    }

    @Override
    public AstNode getChild(int i) {
        return i == 0 ? this.params : null;
    }
}

