/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.util.json;

import org.activiti.engine.impl.util.json.JSONArray;
import org.activiti.engine.impl.util.json.JSONException;
import org.activiti.engine.impl.util.json.JSONObject;
import org.activiti.engine.impl.util.json.JSONTokener;

public class CDL {
    private static String getValue(JSONTokener x) throws JSONException {
        char c;
        while ((c = x.next()) == ' ' || c == '\t') {
        }
        switch (c) {
            case '\u0000': {
                return null;
            }
            case '\"': 
            case '\'': {
                char q = c;
                StringBuffer sb = new StringBuffer();
                while ((c = x.next()) != q) {
                    if (c == '\u0000' || c == '\n' || c == '\r') {
                        throw x.syntaxError("Missing close quote '" + q + "'.");
                    }
                    sb.append(c);
                }
                return sb.toString();
            }
            case ',': {
                x.back();
                return "";
            }
        }
        x.back();
        return x.nextTo(',');
    }

    public static JSONArray rowToJSONArray(JSONTokener x) throws JSONException {
        JSONArray ja = new JSONArray();
        block0: while (true) {
            String value = CDL.getValue(x);
            char c = x.next();
            if (value == null || ja.length() == 0 && value.length() == 0 && c != ',') {
                return null;
            }
            ja.put(value);
            while (true) {
                if (c == ',') continue block0;
                if (c != ' ') {
                    if (c == '\n' || c == '\r' || c == '\u0000') {
                        return ja;
                    }
                    throw x.syntaxError("Bad character '" + c + "' (" + c + ").");
                }
                c = x.next();
            }
            break;
        }
    }

    public static JSONObject rowToJSONObject(JSONArray names, JSONTokener x) throws JSONException {
        JSONArray ja = CDL.rowToJSONArray(x);
        return ja != null ? ja.toJSONObject(names) : null;
    }

    public static JSONArray toJSONArray(String string) throws JSONException {
        return CDL.toJSONArray(new JSONTokener(string));
    }

    public static JSONArray toJSONArray(JSONTokener x) throws JSONException {
        return CDL.toJSONArray(CDL.rowToJSONArray(x), x);
    }

    public static JSONArray toJSONArray(JSONArray names, String string) throws JSONException {
        return CDL.toJSONArray(names, new JSONTokener(string));
    }

    public static JSONArray toJSONArray(JSONArray names, JSONTokener x) throws JSONException {
        JSONObject jo;
        if (names == null || names.length() == 0) {
            return null;
        }
        JSONArray ja = new JSONArray();
        while ((jo = CDL.rowToJSONObject(names, x)) != null) {
            ja.put(jo);
        }
        if (ja.length() == 0) {
            return null;
        }
        return ja;
    }

    public static String rowToString(JSONArray ja) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < ja.length()) {
            Object o;
            if (i > 0) {
                sb.append(',');
            }
            if ((o = ja.opt(i)) != null) {
                String s = o.toString();
                if (s.length() > 0 && (s.indexOf(44) >= 0 || s.indexOf(10) >= 0 || s.indexOf(13) >= 0 || s.indexOf(0) >= 0 || s.charAt(0) == '\"')) {
                    sb.append('\"');
                    int length = s.length();
                    int j = 0;
                    while (j < length) {
                        char c = s.charAt(j);
                        if (c >= ' ' && c != '\"') {
                            sb.append(c);
                        }
                        ++j;
                    }
                    sb.append('\"');
                } else {
                    sb.append(s);
                }
            }
            ++i;
        }
        sb.append('\n');
        return sb.toString();
    }

    public static String toString(JSONArray ja) throws JSONException {
        JSONArray names;
        JSONObject jo = ja.optJSONObject(0);
        if (jo != null && (names = jo.names()) != null) {
            return String.valueOf(CDL.rowToString(names)) + CDL.toString(names, ja);
        }
        return null;
    }

    public static String toString(JSONArray names, JSONArray ja) throws JSONException {
        if (names == null || names.length() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < ja.length()) {
            JSONObject jo = ja.optJSONObject(i);
            if (jo != null) {
                sb.append(CDL.rowToString(jo.toJSONArray(names)));
            }
            ++i;
        }
        return sb.toString();
    }
}

