/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.variable;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.variable.EntityMetaData;

public class JPAEntityScanner {
    public EntityMetaData scanClass(Class<?> clazz) {
        EntityMetaData metaData = new EntityMetaData();
        metaData.setEntityClass(clazz);
        boolean isEntity = this.isEntityAnnotationPresent(clazz);
        metaData.setJPAEntity(isEntity);
        if (isEntity) {
            Field idField = this.getIdField(clazz);
            if (idField != null) {
                metaData.setIdField(idField);
            } else {
                Method idMethod = this.getIdMethod(clazz);
                if (idMethod != null) {
                    metaData.setIdMethod(idMethod);
                } else {
                    throw new ActivitiException("Cannot find field or method with annotation @Id on class '" + clazz.getName() + "', only single-valued primary keys are supported on JPA-enities");
                }
            }
        }
        return metaData;
    }

    private Method getIdMethod(Class<?> clazz) {
        Method idMethod = null;
        Method[] methods = clazz.getMethods();
        Id idAnnotation = null;
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            idAnnotation = method.getAnnotation(Id.class);
            if (idAnnotation != null) {
                idMethod = method;
                break;
            }
            ++n2;
        }
        return idMethod;
    }

    private Field getIdField(Class<?> clazz) {
        Class<?> superClass;
        Field idField = null;
        Field[] fields = clazz.getDeclaredFields();
        Id idAnnotation = null;
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            idAnnotation = field.getAnnotation(Id.class);
            if (idAnnotation != null) {
                idField = field;
                break;
            }
            ++n2;
        }
        if (idField == null && (superClass = clazz.getSuperclass()) != null && !superClass.equals(Object.class)) {
            idField = this.getIdField(superClass);
        }
        return idField;
    }

    private boolean isEntityAnnotationPresent(Class<?> clazz) {
        return clazz.getAnnotation(Entity.class) != null;
    }
}

