/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.validation.validator.impl;

import java.util.List;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.Process;
import org.activiti.validation.ValidationError;
import org.activiti.validation.validator.ValidatorImpl;

public class BpmnModelValidator
extends ValidatorImpl {
    @Override
    public void validate(BpmnModel bpmnModel, List<ValidationError> errors) {
        boolean isAtLeastOneExecutable = this.validateAtLeastOneExecutable(bpmnModel, errors);
        if (isAtLeastOneExecutable) {
            for (Process process : bpmnModel.getProcesses()) {
                if (process.isExecutable()) continue;
                this.addWarning(errors, "activiti-specific-process-definition-not-executable", process, (BaseElement)process, "Process definition is not executable. Please verify that this is intentional.");
            }
        }
    }

    private boolean validateAtLeastOneExecutable(BpmnModel bpmnModel, List<ValidationError> errors) {
        int nrOfExecutableDefinitions = 0;
        for (Process process : bpmnModel.getProcesses()) {
            if (!process.isExecutable()) continue;
            ++nrOfExecutableDefinitions;
        }
        if (nrOfExecutableDefinitions == 0) {
            this.addError(errors, "activiti-process-definition-not-executable", "All process definition are set to be non-executable (property 'isExecutable' on process). This is not allowed.");
        }
        return nrOfExecutableDefinitions > 0;
    }
}

