/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.management;

import org.activiti.engine.ActivitiException;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.ProcessEngineInfo;
import org.activiti.engine.ProcessEngines;
import org.activiti.rest.service.api.management.ProcessEngineInfoResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ProcessEngineResource {
    @Autowired
    @Qualifier(value="processEngine")
    protected ProcessEngine engine;

    @RequestMapping(value={"/management/engine"}, method={RequestMethod.GET}, produces={"application/json"})
    public ProcessEngineInfoResponse getEngineInfo() {
        ProcessEngineInfoResponse response = new ProcessEngineInfoResponse();
        try {
            ProcessEngineInfo engineInfo = ProcessEngines.getProcessEngineInfo((String)this.engine.getName());
            if (engineInfo != null) {
                response.setName(engineInfo.getName());
                response.setResourceUrl(engineInfo.getResourceUrl());
                response.setException(engineInfo.getException());
            } else {
                response.setName(this.engine.getName());
            }
        }
        catch (Exception e) {
            throw new ActivitiException("Error retrieving process info", (Throwable)e);
        }
        response.setVersion("5.23.0.0");
        return response;
    }
}

