/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.workflow.simple.converter.step;

import java.util.ArrayList;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.ParallelGateway;
import org.activiti.workflow.simple.converter.WorkflowDefinitionConversion;
import org.activiti.workflow.simple.converter.WorkflowDefinitionConversionFactory;
import org.activiti.workflow.simple.converter.step.BaseStepDefinitionConverter;
import org.activiti.workflow.simple.definition.ListStepDefinition;
import org.activiti.workflow.simple.definition.ParallelStepsDefinition;
import org.activiti.workflow.simple.definition.StepDefinition;

public class ParallelStepsDefinitionConverter
extends BaseStepDefinitionConverter<ParallelStepsDefinition, ParallelGateway> {
    private static final long serialVersionUID = 1L;
    private static final String PARALLEL_GATEWAY_PREFIX = "parallelGateway";

    @Override
    public Class<? extends StepDefinition> getHandledClass() {
        return ParallelStepsDefinition.class;
    }

    @Override
    protected ParallelGateway createProcessArtifact(ParallelStepsDefinition parallelStepsDefinition, WorkflowDefinitionConversion conversion) {
        ParallelGateway forkGateway = this.createParallelGateway(conversion);
        this.addSequenceFlow(conversion, conversion.getLastActivityId(), forkGateway.getId());
        conversion.setLastActivityId(forkGateway.getId());
        WorkflowDefinitionConversionFactory conversionFactory = conversion.getConversionFactory();
        ArrayList<FlowElement> endElements = new ArrayList<FlowElement>();
        for (ListStepDefinition stepListDefinition : parallelStepsDefinition.getStepList()) {
            for (int i = 0; i < stepListDefinition.getSteps().size(); ++i) {
                if (i == 0) {
                    conversion.setSequenceflowGenerationEnabled(false);
                } else {
                    conversion.setSequenceflowGenerationEnabled(true);
                }
                StepDefinition step = stepListDefinition.getSteps().get(i);
                FlowElement flowElement = (FlowElement)conversionFactory.getStepConverterFor(step).convertStepDefinition(step, conversion);
                if (i == 0) {
                    this.addSequenceFlow(conversion, forkGateway.getId(), flowElement.getId());
                }
                if (i + 1 != stepListDefinition.getSteps().size()) continue;
                endElements.add(flowElement);
            }
        }
        conversion.setSequenceflowGenerationEnabled(false);
        ParallelGateway joinGateway = this.createParallelGateway(conversion);
        conversion.setLastActivityId(joinGateway.getId());
        conversion.setSequenceflowGenerationEnabled(true);
        for (FlowElement endElement : endElements) {
            this.addSequenceFlow(conversion, endElement.getId(), joinGateway.getId());
        }
        return forkGateway;
    }

    protected ParallelGateway createParallelGateway(WorkflowDefinitionConversion conversion) {
        ParallelGateway parallelGateway = new ParallelGateway();
        parallelGateway.setId(conversion.getUniqueNumberedId(PARALLEL_GATEWAY_PREFIX));
        conversion.getProcess().addFlowElement((FlowElement)parallelGateway);
        return parallelGateway;
    }
}

