/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.atlas.AtlasException;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.v1.model.instance.Referenceable;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class EntityAuditEvent
implements Serializable {
    private String entityId;
    private long timestamp;
    private String user;
    private EntityAuditAction action;
    private String details;
    private String eventKey;
    private Referenceable entityDefinition;

    public EntityAuditEvent() {
    }

    public EntityAuditEvent(String entityId, Long ts, String user, EntityAuditAction action, String details, Referenceable entityDefinition) throws AtlasException {
        this.entityId = entityId;
        this.timestamp = ts;
        this.user = user;
        this.action = action;
        this.details = details;
        this.entityDefinition = entityDefinition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityAuditEvent that = (EntityAuditEvent)o;
        return this.timestamp == that.timestamp && Objects.equals(this.entityId, that.entityId) && Objects.equals(this.user, that.user) && this.action == that.action && Objects.equals(this.details, that.details) && Objects.equals(this.eventKey, that.eventKey) && Objects.equals(this.entityDefinition, that.entityDefinition);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.entityId, this.timestamp, this.user, this.action, this.details, this.eventKey, this.entityDefinition});
    }

    public String toString() {
        return AtlasType.toV1Json((Object)this);
    }

    public String getEntityId() {
        return this.entityId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getUser() {
        return this.user;
    }

    public EntityAuditAction getAction() {
        return this.action;
    }

    public String getDetails() {
        return this.details;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setAction(EntityAuditAction action) {
        this.action = action;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public String getEventKey() {
        return this.eventKey;
    }

    public void setEventKey(String eventKey) {
        this.eventKey = eventKey;
    }

    public Referenceable getEntityDefinition() {
        return this.entityDefinition;
    }

    public void setEntityDefinition(Referenceable entityDefinition) {
        this.entityDefinition = entityDefinition;
    }

    @JsonIgnore
    public String getEntityDefinitionString() {
        if (this.entityDefinition != null) {
            return AtlasType.toV1Json((Object)this.entityDefinition);
        }
        return null;
    }

    @JsonIgnore
    public void setEntityDefinition(String entityDefinition) {
        this.entityDefinition = (Referenceable)AtlasType.fromV1Json((String)entityDefinition, Referenceable.class);
    }

    @JsonIgnore
    public static EntityAuditEvent fromString(String eventString) {
        return (EntityAuditEvent)AtlasType.fromV1Json((String)eventString, EntityAuditEvent.class);
    }

    public static enum EntityAuditAction {
        ENTITY_CREATE,
        ENTITY_UPDATE,
        ENTITY_DELETE,
        TAG_ADD,
        TAG_DELETE,
        TAG_UPDATE,
        PROPAGATED_TAG_ADD,
        PROPAGATED_TAG_DELETE,
        PROPAGATED_TAG_UPDATE,
        ENTITY_IMPORT_CREATE,
        ENTITY_IMPORT_UPDATE,
        ENTITY_IMPORT_DELETE,
        TERM_ADD,
        TERM_DELETE;


        public static EntityAuditAction fromString(String strValue) {
            switch (strValue) {
                case "ENTITY_CREATE": {
                    return ENTITY_CREATE;
                }
                case "ENTITY_UPDATE": {
                    return ENTITY_UPDATE;
                }
                case "ENTITY_DELETE": {
                    return ENTITY_DELETE;
                }
                case "ENTITY_IMPORT_CREATE": {
                    return ENTITY_IMPORT_CREATE;
                }
                case "ENTITY_IMPORT_UPDATE": {
                    return ENTITY_IMPORT_UPDATE;
                }
                case "ENTITY_IMPORT_DELETE": {
                    return ENTITY_IMPORT_DELETE;
                }
                case "CLASSIFICATION_ADD": 
                case "TAG_ADD": {
                    return TAG_ADD;
                }
                case "CLASSIFICATION_DELETE": 
                case "TAG_DELETE": {
                    return TAG_DELETE;
                }
                case "CLASSIFICATION_UPDATE": 
                case "TAG_UPDATE": {
                    return TAG_UPDATE;
                }
                case "PROPAGATED_TAG_ADD": {
                    return PROPAGATED_TAG_ADD;
                }
                case "PROPAGATED_TAG_DELETE": {
                    return PROPAGATED_TAG_DELETE;
                }
                case "PROPAGATED_TAG_UPDATE": {
                    return PROPAGATED_TAG_UPDATE;
                }
                case "TERM_ADD": {
                    return TERM_ADD;
                }
                case "TERM_DELETE": {
                    return TERM_DELETE;
                }
            }
            throw new IllegalArgumentException("No enum constant " + EntityAuditAction.class.getCanonicalName() + "." + strValue);
        }
    }
}

