/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.instance;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.commons.collections.CollectionUtils;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class EntityMutations
implements Serializable {
    private List<EntityMutation> entityMutations = new ArrayList<EntityMutation>();

    public EntityMutations(List<EntityMutation> entityMutations) {
        this.entityMutations = entityMutations;
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("EntityMutations{");
        if (CollectionUtils.isNotEmpty(this.entityMutations)) {
            for (int i = 0; i < this.entityMutations.size(); ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                this.entityMutations.get(i).toString(sb);
            }
        }
        sb.append("}");
        return sb;
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityMutations that = (EntityMutations)o;
        return Objects.equals(this.entityMutations, that.entityMutations);
    }

    public int hashCode() {
        return Objects.hash(this.entityMutations);
    }

    public static final class EntityMutation
    implements Serializable {
        private EntityOperation op;
        private AtlasEntity entity;

        public EntityMutation(EntityOperation op, AtlasEntity entity) {
            this.op = op;
            this.entity = entity;
        }

        public StringBuilder toString(StringBuilder sb) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append("EntityMutation {");
            sb.append("op=").append((Object)this.op);
            if (this.entity != null) {
                sb.append(", entity=");
                this.entity.toString(sb);
            }
            sb.append("}");
            return sb;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EntityMutation that = (EntityMutation)o;
            return this.op == that.op && Objects.equals(this.entity, that.entity);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.op, this.entity});
        }

        public String toString() {
            return this.toString(new StringBuilder()).toString();
        }
    }

    public static enum EntityOperation {
        CREATE,
        UPDATE,
        PARTIAL_UPDATE,
        DELETE;

    }
}

