/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.metrics;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.HashMap;
import java.util.Map;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AtlasMetrics {
    public static final String PREFIX_CONNECTION_STATUS = "ConnectionStatus:";
    public static final String PREFIX_NOTIFICATION = "Notification:";
    public static final String PREFIX_SERVER = "Server:";
    public static final String STAT_NOTIFY_COUNT_CURR_DAY = "Notification:currentDay";
    public static final String STAT_NOTIFY_AVG_TIME_CURR_DAY = "Notification:currentDayAvgTime";
    public static final String STAT_NOTIFY_CREATES_COUNT_CURR_DAY = "Notification:currentDayEntityCreates";
    public static final String STAT_NOTIFY_UPDATES_COUNT_CURR_DAY = "Notification:currentDayEntityUpdates";
    public static final String STAT_NOTIFY_DELETES_COUNT_CURR_DAY = "Notification:currentDayEntityDeletes";
    public static final String STAT_NOTIFY_FAILED_COUNT_CURR_DAY = "Notification:currentDayFailed";
    public static final String STAT_NOTIFY_START_TIME_CURR_DAY = "Notification:currentDayStartTime";
    public static final String STAT_NOTIFY_COUNT_CURR_HOUR = "Notification:currentHour";
    public static final String STAT_NOTIFY_AVG_TIME_CURR_HOUR = "Notification:currentHourAvgTime";
    public static final String STAT_NOTIFY_CREATES_COUNT_CURR_HOUR = "Notification:currentHourEntityCreates";
    public static final String STAT_NOTIFY_UPDATES_COUNT_CURR_HOUR = "Notification:currentHourEntityUpdates";
    public static final String STAT_NOTIFY_DELETES_COUNT_CURR_HOUR = "Notification:currentHourEntityDeletes";
    public static final String STAT_NOTIFY_FAILED_COUNT_CURR_HOUR = "Notification:currentHourFailed";
    public static final String STAT_NOTIFY_START_TIME_CURR_HOUR = "Notification:currentHourStartTime";
    public static final String STAT_NOTIFY_LAST_MESSAGE_PROCESSED_TIME = "Notification:lastMessageProcessedTime";
    public static final String STAT_NOTIFY_START_OFFSET = "Notification:offsetStart";
    public static final String STAT_NOTIFY_CURRENT_OFFSET = "Notification:offsetCurrent";
    public static final String STAT_NOTIFY_COUNT_PREV_DAY = "Notification:previousDay";
    public static final String STAT_NOTIFY_AVG_TIME_PREV_DAY = "Notification:previousDayAvgTime";
    public static final String STAT_NOTIFY_CREATES_COUNT_PREV_DAY = "Notification:previousDayEntityCreates";
    public static final String STAT_NOTIFY_UPDATES_COUNT_PREV_DAY = "Notification:previousDayEntityUpdates";
    public static final String STAT_NOTIFY_DELETES_COUNT_PREV_DAY = "Notification:previousDayEntityDeletes";
    public static final String STAT_NOTIFY_FAILED_COUNT_PREV_DAY = "Notification:previousDayFailed";
    public static final String STAT_NOTIFY_COUNT_PREV_HOUR = "Notification:previousHour";
    public static final String STAT_NOTIFY_AVG_TIME_PREV_HOUR = "Notification:previousHourAvgTime";
    public static final String STAT_NOTIFY_CREATES_COUNT_PREV_HOUR = "Notification:previousHourEntityCreates";
    public static final String STAT_NOTIFY_UPDATES_COUNT_PREV_HOUR = "Notification:previousHourEntityUpdates";
    public static final String STAT_NOTIFY_DELETES_COUNT_PREV_HOUR = "Notification:previousHourEntityDeletes";
    public static final String STAT_NOTIFY_FAILED_COUNT_PREV_HOUR = "Notification:previousHourFailed";
    public static final String STAT_NOTIFY_COUNT_TOTAL = "Notification:total";
    public static final String STAT_NOTIFY_AVG_TIME_TOTAL = "Notification:totalAvgTime";
    public static final String STAT_NOTIFY_CREATES_COUNT_TOTAL = "Notification:totalCreates";
    public static final String STAT_NOTIFY_UPDATES_COUNT_TOTAL = "Notification:totalUpdates";
    public static final String STAT_NOTIFY_DELETES_COUNT_TOTAL = "Notification:totalDeletes";
    public static final String STAT_NOTIFY_FAILED_COUNT_TOTAL = "Notification:totalFailed";
    public static final String STAT_SERVER_ACTIVE_TIMESTAMP = "Server:activeTimeStamp";
    public static final String STAT_SERVER_START_TIMESTAMP = "Server:startTimeStamp";
    public static final String STAT_SERVER_STATUS_BACKEND_STORE = "Server:statusBackendStore";
    public static final String STAT_SERVER_STATUS_INDEX_STORE = "Server:statusIndexStore";
    public static final String STAT_SERVER_UP_TIME = "Server:upTime";
    private Map<String, Map<String, Object>> data;

    public AtlasMetrics() {
        this.setData(null);
    }

    public AtlasMetrics(Map<String, Map<String, Object>> data) {
        this.setData(data);
    }

    public AtlasMetrics(AtlasMetrics other) {
        if (other != null) {
            this.setData(other.getData());
        }
    }

    public Map<String, Map<String, Object>> getData() {
        return this.data;
    }

    public void setData(Map<String, Map<String, Object>> data) {
        this.data = data;
    }

    @JsonIgnore
    public void addMetric(String groupKey, String key, Object value) {
        Map<String, Map<String, Object>> data = this.data;
        if (data == null) {
            this.data = data = new HashMap<String, Map<String, Object>>();
        }
        Map metricMap = data.computeIfAbsent(groupKey, k -> new HashMap());
        metricMap.put(key, value);
    }

    @JsonIgnore
    public Number getNumericMetric(String groupKey, String key) {
        Object metric = this.getMetric(groupKey, key);
        return metric instanceof Number ? (Number)((Number)metric) : (Number)null;
    }

    @JsonIgnore
    public Object getMetric(String groupKey, String key) {
        Map<String, Object> metricMap;
        Object ret = null;
        Map<String, Map<String, Object>> data = this.data;
        if (data != null && (metricMap = data.get(groupKey)) != null && !metricMap.isEmpty()) {
            ret = metricMap.get(key);
        }
        return ret;
    }
}

