/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.type.AtlasArrayType;
import org.apache.atlas.type.AtlasBuiltInTypes;
import org.apache.atlas.type.AtlasRelationshipType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.atlas.utils.AtlasEntityUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasEntityType
extends AtlasStructType {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasEntityType.class);
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String OWNER = "owner";
    private static final String CREATE_TIME = "createTime";
    private static final String[] ENTITY_HEADER_ATTRIBUTES = new String[]{"name", "description", "owner", "createTime"};
    private static final String OPTION_SCHEMA_ATTRIBUTES = "schemaAttributes";
    private final AtlasEntityDef entityDef;
    private final String typeQryStr;
    private static final String INTERNAL_TYPENAME = "__internal";
    private List<AtlasEntityType> superTypes = Collections.emptyList();
    private Set<String> allSuperTypes = Collections.emptySet();
    private Set<String> subTypes = Collections.emptySet();
    private Set<String> allSubTypes = Collections.emptySet();
    private Set<String> typeAndAllSubTypes = Collections.emptySet();
    private Set<String> typeAndAllSuperTypes = Collections.emptySet();
    private Map<String, Map<String, AtlasStructType.AtlasAttribute>> relationshipAttributes = Collections.emptyMap();
    private List<AtlasStructType.AtlasAttribute> ownedRefAttributes = Collections.emptyList();
    private String typeAndAllSubTypesQryStr = "";
    private boolean isInternalType = false;
    private Map<String, AtlasStructType.AtlasAttribute> headerAttributes = Collections.emptyMap();
    private Map<String, AtlasStructType.AtlasAttribute> minInfoAttributes = Collections.emptyMap();

    public AtlasEntityType(AtlasEntityDef entityDef) {
        super(entityDef);
        this.entityDef = entityDef;
        this.typeQryStr = AtlasStructType.AtlasAttribute.escapeIndexQueryValue(Collections.singleton(this.getTypeName()));
    }

    public AtlasEntityType(AtlasEntityDef entityDef, AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        super(entityDef);
        this.entityDef = entityDef;
        this.typeQryStr = AtlasStructType.AtlasAttribute.escapeIndexQueryValue(Collections.singleton(this.getTypeName()));
        this.resolveReferences(typeRegistry);
    }

    public AtlasEntityDef getEntityDef() {
        return this.entityDef;
    }

    @Override
    void resolveReferences(AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        List schemaAttributeNames;
        super.resolveReferences(typeRegistry);
        ArrayList<AtlasEntityType> s = new ArrayList<AtlasEntityType>();
        HashSet<String> allS = new HashSet<String>();
        HashMap<String, AtlasStructType.AtlasAttribute> allA = new HashMap<String, AtlasStructType.AtlasAttribute>();
        this.getTypeHierarchyInfo(typeRegistry, allS, allA);
        for (String superTypeName : this.entityDef.getSuperTypes()) {
            AtlasType superType = typeRegistry.getType(superTypeName);
            if (superType instanceof AtlasEntityType) {
                s.add((AtlasEntityType)superType);
                continue;
            }
            throw new AtlasBaseException(AtlasErrorCode.INCOMPATIBLE_SUPERTYPE, superTypeName, this.entityDef.getName());
        }
        this.superTypes = Collections.unmodifiableList(s);
        this.allSuperTypes = Collections.unmodifiableSet(allS);
        this.allAttributes = Collections.unmodifiableMap(allA);
        this.uniqAttributes = this.getUniqueAttributes(this.allAttributes);
        this.subTypes = new HashSet<String>();
        this.allSubTypes = new HashSet<String>();
        this.typeAndAllSubTypes = new HashSet<String>();
        this.relationshipAttributes = new HashMap<String, Map<String, AtlasStructType.AtlasAttribute>>();
        this.typeAndAllSubTypes.add(this.getTypeName());
        this.typeAndAllSuperTypes = new HashSet<String>(this.allSuperTypes);
        this.typeAndAllSuperTypes.add(this.getTypeName());
        this.typeAndAllSuperTypes = Collections.unmodifiableSet(this.typeAndAllSuperTypes);
        this.headerAttributes = new HashMap<String, AtlasStructType.AtlasAttribute>(this.uniqAttributes);
        for (String headerAttributeName : ENTITY_HEADER_ATTRIBUTES) {
            AtlasStructType.AtlasAttribute headerAttribute = this.getAttribute(headerAttributeName);
            if (headerAttribute == null) continue;
            this.headerAttributes.put(headerAttributeName, headerAttribute);
        }
        this.minInfoAttributes = new HashMap<String, AtlasStructType.AtlasAttribute>(this.headerAttributes);
        Map<String, String> typeDefOptions = this.entityDef.getOptions();
        String jsonList = typeDefOptions != null ? typeDefOptions.get(OPTION_SCHEMA_ATTRIBUTES) : null;
        List list = schemaAttributeNames = StringUtils.isNotEmpty((String)jsonList) ? AtlasType.fromJson(jsonList, List.class) : null;
        if (CollectionUtils.isNotEmpty((Collection)schemaAttributeNames)) {
            for (String schemaAttributeName : schemaAttributeNames) {
                AtlasStructType.AtlasAttribute schemaAttribute = this.getAttribute(schemaAttributeName);
                if (schemaAttribute == null) continue;
                this.minInfoAttributes.put(schemaAttributeName, schemaAttribute);
            }
        }
    }

    @Override
    void resolveReferencesPhase2(AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        super.resolveReferencesPhase2(typeRegistry);
        for (AtlasEntityType superType : this.superTypes) {
            superType.addSubType(this);
        }
        for (String superTypeName : this.allSuperTypes) {
            AtlasEntityType superType = typeRegistry.getEntityTypeByName(superTypeName);
            superType.addToAllSubTypes(this);
        }
    }

    @Override
    void resolveReferencesPhase3(AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        for (AtlasStructDef.AtlasAttributeDef atlasAttributeDef : this.getStructDef().getAttributeDefs()) {
            String attributeName = atlasAttributeDef.getName();
            AtlasType attributeType = typeRegistry.getType(atlasAttributeDef.getTypeName());
            AtlasEntityType attributeEntityType = this.getReferencedEntityType(attributeType);
            if (attributeEntityType == null || this.hasRelationshipAttribute(attributeName)) continue;
            typeRegistry.reportMissingRelationshipDef(this.getTypeName(), attributeEntityType.getTypeName(), attributeName);
        }
        for (String string : this.allSuperTypes) {
            Object superType;
            Map<String, Map<String, AtlasStructType.AtlasAttribute>> superTypeRelationshipAttributes;
            if (INTERNAL_TYPENAME.equals(string)) {
                this.isInternalType = true;
            }
            if (!MapUtils.isNotEmpty(superTypeRelationshipAttributes = ((AtlasEntityType)(superType = typeRegistry.getEntityTypeByName(string))).getRelationshipAttributes())) continue;
            for (String string2 : superTypeRelationshipAttributes.keySet()) {
                Map<String, AtlasStructType.AtlasAttribute> superTypeAttributes = superTypeRelationshipAttributes.get(string2);
                if (!MapUtils.isNotEmpty(superTypeAttributes)) continue;
                Map<String, AtlasStructType.AtlasAttribute> attributes = this.relationshipAttributes.get(string2);
                if (attributes == null) {
                    attributes = new HashMap<String, AtlasStructType.AtlasAttribute>();
                    this.relationshipAttributes.put(string2, attributes);
                }
                for (String relationshipType : superTypeAttributes.keySet()) {
                    if (attributes.containsKey(relationshipType)) continue;
                    attributes.put(relationshipType, superTypeAttributes.get(relationshipType));
                }
            }
        }
        this.ownedRefAttributes = new ArrayList<AtlasStructType.AtlasAttribute>();
        for (AtlasStructType.AtlasAttribute atlasAttribute : this.allAttributes.values()) {
            if (!atlasAttribute.isOwnedRef()) continue;
            this.ownedRefAttributes.add(atlasAttribute);
        }
        for (Map map : this.relationshipAttributes.values()) {
            for (AtlasStructType.AtlasAttribute attribute : map.values()) {
                if (!attribute.isOwnedRef()) continue;
                this.ownedRefAttributes.add(attribute);
            }
        }
        this.subTypes = Collections.unmodifiableSet(this.subTypes);
        this.allSubTypes = Collections.unmodifiableSet(this.allSubTypes);
        this.typeAndAllSubTypes = Collections.unmodifiableSet(this.typeAndAllSubTypes);
        this.typeAndAllSubTypesQryStr = "";
        this.relationshipAttributes = Collections.unmodifiableMap(this.relationshipAttributes);
        this.ownedRefAttributes = Collections.unmodifiableList(this.ownedRefAttributes);
        this.entityDef.setSubTypes(this.subTypes);
        ArrayList<AtlasEntityDef.AtlasRelationshipAttributeDef> relationshipAttrDefs = new ArrayList<AtlasEntityDef.AtlasRelationshipAttributeDef>();
        for (Map.Entry<String, Map<String, AtlasStructType.AtlasAttribute>> attrEntry : this.relationshipAttributes.entrySet()) {
            Map<String, AtlasStructType.AtlasAttribute> relations = attrEntry.getValue();
            for (Map.Entry entry : relations.entrySet()) {
                String relationshipType = (String)entry.getKey();
                AtlasStructType.AtlasAttribute relationshipAttr = (AtlasStructType.AtlasAttribute)entry.getValue();
                relationshipAttrDefs.add(new AtlasEntityDef.AtlasRelationshipAttributeDef(relationshipType, relationshipAttr.isLegacyAttribute(), relationshipAttr.getAttributeDef()));
            }
        }
        this.entityDef.setRelationshipAttributeDefs(Collections.unmodifiableList(relationshipAttrDefs));
    }

    public Set<String> getSuperTypes() {
        return this.entityDef.getSuperTypes();
    }

    public Set<String> getAllSuperTypes() {
        return this.allSuperTypes;
    }

    public Set<String> getSubTypes() {
        return this.subTypes;
    }

    public Set<String> getAllSubTypes() {
        return this.allSubTypes;
    }

    public Set<String> getTypeAndAllSubTypes() {
        return this.typeAndAllSubTypes;
    }

    public Set<String> getTypeAndAllSuperTypes() {
        return this.typeAndAllSuperTypes;
    }

    public Map<String, AtlasStructType.AtlasAttribute> getHeaderAttributes() {
        return this.headerAttributes;
    }

    public Map<String, AtlasStructType.AtlasAttribute> getMinInfoAttributes() {
        return this.minInfoAttributes;
    }

    public boolean isSuperTypeOf(AtlasEntityType entityType) {
        return entityType != null && this.allSubTypes.contains(entityType.getTypeName());
    }

    public boolean isSuperTypeOf(String entityTypeName) {
        return StringUtils.isNotEmpty((String)entityTypeName) && this.allSubTypes.contains(entityTypeName);
    }

    public boolean isTypeOrSuperTypeOf(String entityTypeName) {
        return StringUtils.isNotEmpty((String)entityTypeName) && this.typeAndAllSubTypes.contains(entityTypeName);
    }

    public boolean isSubTypeOf(AtlasEntityType entityType) {
        return entityType != null && this.allSuperTypes.contains(entityType.getTypeName());
    }

    public boolean isSubTypeOf(String entityTypeName) {
        return StringUtils.isNotEmpty((String)entityTypeName) && this.allSuperTypes.contains(entityTypeName);
    }

    public boolean isInternalType() {
        return this.isInternalType;
    }

    public Map<String, Map<String, AtlasStructType.AtlasAttribute>> getRelationshipAttributes() {
        return this.relationshipAttributes;
    }

    public List<AtlasStructType.AtlasAttribute> getOwnedRefAttributes() {
        return this.ownedRefAttributes;
    }

    public AtlasStructType.AtlasAttribute getRelationshipAttribute(String attributeName, String relationshipType) {
        Map<String, AtlasStructType.AtlasAttribute> attributes = this.relationshipAttributes.get(attributeName);
        AtlasStructType.AtlasAttribute ret = MapUtils.isNotEmpty(attributes) ? (relationshipType != null && attributes.containsKey(relationshipType) ? attributes.get(relationshipType) : attributes.values().iterator().next()) : null;
        return ret;
    }

    void addRelationshipAttribute(String attributeName, AtlasStructType.AtlasAttribute attribute, AtlasRelationshipType relationshipType) {
        Map<String, AtlasStructType.AtlasAttribute> attributes = this.relationshipAttributes.get(attributeName);
        if (attributes == null) {
            attributes = new HashMap<String, AtlasStructType.AtlasAttribute>();
            this.relationshipAttributes.put(attributeName, attributes);
        }
        attributes.put(relationshipType.getTypeName(), attribute);
    }

    public Set<String> getAttributeRelationshipTypes(String attributeName) {
        Map<String, AtlasStructType.AtlasAttribute> attributes = this.relationshipAttributes.get(attributeName);
        return attributes != null ? attributes.keySet() : null;
    }

    public String getTypeAndAllSubTypesQryStr() {
        if (StringUtils.isEmpty((String)this.typeAndAllSubTypesQryStr)) {
            this.typeAndAllSubTypesQryStr = AtlasStructType.AtlasAttribute.escapeIndexQueryValue(this.typeAndAllSubTypes);
        }
        return this.typeAndAllSubTypesQryStr;
    }

    public String getTypeQryStr() {
        return this.typeQryStr;
    }

    public boolean hasAttribute(String attributeName) {
        return this.allAttributes.containsKey(attributeName);
    }

    public boolean hasRelationshipAttribute(String attributeName) {
        return this.relationshipAttributes.containsKey(attributeName);
    }

    @Override
    public String getQualifiedAttributeName(String attrName) throws AtlasBaseException {
        if (this.allAttributes.containsKey(attrName)) {
            return ((AtlasStructType.AtlasAttribute)this.allAttributes.get(attrName)).getQualifiedName();
        }
        if (this.relationshipAttributes.containsKey(attrName)) {
            return this.relationshipAttributes.get(attrName).values().iterator().next().getQualifiedName();
        }
        throw new AtlasBaseException(AtlasErrorCode.UNKNOWN_ATTRIBUTE, attrName, this.entityDef.getName());
    }

    @Override
    public AtlasEntity createDefaultValue() {
        AtlasEntity ret = new AtlasEntity(this.entityDef.getName());
        this.populateDefaultValues(ret);
        return ret;
    }

    @Override
    public AtlasEntity createDefaultValue(Object defaultValue) {
        AtlasEntity ret = new AtlasEntity(this.entityDef.getName());
        this.populateDefaultValues(ret);
        return ret;
    }

    @Override
    public boolean isValidValue(Object obj) {
        if (obj != null) {
            for (AtlasEntityType superType : this.superTypes) {
                if (superType.isValidValue(obj)) continue;
                return false;
            }
            return super.isValidValue(obj) && this.validateRelationshipAttributes(obj);
        }
        return true;
    }

    @Override
    public boolean areEqualValues(Object val1, Object val2, Map<String, String> guidAssignments) {
        for (AtlasEntityType superType : this.superTypes) {
            if (superType.areEqualValues(val1, val2, guidAssignments)) continue;
            return false;
        }
        return super.areEqualValues(val1, val2, guidAssignments);
    }

    @Override
    public boolean isValidValueForUpdate(Object obj) {
        if (obj != null) {
            for (AtlasEntityType superType : this.superTypes) {
                if (superType.isValidValueForUpdate(obj)) continue;
                return false;
            }
            return super.isValidValueForUpdate(obj);
        }
        return true;
    }

    @Override
    public Object getNormalizedValue(Object obj) {
        Object ret = null;
        if (obj != null && this.isValidValue(obj)) {
            if (obj instanceof AtlasEntity) {
                this.normalizeAttributeValues((AtlasEntity)obj);
                ret = obj;
            } else if (obj instanceof Map) {
                this.normalizeAttributeValues((Map)obj);
                ret = obj;
            }
        }
        return ret;
    }

    @Override
    public Object getNormalizedValueForUpdate(Object obj) {
        Object ret = null;
        if (obj != null && this.isValidValueForUpdate(obj)) {
            if (obj instanceof AtlasEntity) {
                this.normalizeAttributeValuesForUpdate((AtlasEntity)obj);
                ret = obj;
            } else if (obj instanceof Map) {
                this.normalizeAttributeValuesForUpdate((Map)obj);
                ret = obj;
            }
        }
        return ret;
    }

    @Override
    public AtlasStructType.AtlasAttribute getAttribute(String attributeName) {
        return (AtlasStructType.AtlasAttribute)this.allAttributes.get(attributeName);
    }

    @Override
    public boolean validateValue(Object obj, String objName, List<String> messages) {
        boolean ret = true;
        if (obj != null) {
            if (obj instanceof AtlasEntity || obj instanceof Map) {
                for (AtlasEntityType superType : this.superTypes) {
                    ret = superType.validateValue(obj, objName, messages) && ret;
                }
                ret = super.validateValue(obj, objName, messages) && this.validateRelationshipAttributes(obj, objName, messages) && ret;
            } else {
                ret = false;
                messages.add(objName + ": invalid value type '" + obj.getClass().getName());
            }
        }
        return ret;
    }

    @Override
    public boolean validateValueForUpdate(Object obj, String objName, List<String> messages) {
        boolean ret = true;
        if (obj != null) {
            if (obj instanceof AtlasEntity || obj instanceof Map) {
                for (AtlasEntityType superType : this.superTypes) {
                    ret = superType.validateValueForUpdate(obj, objName, messages) && ret;
                }
                ret = super.validateValueForUpdate(obj, objName, messages) && ret;
            } else {
                ret = false;
                messages.add(objName + ": invalid value type '" + obj.getClass().getName());
            }
        }
        return ret;
    }

    @Override
    public AtlasType getTypeForAttribute() {
        AtlasBuiltInTypes.AtlasObjectIdType attributeType = new AtlasBuiltInTypes.AtlasObjectIdType(this.getTypeName());
        if (LOG.isDebugEnabled()) {
            LOG.debug("getTypeForAttribute(): {} ==> {}", (Object)this.getTypeName(), (Object)attributeType.getTypeName());
        }
        return attributeType;
    }

    public void normalizeAttributeValues(AtlasEntity ent) {
        if (ent != null) {
            for (AtlasEntityType superType : this.superTypes) {
                superType.normalizeAttributeValues(ent);
            }
            super.normalizeAttributeValues(ent);
            this.normalizeRelationshipAttributeValues(ent, false);
        }
    }

    public void normalizeAttributeValuesForUpdate(AtlasEntity ent) {
        if (ent != null) {
            for (AtlasEntityType superType : this.superTypes) {
                superType.normalizeAttributeValuesForUpdate(ent);
            }
            super.normalizeAttributeValuesForUpdate(ent);
            this.normalizeRelationshipAttributeValues(ent, true);
        }
    }

    @Override
    public void normalizeAttributeValues(Map<String, Object> obj) {
        if (obj != null) {
            for (AtlasEntityType superType : this.superTypes) {
                superType.normalizeAttributeValues(obj);
            }
            super.normalizeAttributeValues(obj);
            this.normalizeRelationshipAttributeValues(obj, false);
        }
    }

    @Override
    public void normalizeAttributeValuesForUpdate(Map<String, Object> obj) {
        if (obj != null) {
            for (AtlasEntityType superType : this.superTypes) {
                superType.normalizeAttributeValuesForUpdate(obj);
            }
            super.normalizeAttributeValuesForUpdate(obj);
            this.normalizeRelationshipAttributeValues(obj, true);
        }
    }

    public void populateDefaultValues(AtlasEntity ent) {
        if (ent != null) {
            for (AtlasEntityType superType : this.superTypes) {
                superType.populateDefaultValues(ent);
            }
            super.populateDefaultValues(ent);
        }
    }

    private void addSubType(AtlasEntityType subType) {
        this.subTypes.add(subType.getTypeName());
    }

    private void addToAllSubTypes(AtlasEntityType subType) {
        this.allSubTypes.add(subType.getTypeName());
        this.typeAndAllSubTypes.add(subType.getTypeName());
    }

    private void getTypeHierarchyInfo(AtlasTypeRegistry typeRegistry, Set<String> allSuperTypeNames, Map<String, AtlasStructType.AtlasAttribute> allAttributes) throws AtlasBaseException {
        ArrayList<String> visitedTypes = new ArrayList<String>();
        this.collectTypeHierarchyInfo(typeRegistry, allSuperTypeNames, allAttributes, visitedTypes);
    }

    private void collectTypeHierarchyInfo(AtlasTypeRegistry typeRegistry, Set<String> allSuperTypeNames, Map<String, AtlasStructType.AtlasAttribute> allAttributes, List<String> visitedTypes) throws AtlasBaseException {
        if (visitedTypes.contains(this.entityDef.getName())) {
            throw new AtlasBaseException(AtlasErrorCode.CIRCULAR_REFERENCE, this.entityDef.getName(), visitedTypes.toString());
        }
        if (CollectionUtils.isNotEmpty(this.entityDef.getSuperTypes())) {
            visitedTypes.add(this.entityDef.getName());
            for (String superTypeName : this.entityDef.getSuperTypes()) {
                AtlasEntityType superType = typeRegistry.getEntityTypeByName(superTypeName);
                if (superType == null) continue;
                superType.collectTypeHierarchyInfo(typeRegistry, allSuperTypeNames, allAttributes, visitedTypes);
            }
            visitedTypes.remove(this.entityDef.getName());
            allSuperTypeNames.addAll(this.entityDef.getSuperTypes());
        }
        if (CollectionUtils.isNotEmpty(this.entityDef.getAttributeDefs())) {
            for (AtlasStructDef.AtlasAttributeDef attributeDef : this.entityDef.getAttributeDefs()) {
                AtlasType type = typeRegistry.getType(attributeDef.getTypeName());
                allAttributes.put(attributeDef.getName(), new AtlasStructType.AtlasAttribute(this, attributeDef, type));
            }
        }
    }

    boolean isAssignableFrom(AtlasObjectId objId) {
        boolean ret = AtlasTypeUtil.isValid(objId) && (StringUtils.equals((String)objId.getTypeName(), (String)this.getTypeName()) || this.isSuperTypeOf(objId.getTypeName()));
        return ret;
    }

    private boolean validateRelationshipAttributes(Object obj) {
        if (obj != null && MapUtils.isNotEmpty(this.relationshipAttributes)) {
            if (obj instanceof AtlasEntity) {
                AtlasEntity entityObj = (AtlasEntity)obj;
                for (String attributeName : this.relationshipAttributes.keySet()) {
                    String relationshipType;
                    AtlasStructType.AtlasAttribute attribute;
                    AtlasStructDef.AtlasAttributeDef attributeDef;
                    Object attributeValue = entityObj.getRelationshipAttribute(attributeName);
                    if (this.isAssignableValue(attributeValue, attributeDef = (attribute = this.getRelationshipAttribute(attributeName, relationshipType = AtlasEntityUtil.getRelationshipType(attributeValue))).getAttributeDef())) continue;
                    return false;
                }
            } else if (obj instanceof Map) {
                Map map = AtlasTypeUtil.toRelationshipAttributes((Map)obj);
                for (String attributeName : this.relationshipAttributes.keySet()) {
                    String relationshipType;
                    AtlasStructType.AtlasAttribute attribute;
                    AtlasStructDef.AtlasAttributeDef attributeDef;
                    Object attributeValue = map.get(attributeName);
                    if (this.isAssignableValue(attributeValue, attributeDef = (attribute = this.getRelationshipAttribute(attributeName, relationshipType = AtlasEntityUtil.getRelationshipType(attributeValue))).getAttributeDef())) continue;
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public static Set<String> getEntityTypesAndAllSubTypes(Set<String> entityTypes, AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        HashSet<String> ret = new HashSet<String>();
        for (String typeName : entityTypes) {
            AtlasEntityType entityType = typeRegistry.getEntityTypeByName(typeName);
            if (entityType == null) {
                throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_NOT_FOUND, typeName);
            }
            ret.addAll(entityType.getTypeAndAllSubTypes());
        }
        return ret;
    }

    private boolean isAssignableValue(Object value, AtlasStructDef.AtlasAttributeDef attributeDef) {
        boolean ret = true;
        if (value != null) {
            AtlasType attrType;
            String relationshipType = AtlasEntityUtil.getRelationshipType(value);
            AtlasStructType.AtlasAttribute attribute = this.getRelationshipAttribute(attributeDef.getName(), relationshipType);
            if (attribute != null && !this.isValidRelationshipType(attrType = attribute.getAttributeType()) && !attrType.isValidValue(value)) {
                ret = false;
            }
        }
        return ret;
    }

    private boolean isValidRelationshipType(AtlasType attributeType) {
        boolean ret = false;
        if (attributeType != null) {
            if (attributeType instanceof AtlasArrayType) {
                attributeType = ((AtlasArrayType)attributeType).getElementType();
            }
            if (attributeType instanceof AtlasBuiltInTypes.AtlasObjectIdType || attributeType instanceof AtlasEntityType) {
                ret = true;
            }
        }
        return ret;
    }

    private void normalizeRelationshipAttributeValues(AtlasEntity entity, boolean isUpdate) {
        if (entity != null) {
            for (String attributeName : this.relationshipAttributes.keySet()) {
                AtlasType attrType;
                Object attributeValue;
                String relationshipType;
                AtlasStructType.AtlasAttribute attribute;
                if (!entity.hasRelationshipAttribute(attributeName) || (attribute = this.getRelationshipAttribute(attributeName, relationshipType = AtlasEntityUtil.getRelationshipType(attributeValue = entity.getRelationshipAttribute(attributeName)))) == null || !this.isValidRelationshipType(attrType = attribute.getAttributeType())) continue;
                attributeValue = isUpdate ? attrType.getNormalizedValueForUpdate(attributeValue) : attrType.getNormalizedValue(attributeValue);
                entity.setRelationshipAttribute(attributeName, attributeValue);
            }
        }
    }

    public void normalizeRelationshipAttributeValues(Map<String, Object> obj, boolean isUpdate) {
        if (obj != null) {
            for (String attributeName : this.relationshipAttributes.keySet()) {
                AtlasType attrType;
                Object attributeValue;
                String relationshipType;
                AtlasStructType.AtlasAttribute attribute;
                if (!obj.containsKey(attributeName) || (attribute = this.getRelationshipAttribute(attributeName, relationshipType = AtlasEntityUtil.getRelationshipType(attributeValue = obj.get(attributeName)))) == null || !this.isValidRelationshipType(attrType = attribute.getAttributeType())) continue;
                attributeValue = isUpdate ? attrType.getNormalizedValueForUpdate(attributeValue) : attrType.getNormalizedValue(attributeValue);
                obj.put(attributeName, attributeValue);
            }
        }
    }

    private boolean validateRelationshipAttributes(Object obj, String objName, List<String> messages) {
        boolean ret = true;
        if (obj != null && MapUtils.isNotEmpty(this.relationshipAttributes)) {
            if (obj instanceof AtlasEntity) {
                AtlasEntity entityObj = (AtlasEntity)obj;
                for (String attributeName : this.relationshipAttributes.keySet()) {
                    Object value;
                    String relationshipType;
                    AtlasStructType.AtlasAttribute attribute = this.getRelationshipAttribute(attributeName, relationshipType = AtlasEntityUtil.getRelationshipType(value = entityObj.getRelationshipAttribute(attributeName)));
                    if (attribute == null) continue;
                    AtlasType dataType = attribute.getAttributeType();
                    if (!attribute.getAttributeDef().getIsOptional()) {
                        if (value == null) {
                            value = entityObj.getRelationshipAttribute(attributeName);
                        }
                        if (value == null) {
                            ret = false;
                            messages.add(objName + "." + attributeName + ": mandatory attribute value missing in type " + this.getTypeName());
                        }
                    }
                    if (!this.isValidRelationshipType(dataType) || value == null) continue;
                    ret = dataType.validateValue(value, objName + "." + attributeName, messages) && ret;
                }
            } else if (obj instanceof Map) {
                Map attributes = AtlasTypeUtil.toRelationshipAttributes((Map)obj);
                for (String attributeName : this.relationshipAttributes.keySet()) {
                    AtlasType dataType;
                    Object value;
                    String relationshipType;
                    AtlasStructType.AtlasAttribute attribute = this.getRelationshipAttribute(attributeName, relationshipType = AtlasEntityUtil.getRelationshipType(value = attributes.get(attributeName)));
                    if (attribute == null || !this.isValidRelationshipType(dataType = attribute.getAttributeType()) || value == null) continue;
                    ret = dataType.validateValue(value, objName + "." + attributeName, messages) && ret;
                }
            } else {
                ret = false;
                messages.add(objName + "=" + obj + ": invalid value for type " + this.getTypeName());
            }
        }
        return ret;
    }
}

