/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.type;

import java.util.Map;
import java.util.Objects;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasRelationship;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasRelationshipDef;
import org.apache.atlas.model.typedef.AtlasRelationshipEndDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.type.AtlasArrayType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasRelationshipType
extends AtlasStructType {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasRelationshipType.class);
    private final AtlasRelationshipDef relationshipDef;
    private final boolean hasLegacyAttributeEnd;
    private String relationshipLabel;
    private AtlasEntityType end1Type;
    private AtlasEntityType end2Type;

    public AtlasRelationshipType(AtlasRelationshipDef relationshipDef) {
        super(relationshipDef);
        AtlasRelationshipEndDef end1Def = relationshipDef != null ? relationshipDef.getEndDef1() : null;
        AtlasRelationshipEndDef end2Def = relationshipDef != null ? relationshipDef.getEndDef2() : null;
        this.relationshipDef = relationshipDef;
        this.hasLegacyAttributeEnd = end1Def != null && end1Def.getIsLegacyAttribute() || end2Def != null && end2Def.getIsLegacyAttribute();
    }

    public AtlasRelationshipType(AtlasRelationshipDef relationshipDef, AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        this(relationshipDef);
        this.resolveReferences(typeRegistry);
    }

    public AtlasRelationshipDef getRelationshipDef() {
        return this.relationshipDef;
    }

    public boolean hasLegacyAttributeEnd() {
        return this.hasLegacyAttributeEnd;
    }

    public String getRelationshipLabel() {
        return this.relationshipLabel;
    }

    @Override
    void resolveReferences(AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        super.resolveReferences(typeRegistry);
        if (this.relationshipDef == null) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_VALUE, "relationshipDef is null");
        }
        String end1TypeName = this.relationshipDef.getEndDef1() != null ? this.relationshipDef.getEndDef1().getType() : null;
        String end2TypeName = this.relationshipDef.getEndDef2() != null ? this.relationshipDef.getEndDef2().getType() : null;
        AtlasType type1 = typeRegistry.getType(end1TypeName);
        AtlasType type2 = typeRegistry.getType(end2TypeName);
        if (!(type1 instanceof AtlasEntityType)) {
            throw new AtlasBaseException(AtlasErrorCode.RELATIONSHIPDEF_INVALID_END_TYPE, this.getTypeName(), end1TypeName);
        }
        this.end1Type = (AtlasEntityType)type1;
        if (!(type2 instanceof AtlasEntityType)) {
            throw new AtlasBaseException(AtlasErrorCode.RELATIONSHIPDEF_INVALID_END_TYPE, this.getTypeName(), end2TypeName);
        }
        this.end2Type = (AtlasEntityType)type2;
        AtlasRelationshipType.validateAtlasRelationshipDef(this.relationshipDef);
    }

    @Override
    void resolveReferencesPhase2(AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        super.resolveReferencesPhase2(typeRegistry);
        AtlasRelationshipEndDef endDef1 = this.relationshipDef.getEndDef1();
        AtlasRelationshipEndDef endDef2 = this.relationshipDef.getEndDef2();
        String relationshipLabel = this.relationshipDef.getRelationshipLabel();
        if (relationshipLabel == null) {
            if (!endDef1.getIsLegacyAttribute() && !endDef2.getIsLegacyAttribute()) {
                relationshipLabel = "r:" + this.getTypeName();
            } else if (endDef1.getIsLegacyAttribute() && !endDef2.getIsLegacyAttribute()) {
                relationshipLabel = this.getLegacyEdgeLabel(this.end1Type, endDef1.getName());
            } else if (!endDef1.getIsLegacyAttribute() && endDef2.getIsLegacyAttribute()) {
                relationshipLabel = this.getLegacyEdgeLabel(this.end2Type, endDef2.getName());
            }
        }
        this.relationshipLabel = relationshipLabel;
        this.addRelationshipAttributeToEndType(endDef1, this.end1Type, this.end2Type.getTypeName(), typeRegistry, relationshipLabel);
        this.addRelationshipAttributeToEndType(endDef2, this.end2Type, this.end1Type.getTypeName(), typeRegistry, relationshipLabel);
        this.addRelationshipEdgeDirection();
    }

    private void addRelationshipEdgeDirection() {
        AtlasRelationshipEndDef endDef1 = this.relationshipDef.getEndDef1();
        AtlasRelationshipEndDef endDef2 = this.relationshipDef.getEndDef2();
        if (StringUtils.equals((String)endDef1.getType(), (String)endDef2.getType()) && StringUtils.equals((String)endDef1.getName(), (String)endDef2.getName())) {
            AtlasStructType.AtlasAttribute endAttribute = this.end1Type.getRelationshipAttribute(endDef1.getName(), this.relationshipDef.getName());
            endAttribute.setRelationshipEdgeDirection(AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection.BOTH);
        } else {
            AtlasStructType.AtlasAttribute end1Attribute = this.end1Type.getRelationshipAttribute(endDef1.getName(), this.relationshipDef.getName());
            AtlasStructType.AtlasAttribute end2Attribute = this.end2Type.getRelationshipAttribute(endDef2.getName(), this.relationshipDef.getName());
            AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection end1Direction = AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection.OUT;
            AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection end2Direction = AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection.IN;
            if (endDef1.getIsLegacyAttribute() && endDef2.getIsLegacyAttribute()) {
                if (this.relationshipDef.getRelationshipLabel() == null) {
                    end2Direction = AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection.OUT;
                }
            } else if (!endDef1.getIsLegacyAttribute() && endDef2.getIsLegacyAttribute()) {
                end1Direction = AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection.IN;
                end2Direction = AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection.OUT;
            }
            end1Attribute.setRelationshipEdgeDirection(end1Direction);
            end2Attribute.setRelationshipEdgeDirection(end2Direction);
        }
    }

    @Override
    public boolean isValidValue(Object obj) {
        if (obj != null) {
            if (obj instanceof AtlasRelationship) {
                return this.validateRelationship((AtlasRelationship)obj);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean areEqualValues(Object val1, Object val2, Map<String, String> guidAssignments) {
        AtlasRelationship rel2;
        AtlasRelationship rel1;
        boolean ret = val1 == null ? val2 == null : (val2 == null ? false : ((rel1 = this.getRelationshipFromValue(val1)) == null ? false : ((rel2 = this.getRelationshipFromValue(val2)) == null ? false : (!super.areEqualValues(rel1, rel2, guidAssignments) ? false : Objects.equals(rel1.getGuid(), rel2.getGuid()) && Objects.equals(rel1.getEnd1(), rel2.getEnd1()) && Objects.equals(rel1.getEnd2(), rel2.getEnd2()) && Objects.equals(rel1.getLabel(), rel2.getLabel()) && Objects.equals((Object)rel1.getPropagateTags(), (Object)rel2.getPropagateTags()) && Objects.equals((Object)rel1.getStatus(), (Object)rel2.getStatus())))));
        return ret;
    }

    @Override
    public boolean isValidValueForUpdate(Object obj) {
        if (obj != null) {
            if (obj instanceof AtlasRelationship) {
                return this.validateRelationship((AtlasRelationship)obj);
            }
            return false;
        }
        return true;
    }

    public AtlasEntityType getEnd1Type() {
        return this.end1Type;
    }

    public AtlasEntityType getEnd2Type() {
        return this.end2Type;
    }

    private boolean validateRelationship(AtlasRelationship relationship) {
        String end2TypeName;
        String end1TypeName = relationship.getEnd1() != null ? relationship.getEnd1().getTypeName() : null;
        String string = end2TypeName = relationship.getEnd2() != null ? relationship.getEnd2().getTypeName() : null;
        if (StringUtils.isNotEmpty((String)end1TypeName) && StringUtils.isNotEmpty((String)end2TypeName)) {
            return this.end1Type.isTypeOrSuperTypeOf(end1TypeName) && this.end2Type.isTypeOrSuperTypeOf(end2TypeName) && super.isValidValue(relationship);
        }
        return false;
    }

    public static void validateAtlasRelationshipDef(AtlasRelationshipDef relationshipDef) throws AtlasBaseException {
        AtlasRelationshipEndDef endDef1 = relationshipDef.getEndDef1();
        AtlasRelationshipEndDef endDef2 = relationshipDef.getEndDef2();
        AtlasRelationshipDef.RelationshipCategory relationshipCategory = relationshipDef.getRelationshipCategory();
        String name = relationshipDef.getName();
        boolean isContainer1 = endDef1.getIsContainer();
        boolean isContainer2 = endDef2.getIsContainer();
        if (endDef1.getCardinality() == AtlasStructDef.AtlasAttributeDef.Cardinality.LIST || endDef2.getCardinality() == AtlasStructDef.AtlasAttributeDef.Cardinality.LIST) {
            throw new AtlasBaseException(AtlasErrorCode.RELATIONSHIPDEF_LIST_ON_END, name);
        }
        if (isContainer1 && isContainer2) {
            throw new AtlasBaseException(AtlasErrorCode.RELATIONSHIPDEF_DOUBLE_CONTAINERS, name);
        }
        if (isContainer1 || isContainer2) {
            if (relationshipCategory == AtlasRelationshipDef.RelationshipCategory.ASSOCIATION) {
                throw new AtlasBaseException(AtlasErrorCode.RELATIONSHIPDEF_ASSOCIATION_AND_CONTAINER, name);
            }
        } else {
            if (relationshipCategory == AtlasRelationshipDef.RelationshipCategory.COMPOSITION) {
                throw new AtlasBaseException(AtlasErrorCode.RELATIONSHIPDEF_COMPOSITION_NO_CONTAINER, name);
            }
            if (relationshipCategory == AtlasRelationshipDef.RelationshipCategory.AGGREGATION) {
                throw new AtlasBaseException(AtlasErrorCode.RELATIONSHIPDEF_AGGREGATION_NO_CONTAINER, name);
            }
        }
        if (relationshipCategory == AtlasRelationshipDef.RelationshipCategory.COMPOSITION) {
            if (endDef1.getCardinality() == AtlasStructDef.AtlasAttributeDef.Cardinality.SET && !endDef1.getIsContainer()) {
                throw new AtlasBaseException(AtlasErrorCode.RELATIONSHIPDEF_COMPOSITION_MULTIPLE_PARENTS, name);
            }
            if (endDef2.getCardinality() == AtlasStructDef.AtlasAttributeDef.Cardinality.SET && !endDef2.getIsContainer()) {
                throw new AtlasBaseException(AtlasErrorCode.RELATIONSHIPDEF_COMPOSITION_MULTIPLE_PARENTS, name);
            }
        }
    }

    private void addRelationshipAttributeToEndType(AtlasRelationshipEndDef endDef, AtlasEntityType entityType, String attrTypeName, AtlasTypeRegistry typeRegistry, String relationshipLabel) throws AtlasBaseException {
        String attrName;
        String string = attrName = endDef != null ? endDef.getName() : null;
        if (StringUtils.isEmpty((String)attrName)) {
            return;
        }
        AtlasStructType.AtlasAttribute attribute = entityType.getAttribute(attrName);
        if (relationshipLabel == null) {
            relationshipLabel = this.getLegacyEdgeLabel(entityType, attrName);
        }
        if (attribute == null) {
            AtlasType attrType;
            AtlasStructDef.AtlasAttributeDef.Cardinality cardinality = endDef.getCardinality();
            boolean isOptional = true;
            AtlasStructDef.AtlasConstraintDef constraint = null;
            if (cardinality == AtlasStructDef.AtlasAttributeDef.Cardinality.SET) {
                attrTypeName = AtlasBaseTypeDef.getArrayTypeName(attrTypeName);
            }
            if (this.relationshipDef.getRelationshipCategory() == AtlasRelationshipDef.RelationshipCategory.COMPOSITION) {
                if (endDef.getIsContainer()) {
                    constraint = new AtlasStructDef.AtlasConstraintDef("ownedRef");
                } else {
                    isOptional = false;
                }
            }
            AtlasStructDef.AtlasAttributeDef attributeDef = new AtlasStructDef.AtlasAttributeDef(attrName, attrTypeName, isOptional, cardinality);
            if (constraint != null) {
                attributeDef.addConstraint(constraint);
            }
            if ((attrType = typeRegistry.getType(attrTypeName)) instanceof AtlasArrayType) {
                AtlasArrayType arrayType = (AtlasArrayType)attrType;
                arrayType.setCardinality(attributeDef.getCardinality());
            }
            attribute = new AtlasStructType.AtlasAttribute(entityType, attributeDef, attrType, this.getTypeName(), relationshipLabel);
            attribute.setLegacyAttribute(endDef.getIsLegacyAttribute());
        } else {
            attribute.setRelationshipName(this.getTypeName());
            attribute.setRelationshipEdgeLabel(relationshipLabel);
            attribute.setLegacyAttribute(true);
        }
        entityType.addRelationshipAttribute(attrName, attribute, this);
    }

    private String getLegacyEdgeLabel(AtlasEntityType entityType, String attributeName) {
        String ret = null;
        AtlasStructType.AtlasAttribute attribute = entityType.getAttribute(attributeName);
        if (attribute != null) {
            ret = "__" + attribute.getQualifiedName();
        }
        return ret;
    }

    private AtlasRelationship getRelationshipFromValue(Object val) {
        AtlasRelationship ret = val instanceof AtlasRelationship ? (AtlasRelationship)val : (val instanceof Map ? new AtlasRelationship((Map)val) : null);
        return ret;
    }
}

