/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.feed;

import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.feed.EntryFilter;
import org.apache.camel.component.feed.FeedEndpoint;
import org.apache.camel.component.feed.FeedPollingConsumer;
import org.apache.camel.resume.ResumeAdapter;
import org.apache.camel.resume.ResumeAware;
import org.apache.camel.resume.ResumeStrategy;

public abstract class FeedEntryPollingConsumer<E>
extends FeedPollingConsumer
implements ResumeAware<ResumeStrategy> {
    protected int entryIndex;
    protected ResumeStrategy resumeStrategy;
    protected List<E> list;
    protected boolean throttleEntries;
    protected Object feed;

    public FeedEntryPollingConsumer(FeedEndpoint endpoint, Processor processor, boolean throttleEntries) {
        super(endpoint, processor);
        this.throttleEntries = throttleEntries;
    }

    @Override
    public int poll() throws Exception {
        if (this.feed == null) {
            this.feed = this.createFeed();
            this.populateList(this.feed);
        }
        int polledMessages = 0;
        while (this.hasNextEntry()) {
            ResumeAdapter adapter;
            E entry = this.list.get(this.entryIndex--);
            ++polledMessages;
            boolean valid = true;
            if (this.resumeStrategy != null && (adapter = this.resumeStrategy.getAdapter()) instanceof EntryFilter) {
                valid = ((EntryFilter)adapter).isValidEntry(entry);
            }
            if (!valid) continue;
            Exchange exchange = this.endpoint.createExchange(this.feed, entry);
            this.getProcessor().process(exchange);
            if (!this.throttleEntries) continue;
            return polledMessages;
        }
        this.feed = null;
        this.resetList();
        return polledMessages;
    }

    public void setResumeStrategy(ResumeStrategy resumeStrategy) {
        this.resumeStrategy = resumeStrategy;
    }

    public ResumeStrategy getResumeStrategy() {
        return this.resumeStrategy;
    }

    public String adapterFactoryService() {
        return "atom-adapter-factory";
    }

    protected abstract void resetList();

    protected abstract void populateList(Object var1) throws Exception;

    private boolean hasNextEntry() {
        return this.entryIndex >= 0;
    }
}

