/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.saga;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.saga.SagaComponent;
import org.apache.camel.component.saga.SagaProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="2.21.0", scheme="saga", title="Saga", syntax="saga:action", producerOnly=true, category={Category.CORE, Category.ENDPOINT})
public class SagaEndpoint
extends DefaultEndpoint {
    @UriPath(description="Action to execute (complete or compensate)")
    @Metadata(required=true)
    private final SagaEndpointAction action;

    public SagaEndpoint(String endpointUri, SagaComponent component, String action) {
        super(endpointUri, (Component)component);
        this.action = SagaEndpointAction.valueOf(((String)ObjectHelper.notNull((Object)action, (String)"action")).toUpperCase());
    }

    public Producer createProducer() throws Exception {
        if (SagaEndpointAction.COMPLETE.equals((Object)this.action)) {
            return new SagaProducer(this, true);
        }
        if (SagaEndpointAction.COMPENSATE.equals((Object)this.action)) {
            return new SagaProducer(this, false);
        }
        throw new IllegalStateException("Unsupported action '" + this.action + "' in saga endpoint");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer not allowed for saga endpoint");
    }

    public static enum SagaEndpointAction {
        COMPLETE,
        COMPENSATE;

    }
}

