/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.datamap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datamap.DataMapMeta;
import org.apache.carbondata.core.datamap.DataMapStoreManager;
import org.apache.carbondata.core.datamap.Segment;
import org.apache.carbondata.core.datamap.TableDataMap;
import org.apache.carbondata.core.datamap.dev.DataMapFactory;
import org.apache.carbondata.core.datamap.dev.DataMapWriter;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.metadata.CarbonTableIdentifier;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.processing.datamap.DataMapWriterException;
import org.apache.carbondata.processing.store.TablePage;

public class DataMapWriterListener {
    private static final LogService LOG = LogServiceFactory.getLogService((String)DataMapWriterListener.class.getCanonicalName());
    private Map<List<CarbonColumn>, List<DataMapWriter>> registry = new ConcurrentHashMap<List<CarbonColumn>, List<DataMapWriter>>();
    private CarbonTableIdentifier tblIdentifier;

    public CarbonTableIdentifier getTblIdentifier() {
        return this.tblIdentifier;
    }

    public void registerAllWriter(CarbonTable carbonTable, String segmentId, String taskNo, SegmentProperties segmentProperties) {
        List tableIndices;
        DataMapStoreManager.getInstance().clearDataMaps(carbonTable.getCarbonTableIdentifier().getTableUniqueName());
        try {
            tableIndices = DataMapStoreManager.getInstance().getAllDataMap(carbonTable);
        }
        catch (IOException e) {
            LOG.error((Throwable)e, "Error while retrieving datamaps");
            throw new RuntimeException(e);
        }
        if (tableIndices != null) {
            this.tblIdentifier = carbonTable.getCarbonTableIdentifier();
            for (TableDataMap tableDataMap : tableIndices) {
                if (tableDataMap.getDataMapSchema().isLazy()) continue;
                DataMapFactory factory = tableDataMap.getDataMapFactory();
                this.register(factory, segmentId, taskNo, segmentProperties);
            }
        }
    }

    private void register(DataMapFactory factory, String segmentId, String taskNo, SegmentProperties segmentProperties) {
        assert (factory != null);
        assert (segmentId != null);
        DataMapMeta meta = factory.getMeta();
        if (meta == null) {
            return;
        }
        List columns = factory.getMeta().getIndexedColumns();
        List<DataMapWriter> writers = this.registry.get(columns);
        DataMapWriter writer = null;
        try {
            writer = factory.createWriter(new Segment(segmentId), taskNo, segmentProperties);
        }
        catch (IOException e) {
            LOG.error("Failed to create DataMapWriter: " + e.getMessage());
            throw new DataMapWriterException(e);
        }
        if (writers != null) {
            writers.add(writer);
        } else {
            writers = new ArrayList<DataMapWriter>();
            writers.add(writer);
            this.registry.put(columns, writers);
        }
        LOG.info("DataMapWriter " + writer + " added");
    }

    public void onBlockStart(String blockId) throws IOException {
        for (List<DataMapWriter> writers : this.registry.values()) {
            for (DataMapWriter writer : writers) {
                writer.onBlockStart(blockId);
            }
        }
    }

    public void onBlockEnd(String blockId) throws IOException {
        for (List<DataMapWriter> writers : this.registry.values()) {
            for (DataMapWriter writer : writers) {
                writer.onBlockEnd(blockId);
            }
        }
    }

    public void onBlockletStart(int blockletId) throws IOException {
        for (List<DataMapWriter> writers : this.registry.values()) {
            for (DataMapWriter writer : writers) {
                writer.onBlockletStart(blockletId);
            }
        }
    }

    public void onBlockletEnd(int blockletId) throws IOException {
        for (List<DataMapWriter> writers : this.registry.values()) {
            for (DataMapWriter writer : writers) {
                writer.onBlockletEnd(blockletId);
            }
        }
    }

    public void onPageAdded(int blockletId, int pageId, TablePage tablePage) throws IOException {
        Set<Map.Entry<List<CarbonColumn>, List<DataMapWriter>>> entries = this.registry.entrySet();
        for (Map.Entry<List<CarbonColumn>, List<DataMapWriter>> entry : entries) {
            List<CarbonColumn> indexedColumns = entry.getKey();
            ColumnPage[] pages = new ColumnPage[indexedColumns.size()];
            for (int i = 0; i < indexedColumns.size(); ++i) {
                pages[i] = tablePage.getColumnPage(indexedColumns.get(i).getColName());
            }
            List<DataMapWriter> writers = entry.getValue();
            int pageSize = pages[0].getPageSize();
            for (DataMapWriter writer : writers) {
                writer.onPageAdded(blockletId, pageId, pageSize, pages);
            }
        }
    }

    public void finish() throws IOException {
        for (List<DataMapWriter> writers : this.registry.values()) {
            for (DataMapWriter writer : writers) {
                writer.finish();
            }
        }
        this.registry.clear();
    }
}

