/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.steps;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.carbondata.common.CarbonIterator;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.processing.loading.AbstractDataLoadProcessorStep;
import org.apache.carbondata.processing.loading.CarbonDataLoadConfiguration;
import org.apache.carbondata.processing.loading.DataField;
import org.apache.carbondata.processing.loading.parser.RowParser;
import org.apache.carbondata.processing.loading.parser.impl.JsonRowParser;
import org.apache.carbondata.processing.loading.row.CarbonRowBatch;
import org.apache.carbondata.processing.loading.steps.InputProcessorStepImpl;
import org.apache.carbondata.processing.util.CarbonDataProcessorUtil;

public class JsonInputProcessorStepImpl
extends AbstractDataLoadProcessorStep {
    private RowParser rowParser;
    private CarbonIterator<Object[]>[] inputIterators;
    private boolean isRawDataRequired = false;
    private short sdkWriterCores;

    public JsonInputProcessorStepImpl(CarbonDataLoadConfiguration configuration, CarbonIterator<Object[]>[] inputIterators) {
        super(configuration, null);
        this.inputIterators = inputIterators;
        this.sdkWriterCores = configuration.getWritingCoresCount();
    }

    @Override
    public DataField[] getOutput() {
        return this.configuration.getDataFields();
    }

    @Override
    public void initialize() throws IOException {
        super.initialize();
        this.rowParser = new JsonRowParser(this.getOutput());
        this.isRawDataRequired = CarbonDataProcessorUtil.isRawDataRequired(this.configuration);
    }

    @Override
    public Iterator<CarbonRowBatch>[] execute() {
        int batchSize = CarbonProperties.getInstance().getBatchSize();
        List<CarbonIterator<Object[]>>[] readerIterators = CarbonDataProcessorUtil.partitionInputReaderIterators(this.inputIterators, this.sdkWriterCores);
        Iterator[] outIterators = new Iterator[readerIterators.length];
        for (int i = 0; i < outIterators.length; ++i) {
            outIterators[i] = new InputProcessorStepImpl.InputProcessorIterator(readerIterators[i], this.rowParser, batchSize, false, null, this.rowCounter, this.isRawDataRequired);
        }
        return outIterators;
    }

    @Override
    public void close() {
        if (!this.closed) {
            super.close();
            for (CarbonIterator<Object[]> inputIterator : this.inputIterators) {
                inputIterator.close();
            }
        }
    }

    @Override
    protected String getStepName() {
        return "Json Input Processor";
    }
}

