/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.steps;

import java.io.IOException;
import java.util.Iterator;
import org.apache.carbondata.processing.loading.AbstractDataLoadProcessorStep;
import org.apache.carbondata.processing.loading.CarbonDataLoadConfiguration;
import org.apache.carbondata.processing.loading.exception.CarbonDataLoadingException;
import org.apache.carbondata.processing.loading.row.CarbonRowBatch;
import org.apache.carbondata.processing.loading.sort.Sorter;
import org.apache.carbondata.processing.loading.sort.SorterFactory;
import org.apache.carbondata.processing.sort.sortdata.SortParameters;

public class SortProcessorStepImpl
extends AbstractDataLoadProcessorStep {
    private Sorter sorter;

    public SortProcessorStepImpl(CarbonDataLoadConfiguration configuration, AbstractDataLoadProcessorStep child) {
        super(configuration, child);
    }

    @Override
    public void initialize() throws IOException {
        super.initialize();
        this.child.initialize();
        SortParameters sortParameters = SortParameters.createSortParameters(this.configuration);
        this.sorter = SorterFactory.createSorter(this.configuration, this.rowCounter);
        this.sorter.initialize(sortParameters);
    }

    @Override
    public Iterator<CarbonRowBatch>[] execute() throws CarbonDataLoadingException {
        Iterator<CarbonRowBatch>[] iterators = this.child.execute();
        return this.sorter.sort(iterators);
    }

    @Override
    public void close() {
        if (!this.closed) {
            super.close();
            if (this.sorter != null) {
                this.sorter.close();
            }
        }
    }

    @Override
    protected String getStepName() {
        return "Sort Processor";
    }
}

