/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.merger;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.datastore.exception.CarbonDataWriterException;
import org.apache.carbondata.core.datastore.row.CarbonRow;
import org.apache.carbondata.core.indexstore.PartitionSpec;
import org.apache.carbondata.core.metadata.SegmentFileStore;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.encoder.Encoding;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.scan.result.iterator.RawResultIterator;
import org.apache.carbondata.core.scan.wrappers.ByteArrayWrapper;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.processing.merger.AbstractResultProcessor;
import org.apache.carbondata.processing.merger.CompactionType;
import org.apache.carbondata.processing.sort.exception.CarbonSortKeyAndGroupByException;
import org.apache.carbondata.processing.sort.sortdata.SingleThreadFinalSortFilesMerger;
import org.apache.carbondata.processing.sort.sortdata.SortDataRows;
import org.apache.carbondata.processing.sort.sortdata.SortIntermediateFileMerger;
import org.apache.carbondata.processing.sort.sortdata.SortParameters;
import org.apache.carbondata.processing.store.CarbonFactDataHandlerModel;
import org.apache.carbondata.processing.store.CarbonFactHandler;
import org.apache.carbondata.processing.store.CarbonFactHandlerFactory;
import org.apache.carbondata.processing.util.CarbonDataProcessorUtil;

public class CompactionResultSortProcessor
extends AbstractResultProcessor {
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)CompactionResultSortProcessor.class.getName());
    private CarbonLoadModel carbonLoadModel;
    private CarbonTable carbonTable;
    private SortDataRows sortDataRows;
    private SingleThreadFinalSortFilesMerger finalMerger;
    private CarbonFactHandler dataHandler;
    private SegmentProperties segmentProperties;
    private CompactionType compactionType;
    private boolean[] noDictionaryColMapping;
    private boolean[] sortColumnMapping;
    private boolean[] isVarcharDimMapping;
    private DataType[] dataTypes;
    private String segmentId;
    private String[] tempStoreLocation;
    private String tableName;
    private int noDictionaryCount;
    private int measureCount;
    private int dimensionColumnCount;
    private boolean isRecordFound;
    private SortIntermediateFileMerger intermediateFileMerger;
    private PartitionSpec partitionSpec;
    private SortParameters sortParameters;

    public CompactionResultSortProcessor(CarbonLoadModel carbonLoadModel, CarbonTable carbonTable, SegmentProperties segmentProperties, CompactionType compactionType, String tableName, PartitionSpec partitionSpec) {
        this.carbonLoadModel = carbonLoadModel;
        this.carbonTable = carbonTable;
        this.segmentProperties = segmentProperties;
        this.segmentId = carbonLoadModel.getSegmentId();
        this.compactionType = compactionType;
        this.tableName = tableName;
        this.partitionSpec = partitionSpec;
    }

    @Override
    public boolean execute(List<RawResultIterator> resultIteratorList) throws Exception {
        boolean isCompactionSuccess = false;
        try {
            this.initTempStoreLocation();
            this.initSortDataRows();
            this.dataTypes = CarbonDataProcessorUtil.initDataType(this.carbonTable, this.tableName, this.measureCount);
            this.processResult(resultIteratorList);
            if (this.isRecordFound) {
                this.initializeFinalThreadMergerForMergeSort();
                this.initDataHandler();
                this.readAndLoadDataFromSortTempFiles();
            }
            isCompactionSuccess = true;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (this.partitionSpec != null) {
                SegmentFileStore.writeSegmentFile((String)this.carbonLoadModel.getTablePath(), (String)this.carbonLoadModel.getTaskNo(), (String)this.partitionSpec.getLocation().toString(), (String)(this.carbonLoadModel.getFactTimeStamp() + ""), (List)this.partitionSpec.getPartitions());
            }
            this.deleteTempStoreLocation();
        }
        return isCompactionSuccess;
    }

    @Override
    public void close() {
        if (null != this.sortDataRows) {
            this.sortDataRows.close();
        }
        if (null != this.finalMerger) {
            this.finalMerger.close();
        }
        if (null != this.dataHandler) {
            this.dataHandler.closeHandler();
        }
    }

    private void deleteTempStoreLocation() {
        if (null != this.tempStoreLocation) {
            for (String tempLoc : this.tempStoreLocation) {
                try {
                    CarbonUtil.deleteFoldersAndFiles((File[])new File[]{new File(tempLoc)});
                }
                catch (IOException | InterruptedException e) {
                    LOGGER.error("Problem deleting local folders during compaction: " + e.getMessage());
                }
            }
        }
    }

    private void processResult(List<RawResultIterator> resultIteratorList) throws Exception {
        for (RawResultIterator resultIterator : resultIteratorList) {
            if (CompactionType.STREAMING == this.compactionType) {
                while (resultIterator.hasNext()) {
                    this.addRowForSorting(this.prepareStreamingRowObjectForSorting(resultIterator.next()));
                    this.isRecordFound = true;
                }
            } else {
                while (resultIterator.hasNext()) {
                    this.addRowForSorting(this.prepareRowObjectForSorting(resultIterator.next()));
                    this.isRecordFound = true;
                }
            }
            resultIterator.close();
        }
        try {
            this.sortDataRows.startSorting();
        }
        catch (CarbonSortKeyAndGroupByException e) {
            LOGGER.error((Throwable)e);
            throw new Exception("Problem loading data during compaction: " + e.getMessage());
        }
    }

    private Object[] prepareStreamingRowObjectForSorting(Object[] row) {
        int i;
        List dimensions = this.segmentProperties.getDimensions();
        Object[] preparedRow = new Object[dimensions.size() + this.measureCount];
        for (i = 0; i < dimensions.size(); ++i) {
            CarbonDimension dims = (CarbonDimension)dimensions.get(i);
            if (dims.hasEncoding(Encoding.DICTIONARY)) {
                preparedRow[i] = row[i];
                continue;
            }
            if (DataTypeUtil.isPrimitiveColumn((DataType)dims.getDataType()) && !dims.isComplex().booleanValue()) {
                preparedRow[i] = DataTypeUtil.getDataBasedOnDataTypeForNoDictionaryColumn((byte[])((byte[])row[i]), (DataType)dims.getDataType());
                if (null == preparedRow[i] || dims.getDataType() != DataTypes.TIMESTAMP) continue;
                preparedRow[i] = (Long)preparedRow[i] / 1000L;
                continue;
            }
            preparedRow[i] = row[i];
        }
        for (i = 0; i < this.measureCount; ++i) {
            preparedRow[this.dimensionColumnCount + i] = row[this.dimensionColumnCount + i];
        }
        return preparedRow;
    }

    private Object[] prepareRowObjectForSorting(Object[] row) {
        ByteArrayWrapper wrapper = (ByteArrayWrapper)row[0];
        List dimensions = this.segmentProperties.getDimensions();
        Object[] preparedRow = new Object[dimensions.size() + this.measureCount];
        byte[] dictionaryKey = wrapper.getDictionaryKey();
        long[] keyArray = this.segmentProperties.getDimensionKeyGenerator().getKeyArray(dictionaryKey);
        Object[] dictionaryValues = new Object[this.dimensionColumnCount + this.measureCount];
        for (int i = 0; i < keyArray.length; ++i) {
            dictionaryValues[i] = Long.valueOf(keyArray[i]).intValue();
        }
        int noDictionaryIndex = 0;
        int dictionaryIndex = 0;
        for (int i = 0; i < dimensions.size(); ++i) {
            CarbonDimension dims = (CarbonDimension)dimensions.get(i);
            if (dims.hasEncoding(Encoding.DICTIONARY)) {
                preparedRow[i] = dictionaryValues[dictionaryIndex++];
                continue;
            }
            byte[] noDictionaryKeyByIndex = wrapper.getNoDictionaryKeyByIndex(noDictionaryIndex++);
            if (DataTypeUtil.isPrimitiveColumn((DataType)dims.getDataType())) {
                preparedRow[i] = DataTypeUtil.getDataBasedOnDataTypeForNoDictionaryColumn((byte[])noDictionaryKeyByIndex, (DataType)dims.getDataType());
                if (null == preparedRow[i] || dims.getDataType() != DataTypes.TIMESTAMP) continue;
                preparedRow[i] = (Long)preparedRow[i] / 1000L;
                continue;
            }
            preparedRow[i] = noDictionaryKeyByIndex;
        }
        int measureIndexInRow = 1;
        for (int i = 0; i < this.measureCount; ++i) {
            preparedRow[this.dimensionColumnCount + i] = this.getConvertedMeasureValue(row[measureIndexInRow++], this.dataTypes[i]);
        }
        return preparedRow;
    }

    private Object getConvertedMeasureValue(Object value, DataType type) {
        if (DataTypes.isDecimal((DataType)type)) {
            if (value != null) {
                value = DataTypeUtil.getDataTypeConverter().convertFromDecimalToBigDecimal(value);
            }
            return value;
        }
        return value;
    }

    private void readAndLoadDataFromSortTempFiles() throws Exception {
        try {
            this.intermediateFileMerger.finish();
            this.finalMerger.startFinalMerge();
            while (this.finalMerger.hasNext()) {
                Object[] row = this.finalMerger.next();
                this.dataHandler.addDataToStore(new CarbonRow(row));
            }
            this.dataHandler.finish();
        }
        catch (CarbonDataWriterException e) {
            LOGGER.error((Throwable)e);
            throw new Exception("Problem loading data during compaction.", e);
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            throw new Exception("Problem loading data during compaction.", e);
        }
        finally {
            if (null != this.dataHandler) {
                try {
                    this.dataHandler.closeHandler();
                }
                catch (CarbonDataWriterException e) {
                    LOGGER.error((Throwable)e, "Error in close data handler");
                    throw new Exception("Error in close data handler", e);
                }
            }
        }
    }

    private void addRowForSorting(Object[] row) throws Exception {
        try {
            this.sortDataRows.addRow(row);
        }
        catch (CarbonSortKeyAndGroupByException e) {
            LOGGER.error((Throwable)e);
            throw new Exception("Row addition for sorting failed during compaction: " + e.getMessage());
        }
    }

    private void initSortDataRows() throws Exception {
        this.measureCount = this.carbonTable.getMeasureByTableName(this.tableName).size();
        List dimensions = this.carbonTable.getDimensionByTableName(this.tableName);
        this.noDictionaryColMapping = new boolean[dimensions.size()];
        this.sortColumnMapping = new boolean[dimensions.size()];
        this.isVarcharDimMapping = new boolean[dimensions.size()];
        int i = 0;
        for (CarbonDimension dimension : dimensions) {
            if (CarbonUtil.hasEncoding((List)dimension.getEncoder(), (Encoding)Encoding.DICTIONARY)) {
                ++i;
                continue;
            }
            if (dimension.isSortColumn()) {
                this.sortColumnMapping[i] = true;
            }
            this.noDictionaryColMapping[i] = true;
            if (dimension.getColumnSchema().getDataType() == DataTypes.VARCHAR) {
                this.isVarcharDimMapping[i] = true;
            }
            ++i;
            ++this.noDictionaryCount;
        }
        this.dimensionColumnCount = dimensions.size();
        this.sortParameters = this.createSortParameters();
        this.intermediateFileMerger = new SortIntermediateFileMerger(this.sortParameters);
        this.sortDataRows = new SortDataRows(this.sortParameters, this.intermediateFileMerger);
        try {
            this.sortDataRows.initialize();
        }
        catch (CarbonSortKeyAndGroupByException e) {
            LOGGER.error((Throwable)e);
            throw new Exception("Error initializing sort data rows object during compaction: " + e.getMessage());
        }
    }

    private SortParameters createSortParameters() {
        return SortParameters.createSortParameters(this.carbonTable, this.carbonLoadModel.getDatabaseName(), this.tableName, this.dimensionColumnCount, this.segmentProperties.getComplexDimensions().size(), this.measureCount, this.noDictionaryCount, this.segmentId, this.carbonLoadModel.getTaskNo(), this.noDictionaryColMapping, this.sortColumnMapping, this.isVarcharDimMapping, true);
    }

    private void initializeFinalThreadMergerForMergeSort() {
        boolean[] noDictionarySortColumnMapping = CarbonDataProcessorUtil.getNoDictSortColMapping(this.carbonTable.getDatabaseName(), this.carbonTable.getTableName());
        this.sortParameters.setNoDictionarySortColumn(noDictionarySortColumnMapping);
        String[] sortTempFileLocation = CarbonDataProcessorUtil.arrayAppend(this.tempStoreLocation, "/", "sortrowtmp");
        this.finalMerger = new SingleThreadFinalSortFilesMerger(sortTempFileLocation, this.tableName, this.sortParameters);
    }

    private void initDataHandler() throws Exception {
        String carbonStoreLocation = this.partitionSpec != null ? this.partitionSpec.getLocation().toString() + "/" + this.carbonLoadModel.getFactTimeStamp() + ".tmp" : CarbonDataProcessorUtil.createCarbonStoreLocation(this.carbonLoadModel.getDatabaseName(), this.tableName, this.carbonLoadModel.getSegmentId());
        CarbonFactDataHandlerModel carbonFactDataHandlerModel = CarbonFactDataHandlerModel.getCarbonFactDataHandlerModel(this.carbonLoadModel, this.carbonTable, this.segmentProperties, this.tableName, this.tempStoreLocation, carbonStoreLocation);
        carbonFactDataHandlerModel.setSegmentId(this.carbonLoadModel.getSegmentId());
        this.setDataFileAttributesInModel(this.carbonLoadModel, this.compactionType, carbonFactDataHandlerModel);
        this.dataHandler = CarbonFactHandlerFactory.createCarbonFactHandler(carbonFactDataHandlerModel);
        try {
            this.dataHandler.initialise();
        }
        catch (CarbonDataWriterException e) {
            LOGGER.error((Throwable)e);
            throw new Exception("Problem initialising data handler during compaction: " + e.getMessage());
        }
    }

    private void initTempStoreLocation() {
        this.tempStoreLocation = CarbonDataProcessorUtil.getLocalDataFolderLocation(this.carbonTable, this.carbonLoadModel.getTaskNo(), this.segmentId, true, false);
    }
}

