/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.merger;

import java.util.Comparator;
import java.util.List;
import org.apache.carbondata.core.datastore.block.Distributable;
import org.apache.carbondata.core.datastore.block.TableBlockInfo;

public class NodeMultiBlockRelation
implements Comparable<NodeMultiBlockRelation> {
    private final List<Distributable> blocks;
    private final String node;
    public static final Comparator<NodeMultiBlockRelation> DATA_SIZE_DESC_COMPARATOR = new Comparator<NodeMultiBlockRelation>(){

        @Override
        public int compare(NodeMultiBlockRelation o1, NodeMultiBlockRelation o2) {
            long diff = o1.getTotalSizeOfBlocks() - o2.getTotalSizeOfBlocks();
            return diff > 0L ? -1 : (diff < 0L ? 1 : 0);
        }
    };
    public static final Comparator<NodeMultiBlockRelation> DATA_SIZE_ASC_COMPARATOR = new Comparator<NodeMultiBlockRelation>(){

        @Override
        public int compare(NodeMultiBlockRelation o1, NodeMultiBlockRelation o2) {
            long diff = o1.getTotalSizeOfBlocks() - o2.getTotalSizeOfBlocks();
            return diff > 0L ? 1 : (diff < 0L ? -1 : 0);
        }
    };

    public NodeMultiBlockRelation(String node, List<Distributable> blocks) {
        this.node = node;
        this.blocks = blocks;
    }

    public List<Distributable> getBlocks() {
        return this.blocks;
    }

    public String getNode() {
        return this.node;
    }

    public long getTotalSizeOfBlocks() {
        long totalSize = 0L;
        if (this.blocks.get(0) instanceof TableBlockInfo) {
            for (Distributable block : this.blocks) {
                totalSize += ((TableBlockInfo)block).getBlockLength();
            }
        }
        return totalSize;
    }

    @Override
    public int compareTo(NodeMultiBlockRelation obj) {
        return this.blocks.size() - obj.getBlocks().size();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NodeMultiBlockRelation)) {
            return false;
        }
        NodeMultiBlockRelation o = (NodeMultiBlockRelation)obj;
        return this.blocks.equals(o.blocks) && this.node.equals(o.node);
    }

    public int hashCode() {
        return this.blocks.hashCode() + this.node.hashCode();
    }
}

