/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.partition.spliter;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.common.CarbonIterator;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.cache.dictionary.Dictionary;
import org.apache.carbondata.core.datastore.block.TableBlockInfo;
import org.apache.carbondata.core.datastore.block.TaskBlockInfo;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.scan.executor.QueryExecutor;
import org.apache.carbondata.core.scan.executor.QueryExecutorFactory;
import org.apache.carbondata.core.scan.executor.exception.QueryExecutionException;
import org.apache.carbondata.core.scan.model.QueryModel;
import org.apache.carbondata.core.scan.result.RowBatch;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.hadoop.conf.Configuration;

public abstract class AbstractCarbonQueryExecutor {
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)AbstractCarbonQueryExecutor.class.getName());
    protected CarbonTable carbonTable;
    protected QueryModel queryModel;
    private QueryExecutor queryExecutor;
    Map<String, TaskBlockInfo> segmentMapping;

    CarbonIterator<RowBatch> executeBlockList(List<TableBlockInfo> blockList, Configuration configuration) throws QueryExecutionException, IOException {
        this.queryModel.setTableBlockInfos(blockList);
        this.queryExecutor = QueryExecutorFactory.getQueryExecutor((QueryModel)this.queryModel, (Configuration)configuration);
        return this.queryExecutor.execute(this.queryModel);
    }

    public void finish() {
        try {
            this.queryExecutor.finish();
        }
        catch (QueryExecutionException e) {
            LOGGER.error((Throwable)e, "Problem while finish: ");
        }
        this.clearDictionaryFromQueryModel();
    }

    private void clearDictionaryFromQueryModel() {
        Map columnToDictionaryMapping;
        if (null != this.queryModel && null != (columnToDictionaryMapping = this.queryModel.getColumnToDictionaryMapping())) {
            for (Map.Entry entry : columnToDictionaryMapping.entrySet()) {
                CarbonUtil.clearDictionaryCache((Dictionary)((Dictionary)entry.getValue()));
            }
        }
    }
}

