/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.sort.sortdata;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonThreadFactory;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.ReUsableByteArrayDataOutputStream;
import org.apache.carbondata.processing.loading.sort.SortStepRowHandler;
import org.apache.carbondata.processing.sort.exception.CarbonSortKeyAndGroupByException;
import org.apache.carbondata.processing.sort.sortdata.NewRowComparator;
import org.apache.carbondata.processing.sort.sortdata.NewRowComparatorForNormalDims;
import org.apache.carbondata.processing.sort.sortdata.SortIntermediateFileMerger;
import org.apache.carbondata.processing.sort.sortdata.SortParameters;
import org.apache.carbondata.processing.util.CarbonDataProcessorUtil;

public class SortDataRows {
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)SortDataRows.class.getName());
    private int entryCount;
    private Object[][] recordHolderList;
    private ThreadStatusObserver threadStatusObserver;
    private ExecutorService dataSorterAndWriterExecutorService;
    private Semaphore semaphore;
    private SortParameters parameters;
    private SortStepRowHandler sortStepRowHandler;
    private ThreadLocal<ReUsableByteArrayDataOutputStream> reUsableByteArrayDataOutputStream;
    private int sortBufferSize;
    private SortIntermediateFileMerger intermediateFileMerger;
    private final Object addRowsLock = new Object();

    public SortDataRows(SortParameters parameters, SortIntermediateFileMerger intermediateFileMerger) {
        this.parameters = parameters;
        this.sortStepRowHandler = new SortStepRowHandler(parameters);
        this.intermediateFileMerger = intermediateFileMerger;
        int batchSize = CarbonProperties.getInstance().getBatchSize();
        this.sortBufferSize = Math.max(parameters.getSortBufferSize(), batchSize);
        this.threadStatusObserver = new ThreadStatusObserver();
        this.reUsableByteArrayDataOutputStream = new ThreadLocal<ReUsableByteArrayDataOutputStream>(){

            @Override
            protected ReUsableByteArrayDataOutputStream initialValue() {
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                return new ReUsableByteArrayDataOutputStream(byteStream);
            }
        };
    }

    public void initialize() throws CarbonSortKeyAndGroupByException {
        this.recordHolderList = new Object[this.sortBufferSize][];
        this.deleteSortLocationIfExists();
        CarbonDataProcessorUtil.createLocations(this.parameters.getTempFileLocation());
        this.dataSorterAndWriterExecutorService = Executors.newFixedThreadPool(this.parameters.getNumberOfCores(), (ThreadFactory)new CarbonThreadFactory("SortDataRowPool:" + this.parameters.getTableName()));
        this.semaphore = new Semaphore(this.parameters.getNumberOfCores());
    }

    public void addRow(Object[] row) throws CarbonSortKeyAndGroupByException {
        int currentSize = this.entryCount;
        if (this.sortBufferSize == currentSize) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("************ Writing to temp file ********** ");
            }
            this.intermediateFileMerger.startMergingIfPossible();
            Object[][] recordHolderListLocal = this.recordHolderList;
            try {
                this.semaphore.acquire();
                this.dataSorterAndWriterExecutorService.execute(new DataSorterAndWriter(recordHolderListLocal));
            }
            catch (InterruptedException e) {
                LOGGER.error((Throwable)e, "exception occurred while trying to acquire a semaphore lock: ");
                throw new CarbonSortKeyAndGroupByException(e);
            }
            this.recordHolderList = new Object[this.sortBufferSize][];
            this.entryCount = 0;
        }
        this.recordHolderList[this.entryCount++] = row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRowBatch(Object[][] rowBatch, int size) throws CarbonSortKeyAndGroupByException {
        Object object = this.addRowsLock;
        synchronized (object) {
            int sizeLeft = 0;
            if (this.entryCount + size >= this.sortBufferSize) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("************ Writing to temp file ********** ");
                }
                this.intermediateFileMerger.startMergingIfPossible();
                Object[][] recordHolderListLocal = this.recordHolderList;
                sizeLeft = this.sortBufferSize - this.entryCount;
                if (sizeLeft > 0) {
                    System.arraycopy(rowBatch, 0, recordHolderListLocal, this.entryCount, sizeLeft);
                }
                try {
                    this.semaphore.acquire();
                    this.dataSorterAndWriterExecutorService.execute(new DataSorterAndWriter(recordHolderListLocal));
                }
                catch (Exception e) {
                    LOGGER.error("exception occurred while trying to acquire a semaphore lock: " + e.getMessage());
                    throw new CarbonSortKeyAndGroupByException(e);
                }
                this.recordHolderList = new Object[this.sortBufferSize][];
                this.entryCount = 0;
                if ((size -= sizeLeft) == 0) {
                    return;
                }
            }
            System.arraycopy(rowBatch, sizeLeft, this.recordHolderList, this.entryCount, size);
            this.entryCount += size;
        }
    }

    public void startSorting() throws CarbonSortKeyAndGroupByException {
        LOGGER.info("File based sorting will be used");
        if (this.entryCount > 0) {
            Object[][] toSort = new Object[this.entryCount][];
            System.arraycopy(this.recordHolderList, 0, toSort, 0, this.entryCount);
            if (this.parameters.getNumberOfNoDictSortColumns() > 0) {
                Arrays.sort(toSort, new NewRowComparator(this.parameters.getNoDictionarySortColumn(), this.parameters.getNoDictDataType()));
            } else {
                Arrays.sort(toSort, new NewRowComparatorForNormalDims(this.parameters.getNumberOfSortColumns()));
            }
            this.recordHolderList = toSort;
            String[] tmpLocation = this.parameters.getTempFileLocation();
            String locationChosen = tmpLocation[new Random().nextInt(tmpLocation.length)];
            File file = new File(locationChosen + File.separator + this.parameters.getTableName() + '_' + this.parameters.getRangeId() + '_' + System.nanoTime() + ".sorttemp");
            this.writeDataToFile(this.recordHolderList, this.entryCount, file);
        }
        this.startFileBasedMerge();
        this.recordHolderList = null;
    }

    private void writeDataToFile(Object[][] recordHolderList, int entryCountLocal, File file) throws CarbonSortKeyAndGroupByException {
        DataOutputStream stream = null;
        try {
            stream = FileFactory.getDataOutputStream((String)file.getPath(), (FileFactory.FileType)FileFactory.FileType.LOCAL, (int)this.parameters.getFileWriteBufferSize(), (String)this.parameters.getSortTempCompressorName());
            stream.writeInt(entryCountLocal);
            for (int i = 0; i < entryCountLocal; ++i) {
                this.sortStepRowHandler.writeRawRowAsIntermediateSortTempRowToOutputStream(recordHolderList[i], stream, this.reUsableByteArrayDataOutputStream.get());
            }
        }
        catch (IOException e) {
            try {
                throw new CarbonSortKeyAndGroupByException("Problem while writing the file", e);
            }
            catch (Throwable throwable) {
                CarbonUtil.closeStreams((Closeable[])new Closeable[]{stream});
                throw throwable;
            }
        }
        CarbonUtil.closeStreams((Closeable[])new Closeable[]{stream});
    }

    private void deleteSortLocationIfExists() throws CarbonSortKeyAndGroupByException {
        CarbonDataProcessorUtil.deleteSortLocationIfExists(this.parameters.getTempFileLocation());
    }

    private void startFileBasedMerge() throws CarbonSortKeyAndGroupByException {
        try {
            this.dataSorterAndWriterExecutorService.shutdown();
            this.dataSorterAndWriterExecutorService.awaitTermination(2L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            throw new CarbonSortKeyAndGroupByException("Problem while shutdown the server ", e);
        }
    }

    public void close() {
        if (null != this.dataSorterAndWriterExecutorService && !this.dataSorterAndWriterExecutorService.isShutdown()) {
            this.dataSorterAndWriterExecutorService.shutdownNow();
        }
        this.intermediateFileMerger.close();
    }

    private class DataSorterAndWriter
    implements Runnable {
        private Object[][] recordHolderArray;

        public DataSorterAndWriter(Object[][] recordHolderArray) {
            this.recordHolderArray = recordHolderArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long startTime = System.currentTimeMillis();
                if (SortDataRows.this.parameters.getNumberOfNoDictSortColumns() > 0) {
                    Arrays.sort(this.recordHolderArray, new NewRowComparator(SortDataRows.this.parameters.getNoDictionarySortColumn(), SortDataRows.this.parameters.getNoDictDataType()));
                } else {
                    Arrays.sort(this.recordHolderArray, new NewRowComparatorForNormalDims(SortDataRows.this.parameters.getNumberOfSortColumns()));
                }
                String[] tmpFileLocation = SortDataRows.this.parameters.getTempFileLocation();
                String locationChosen = tmpFileLocation[new Random().nextInt(tmpFileLocation.length)];
                File sortTempFile = new File(locationChosen + File.separator + SortDataRows.this.parameters.getTableName() + '_' + SortDataRows.this.parameters.getRangeId() + '_' + System.nanoTime() + ".sorttemp");
                SortDataRows.this.writeDataToFile(this.recordHolderArray, this.recordHolderArray.length, sortTempFile);
                SortDataRows.this.intermediateFileMerger.addFileToMerge(sortTempFile);
                LOGGER.info("Time taken to sort and write sort temp file " + sortTempFile + " is: " + (System.currentTimeMillis() - startTime) + ", sort temp file size in MB is " + (double)sortTempFile.length() * 0.1 * 10.0 / 1024.0 / 1024.0);
            }
            catch (Throwable e) {
                try {
                    SortDataRows.this.threadStatusObserver.notifyFailed(e);
                }
                catch (CarbonSortKeyAndGroupByException ex) {
                    LOGGER.error((Throwable)ex);
                }
            }
            finally {
                SortDataRows.this.semaphore.release();
            }
        }
    }

    private class ThreadStatusObserver {
        private ThreadStatusObserver() {
        }

        public void notifyFailed(Throwable exception) throws CarbonSortKeyAndGroupByException {
            SortDataRows.this.close();
            SortDataRows.this.parameters.getObserver().setFailed(true);
            LOGGER.error(exception);
            throw new CarbonSortKeyAndGroupByException(exception);
        }
    }
}

