/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.sort.sortdata;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.metadata.CarbonTableIdentifier;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.processing.loading.CarbonDataLoadConfiguration;
import org.apache.carbondata.processing.sort.sortdata.SortObserver;
import org.apache.carbondata.processing.util.CarbonDataProcessorUtil;
import org.apache.commons.lang3.StringUtils;

public class SortParameters
implements Serializable {
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)SortParameters.class.getName());
    private String[] tempFileLocation;
    private int sortBufferSize;
    private int measureColCount;
    private int dimColCount;
    private int complexDimColCount;
    private int fileBufferSize;
    private int numberOfIntermediateFileToBeMerged;
    private int fileWriteBufferSize;
    private SortObserver observer;
    private String sortTempCompressorName;
    private boolean prefetch;
    private int bufferSize;
    private String databaseName;
    private String tableName;
    private DataType[] measureDataType;
    private DataType[] noDictDataType;
    private DataType[] noDictSortDataType;
    private DataType[] noDictNoSortDataType;
    private int noDictionaryCount;
    private String partitionID;
    private String segmentId;
    private String taskNo;
    private boolean[] noDictionaryDimnesionColumn;
    private boolean[] noDictionarySortColumn;
    private boolean[] sortColumn;
    private boolean[] isVarcharDimensionColumn;
    private int numberOfSortColumns;
    private int numberOfNoDictSortColumns;
    private int numberOfCores;
    private int batchSortSizeinMb;
    private int rangeId = 0;

    public SortParameters getCopy() {
        SortParameters parameters = new SortParameters();
        parameters.tempFileLocation = this.tempFileLocation;
        parameters.sortBufferSize = this.sortBufferSize;
        parameters.measureColCount = this.measureColCount;
        parameters.dimColCount = this.dimColCount;
        parameters.complexDimColCount = this.complexDimColCount;
        parameters.fileBufferSize = this.fileBufferSize;
        parameters.numberOfIntermediateFileToBeMerged = this.numberOfIntermediateFileToBeMerged;
        parameters.fileWriteBufferSize = this.fileWriteBufferSize;
        parameters.observer = this.observer;
        parameters.sortTempCompressorName = this.sortTempCompressorName;
        parameters.prefetch = this.prefetch;
        parameters.bufferSize = this.bufferSize;
        parameters.databaseName = this.databaseName;
        parameters.tableName = this.tableName;
        parameters.measureDataType = this.measureDataType;
        parameters.noDictDataType = this.noDictDataType;
        parameters.noDictSortDataType = this.noDictSortDataType;
        parameters.noDictNoSortDataType = this.noDictNoSortDataType;
        parameters.noDictionaryCount = this.noDictionaryCount;
        parameters.partitionID = this.partitionID;
        parameters.segmentId = this.segmentId;
        parameters.taskNo = this.taskNo;
        parameters.noDictionaryDimnesionColumn = this.noDictionaryDimnesionColumn;
        parameters.sortColumn = this.sortColumn;
        parameters.isVarcharDimensionColumn = this.isVarcharDimensionColumn;
        parameters.noDictionarySortColumn = this.noDictionarySortColumn;
        parameters.numberOfSortColumns = this.numberOfSortColumns;
        parameters.numberOfNoDictSortColumns = this.numberOfNoDictSortColumns;
        parameters.numberOfCores = this.numberOfCores;
        parameters.batchSortSizeinMb = this.batchSortSizeinMb;
        parameters.rangeId = this.rangeId;
        return parameters;
    }

    public String[] getTempFileLocation() {
        return this.tempFileLocation;
    }

    public void setTempFileLocation(String[] tempFileLocation) {
        this.tempFileLocation = tempFileLocation;
    }

    public int getSortBufferSize() {
        return this.sortBufferSize;
    }

    public void setSortBufferSize(int sortBufferSize) {
        this.sortBufferSize = sortBufferSize;
    }

    public int getMeasureColCount() {
        return this.measureColCount;
    }

    public void setMeasureColCount(int measureColCount) {
        this.measureColCount = measureColCount;
    }

    public int getDimColCount() {
        return this.dimColCount;
    }

    public void setDimColCount(int dimColCount) {
        this.dimColCount = dimColCount;
    }

    public int getComplexDimColCount() {
        return this.complexDimColCount;
    }

    public void setComplexDimColCount(int complexDimColCount) {
        this.complexDimColCount = complexDimColCount;
    }

    public int getNumberOfIntermediateFileToBeMerged() {
        return this.numberOfIntermediateFileToBeMerged;
    }

    public void setNumberOfIntermediateFileToBeMerged(int numberOfIntermediateFileToBeMerged) {
        this.numberOfIntermediateFileToBeMerged = numberOfIntermediateFileToBeMerged;
    }

    public int getFileWriteBufferSize() {
        return this.fileWriteBufferSize;
    }

    public void setFileWriteBufferSize(int fileWriteBufferSize) {
        this.fileWriteBufferSize = fileWriteBufferSize;
    }

    public SortObserver getObserver() {
        return this.observer;
    }

    public void setObserver(SortObserver observer) {
        this.observer = observer;
    }

    public String getSortTempCompressorName() {
        return this.sortTempCompressorName;
    }

    public void setSortTempCompressorName(String sortTempCompressorName) {
        this.sortTempCompressorName = sortTempCompressorName;
    }

    public boolean isPrefetch() {
        return this.prefetch;
    }

    public void setPrefetch(boolean prefetch) {
        this.prefetch = prefetch;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public DataType[] getMeasureDataType() {
        return this.measureDataType;
    }

    public void setMeasureDataType(DataType[] measureDataType) {
        this.measureDataType = measureDataType;
    }

    public int getNoDictionaryCount() {
        return this.noDictionaryCount;
    }

    public void setNoDictionaryCount(int noDictionaryCount) {
        this.noDictionaryCount = noDictionaryCount;
    }

    public String getPartitionID() {
        return this.partitionID;
    }

    public void setPartitionID(String partitionID) {
        this.partitionID = partitionID;
    }

    public String getSegmentId() {
        return this.segmentId;
    }

    public void setSegmentId(String segmentId) {
        this.segmentId = segmentId;
    }

    public String getTaskNo() {
        return this.taskNo;
    }

    public void setTaskNo(String taskNo) {
        this.taskNo = taskNo;
    }

    public boolean[] getNoDictionaryDimnesionColumn() {
        return this.noDictionaryDimnesionColumn;
    }

    public void setNoDictionaryDimnesionColumn(boolean[] noDictionaryDimnesionColumn) {
        this.noDictionaryDimnesionColumn = noDictionaryDimnesionColumn;
    }

    public boolean[] getIsVarcharDimensionColumn() {
        return this.isVarcharDimensionColumn;
    }

    public void setIsVarcharDimensionColumn(boolean[] isVarcharDimensionColumn) {
        this.isVarcharDimensionColumn = isVarcharDimensionColumn;
    }

    public int getNumberOfCores() {
        return this.numberOfCores;
    }

    public void setNumberOfCores(int numberOfCores) {
        this.numberOfCores = numberOfCores;
    }

    public int getNumberOfSortColumns() {
        return this.numberOfSortColumns;
    }

    public void setNumberOfSortColumns(int numberOfSortColumns) {
        this.numberOfSortColumns = Math.min(numberOfSortColumns, this.dimColCount);
    }

    public boolean[] getNoDictionarySortColumn() {
        return this.noDictionarySortColumn;
    }

    public void setNoDictionarySortColumn(boolean[] noDictionarySortColumn) {
        this.noDictionarySortColumn = noDictionarySortColumn;
    }

    public int getNumberOfNoDictSortColumns() {
        return this.numberOfNoDictSortColumns;
    }

    public void setNumberOfNoDictSortColumns(int numberOfNoDictSortColumns) {
        this.numberOfNoDictSortColumns = Math.min(numberOfNoDictSortColumns, this.noDictionaryCount);
    }

    public int getBatchSortSizeinMb() {
        return this.batchSortSizeinMb;
    }

    public void setBatchSortSizeinMb(int batchSortSizeinMb) {
        this.batchSortSizeinMb = batchSortSizeinMb;
    }

    public static SortParameters createSortParameters(CarbonDataLoadConfiguration configuration) {
        SortParameters parameters = new SortParameters();
        CarbonTableIdentifier tableIdentifier = configuration.getTableIdentifier().getCarbonTableIdentifier();
        CarbonProperties carbonProperties = CarbonProperties.getInstance();
        parameters.setDatabaseName(tableIdentifier.getDatabaseName());
        parameters.setTableName(tableIdentifier.getTableName());
        parameters.setPartitionID("0");
        parameters.setSegmentId(configuration.getSegmentId());
        parameters.setTaskNo(configuration.getTaskNo());
        parameters.setMeasureColCount(configuration.getMeasureCount());
        parameters.setDimColCount(configuration.getDimensionCount() - (configuration.getComplexDictionaryColumnCount() + configuration.getComplexNonDictionaryColumnCount()));
        parameters.setNoDictionaryCount(configuration.getNoDictionaryCount());
        parameters.setComplexDimColCount(configuration.getComplexDictionaryColumnCount() + configuration.getComplexNonDictionaryColumnCount());
        parameters.setNoDictionaryDimnesionColumn(CarbonDataProcessorUtil.getNoDictionaryMapping(configuration.getDataFields()));
        parameters.setIsVarcharDimensionColumn(CarbonDataProcessorUtil.getIsVarcharColumnMapping(configuration.getDataFields()));
        parameters.setBatchSortSizeinMb(CarbonDataProcessorUtil.getBatchSortSizeinMb(configuration));
        parameters.setNumberOfSortColumns(configuration.getNumberOfSortColumns());
        parameters.setNumberOfNoDictSortColumns(configuration.getNumberOfNoDictSortColumns());
        parameters.setNoDictionarySortColumn(CarbonDataProcessorUtil.getNoDictSortColMapping(configuration.getTableIdentifier().getDatabaseName(), configuration.getTableIdentifier().getTableName()));
        parameters.setSortColumn(configuration.getSortColumnMapping());
        parameters.setObserver(new SortObserver());
        parameters.setSortBufferSize(Integer.parseInt(carbonProperties.getProperty("carbon.sort.size", "100000")));
        LOGGER.info("Sort size for table: " + parameters.getSortBufferSize());
        parameters.setNumberOfIntermediateFileToBeMerged(Integer.parseInt(carbonProperties.getProperty("carbon.sort.intermediate.files.limit", "20")));
        LOGGER.info("Number of intermediate file to be merged: " + parameters.getNumberOfIntermediateFileToBeMerged());
        String[] carbonDataDirectoryPath = CarbonDataProcessorUtil.getLocalDataFolderLocation(tableIdentifier.getDatabaseName(), tableIdentifier.getTableName(), configuration.getTaskNo(), configuration.getSegmentId(), false, false);
        String[] sortTempDirs = CarbonDataProcessorUtil.arrayAppend(carbonDataDirectoryPath, File.separator, "sortrowtmp");
        parameters.setTempFileLocation(sortTempDirs);
        LOGGER.info("temp file location: " + StringUtils.join((Object[])parameters.getTempFileLocation(), (String)","));
        int numberOfCores = carbonProperties.getNumberOfCores() / 2;
        if (configuration.getWritingCoresCount() > 0) {
            numberOfCores = configuration.getWritingCoresCount();
        }
        parameters.setNumberOfCores(numberOfCores > 0 ? numberOfCores : 1);
        parameters.setFileWriteBufferSize(Integer.parseInt(carbonProperties.getProperty("carbon.sort.file.write.buffer.size", "16384")));
        parameters.setSortTempCompressorName(CarbonProperties.getInstance().getSortTempCompressor());
        if (!parameters.sortTempCompressorName.isEmpty()) {
            LOGGER.info(" Compression " + parameters.sortTempCompressorName + " will be used for writing the sort temp File");
        }
        parameters.setPrefetch(false);
        parameters.setBufferSize(Integer.parseInt(carbonProperties.getProperty("carbon.prefetch.buffersize", "1000")));
        DataType[] measureDataType = configuration.getMeasureDataType();
        parameters.setMeasureDataType(measureDataType);
        parameters.setNoDictDataType(CarbonDataProcessorUtil.getNoDictDataTypes(configuration.getTableIdentifier().getDatabaseName(), configuration.getTableIdentifier().getTableName()));
        Map<String, DataType[]> noDictSortAndNoSortDataTypes = CarbonDataProcessorUtil.getNoDictSortAndNoSortDataTypes(configuration.getTableIdentifier().getDatabaseName(), configuration.getTableIdentifier().getTableName());
        parameters.setNoDictSortDataType(noDictSortAndNoSortDataTypes.get("noDictSortDataTypes"));
        parameters.setNoDictNoSortDataType(noDictSortAndNoSortDataTypes.get("noDictNoSortDataTypes"));
        return parameters;
    }

    public int getRangeId() {
        return this.rangeId;
    }

    public void setRangeId(int rangeId) {
        this.rangeId = rangeId;
    }

    public static SortParameters createSortParameters(CarbonTable carbonTable, String databaseName, String tableName, int dimColCount, int complexDimColCount, int measureColCount, int noDictionaryCount, String segmentId, String taskNo, boolean[] noDictionaryColMaping, boolean[] sortColumnMapping, boolean[] isVarcharDimensionColumn, boolean isCompactionFlow) {
        SortParameters parameters = new SortParameters();
        CarbonProperties carbonProperties = CarbonProperties.getInstance();
        parameters.setDatabaseName(databaseName);
        parameters.setTableName(tableName);
        parameters.setPartitionID("0");
        parameters.setSegmentId(segmentId);
        parameters.setTaskNo(taskNo);
        parameters.setMeasureColCount(measureColCount);
        parameters.setDimColCount(dimColCount - complexDimColCount);
        parameters.setNumberOfSortColumns(carbonTable.getNumberOfSortColumns());
        parameters.setNoDictionaryCount(noDictionaryCount);
        parameters.setNumberOfNoDictSortColumns(carbonTable.getNumberOfNoDictSortColumns());
        parameters.setComplexDimColCount(complexDimColCount);
        parameters.setNoDictionaryDimnesionColumn(noDictionaryColMaping);
        parameters.setSortColumn(sortColumnMapping);
        parameters.setIsVarcharDimensionColumn(isVarcharDimensionColumn);
        parameters.setObserver(new SortObserver());
        parameters.setSortBufferSize(Integer.parseInt(carbonProperties.getProperty("carbon.sort.size", "100000")));
        LOGGER.info("Sort size for table: " + parameters.getSortBufferSize());
        parameters.setNumberOfIntermediateFileToBeMerged(Integer.parseInt(carbonProperties.getProperty("carbon.sort.intermediate.files.limit", "20")));
        LOGGER.info("Number of intermediate file to be merged: " + parameters.getNumberOfIntermediateFileToBeMerged());
        String[] carbonDataDirectoryPath = CarbonDataProcessorUtil.getLocalDataFolderLocation(databaseName, tableName, taskNo, segmentId, isCompactionFlow, false);
        String[] sortTempDirs = CarbonDataProcessorUtil.arrayAppend(carbonDataDirectoryPath, File.separator, "sortrowtmp");
        parameters.setTempFileLocation(sortTempDirs);
        LOGGER.info("temp file location: " + StringUtils.join((Object[])parameters.getTempFileLocation(), (String)","));
        int numberOfCores = carbonProperties.getNumberOfCores() / 2;
        parameters.setNumberOfCores(numberOfCores > 0 ? numberOfCores : 1);
        parameters.setFileWriteBufferSize(Integer.parseInt(carbonProperties.getProperty("carbon.sort.file.write.buffer.size", "16384")));
        parameters.setSortTempCompressorName(CarbonProperties.getInstance().getSortTempCompressor());
        if (!parameters.sortTempCompressorName.isEmpty()) {
            LOGGER.info(" Compression " + parameters.sortTempCompressorName + " will be used for writing the sort temp File");
        }
        parameters.setPrefetch(false);
        parameters.setBufferSize(Integer.parseInt(carbonProperties.getProperty("carbon.prefetch.buffersize", "1000")));
        DataType[] type = CarbonDataProcessorUtil.getMeasureDataType(parameters.getMeasureColCount(), parameters.getDatabaseName(), parameters.getTableName());
        parameters.setMeasureDataType(type);
        parameters.setNoDictDataType(CarbonDataProcessorUtil.getNoDictDataTypes(parameters.getDatabaseName(), parameters.getTableName()));
        Map<String, DataType[]> noDictSortAndNoSortDataTypes = CarbonDataProcessorUtil.getNoDictSortAndNoSortDataTypes(parameters.getDatabaseName(), parameters.getTableName());
        parameters.setNoDictSortDataType(noDictSortAndNoSortDataTypes.get("noDictSortDataTypes"));
        parameters.setNoDictNoSortDataType(noDictSortAndNoSortDataTypes.get("noDictNoSortDataTypes"));
        parameters.setNoDictionarySortColumn(CarbonDataProcessorUtil.getNoDictSortColMapping(parameters.getDatabaseName(), parameters.getTableName()));
        return parameters;
    }

    public DataType[] getNoDictSortDataType() {
        return this.noDictSortDataType;
    }

    public void setNoDictSortDataType(DataType[] noDictSortDataType) {
        this.noDictSortDataType = noDictSortDataType;
    }

    public DataType[] getNoDictNoSortDataType() {
        return this.noDictNoSortDataType;
    }

    public DataType[] getNoDictDataType() {
        return this.noDictDataType;
    }

    public void setNoDictNoSortDataType(DataType[] noDictNoSortDataType) {
        this.noDictNoSortDataType = noDictNoSortDataType;
    }

    public void setNoDictDataType(DataType[] noDictDataType) {
        this.noDictDataType = noDictDataType;
    }

    public boolean[] getSortColumn() {
        return this.sortColumn;
    }

    public void setSortColumn(boolean[] sortColumn) {
        this.sortColumn = sortColumn;
    }
}

