/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.store;

import org.apache.carbondata.core.metadata.ColumnarFormatVersion;
import org.apache.carbondata.processing.store.CarbonFactDataHandlerModel;
import org.apache.carbondata.processing.store.writer.CarbonFactDataWriter;
import org.apache.carbondata.processing.store.writer.v3.CarbonFactDataWriterImplV3;

class CarbonDataWriterFactory {
    private static final CarbonDataWriterFactory CARBON_DATA_WRITER_FACTORY = new CarbonDataWriterFactory();

    private CarbonDataWriterFactory() {
    }

    public static CarbonDataWriterFactory getInstance() {
        return CARBON_DATA_WRITER_FACTORY;
    }

    public CarbonFactDataWriter getFactDataWriter(ColumnarFormatVersion version, CarbonFactDataHandlerModel model) {
        switch (version) {
            case V1: 
            case V2: {
                throw new UnsupportedOperationException("V1 and V2 CarbonData Writer is not supported");
            }
            case V3: {
                return new CarbonFactDataWriterImplV3(model);
            }
        }
        return new CarbonFactDataWriterImplV3(model);
    }
}

