/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.exception.CarbonDataWriterException;
import org.apache.carbondata.core.datastore.row.CarbonRow;
import org.apache.carbondata.core.datastore.row.WriteStepRowUtil;
import org.apache.carbondata.core.keygenerator.KeyGenException;
import org.apache.carbondata.core.keygenerator.columnar.impl.MultiDimKeyVarLengthEquiSplitGenerator;
import org.apache.carbondata.core.memory.MemoryException;
import org.apache.carbondata.core.metadata.ColumnarFormatVersion;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonThreadFactory;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.processing.datatypes.GenericDataType;
import org.apache.carbondata.processing.store.CarbonDataWriterFactory;
import org.apache.carbondata.processing.store.CarbonFactDataHandlerModel;
import org.apache.carbondata.processing.store.CarbonFactHandler;
import org.apache.carbondata.processing.store.TablePage;
import org.apache.carbondata.processing.store.writer.CarbonFactDataWriter;

public class CarbonFactDataHandlerColumnar
implements CarbonFactHandler {
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)CarbonFactDataHandlerColumnar.class.getName());
    private CarbonFactDataHandlerModel model;
    private CarbonFactDataWriter dataWriter;
    private int entryCount;
    private int pageSize;
    private long processedDataCount;
    private ExecutorService producerExecutorService;
    private List<Future<Void>> producerExecutorServiceTaskList;
    private ExecutorService consumerExecutorService;
    private List<Future<Void>> consumerExecutorServiceTaskList;
    private List<CarbonRow> dataRows;
    private int[] varcharColumnSizeInByte;
    private Semaphore semaphore;
    private int writerTaskSequenceCounter;
    private TablePageList tablePageList;
    private int numberOfCores;
    private AtomicInteger blockletProcessingCount;
    private boolean processingComplete;
    private ColumnarFormatVersion version;

    public CarbonFactDataHandlerColumnar(CarbonFactDataHandlerModel model) {
        this.model = model;
        this.initParameters(model);
        this.version = CarbonProperties.getInstance().getFormatVersion();
        StringBuffer noInvertedIdxCol = new StringBuffer();
        for (CarbonDimension cd : model.getSegmentProperties().getDimensions()) {
            if (cd.isUseInvertedIndex().booleanValue()) continue;
            noInvertedIdxCol.append(cd.getColName()).append(",");
        }
        LOGGER.info("Columns considered as NoInverted Index are " + noInvertedIdxCol.toString());
    }

    private void initParameters(CarbonFactDataHandlerModel model) {
        this.numberOfCores = model.getNumberOfCores();
        this.blockletProcessingCount = new AtomicInteger(0);
        this.producerExecutorService = Executors.newFixedThreadPool(model.getNumberOfCores(), (ThreadFactory)new CarbonThreadFactory("ProducerPool_" + System.nanoTime() + ":" + model.getTableName() + ", range: " + model.getBucketId()));
        this.producerExecutorServiceTaskList = new ArrayList<Future<Void>>(16);
        LOGGER.info("Initializing writer executors");
        this.consumerExecutorService = Executors.newFixedThreadPool(1, (ThreadFactory)new CarbonThreadFactory("ConsumerPool_" + System.nanoTime() + ":" + model.getTableName() + ", range: " + model.getBucketId()));
        this.consumerExecutorServiceTaskList = new ArrayList<Future<Void>>(1);
        this.semaphore = new Semaphore(this.numberOfCores);
        this.tablePageList = new TablePageList();
        Consumer consumer = new Consumer(this.tablePageList);
        this.consumerExecutorServiceTaskList.add(this.consumerExecutorService.submit(consumer));
    }

    private void setComplexMapSurrogateIndex(int dimensionCount) {
        int surrIndex = 0;
        for (int i = 0; i < dimensionCount; ++i) {
            GenericDataType complexDataType = this.model.getComplexIndexMap().get(i);
            if (complexDataType != null) {
                ArrayList<GenericDataType> primitiveTypes = new ArrayList<GenericDataType>();
                complexDataType.getAllPrimitiveChildren(primitiveTypes);
                for (GenericDataType eachPrimitive : primitiveTypes) {
                    if (!eachPrimitive.getIsColumnDictionary()) continue;
                    eachPrimitive.setSurrogateIndex(surrIndex++);
                }
                continue;
            }
            ++surrIndex;
        }
    }

    @Override
    public void initialise() throws CarbonDataWriterException {
        this.setWritingConfiguration();
    }

    @Override
    public void addDataToStore(CarbonRow row) throws CarbonDataWriterException {
        this.dataRows.add(row);
        ++this.entryCount;
        if (this.entryCount == this.pageSize || this.isVarcharColumnFull(row)) {
            try {
                this.semaphore.acquire();
                this.producerExecutorServiceTaskList.add(this.producerExecutorService.submit(new Producer(this.tablePageList, this.dataRows, ++this.writerTaskSequenceCounter, false)));
                this.blockletProcessingCount.incrementAndGet();
                this.processedDataCount += (long)this.entryCount;
                LOGGER.info("Total Number Of records added to store: " + this.processedDataCount);
                this.dataRows = new ArrayList<CarbonRow>(this.pageSize);
                this.entryCount = 0;
            }
            catch (InterruptedException e) {
                LOGGER.error((Throwable)e, e.getMessage());
                throw new CarbonDataWriterException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private boolean isVarcharColumnFull(CarbonRow row) {
        if (this.model.getVarcharDimIdxInNoDict().size() > 0) {
            Object[] nonDictArray = WriteStepRowUtil.getNoDictAndComplexDimension((CarbonRow)row);
            for (int i = 0; i < this.model.getVarcharDimIdxInNoDict().size(); ++i) {
                if (DataTypeUtil.isPrimitiveColumn((DataType)this.model.getNoDictAndComplexColumns()[i].getDataType())) {
                    int n = i;
                    this.varcharColumnSizeInByte[n] = this.varcharColumnSizeInByte[n] + this.model.getNoDictAndComplexColumns()[i].getDataType().getSizeInBytes();
                } else {
                    int n = i;
                    this.varcharColumnSizeInByte[n] = this.varcharColumnSizeInByte[n] + ((byte[])nonDictArray[this.model.getVarcharDimIdxInNoDict().get(i)]).length;
                }
                if (1840700241 - (this.varcharColumnSizeInByte[i] + this.dataRows.size() * 4) >= 0x200000) continue;
                LOGGER.info("Limited by varchar column, page size is " + this.dataRows.size());
                this.varcharColumnSizeInByte = new int[this.model.getVarcharDimIdxInNoDict().size()];
                return true;
            }
        }
        return false;
    }

    private TablePage processDataRows(List<CarbonRow> dataRows) throws CarbonDataWriterException, KeyGenException, MemoryException, IOException {
        if (dataRows.size() == 0) {
            return new TablePage(this.model, 0);
        }
        TablePage tablePage = new TablePage(this.model, dataRows.size());
        int rowId = 0;
        for (CarbonRow row : dataRows) {
            tablePage.addRow(rowId++, row);
        }
        tablePage.encode();
        LOGGER.info("Number Of records processed: " + dataRows.size());
        return tablePage;
    }

    @Override
    public void finish() throws CarbonDataWriterException {
        if (null == this.dataWriter) {
            return;
        }
        if (this.producerExecutorService.isShutdown()) {
            return;
        }
        LOGGER.info("Started Finish Operation");
        try {
            this.semaphore.acquire();
            this.producerExecutorServiceTaskList.add(this.producerExecutorService.submit(new Producer(this.tablePageList, this.dataRows, ++this.writerTaskSequenceCounter, true)));
            this.blockletProcessingCount.incrementAndGet();
            this.processedDataCount += (long)this.entryCount;
            LOGGER.info("Total Number Of records added to store: " + this.processedDataCount);
            this.closeWriterExecutionService(this.producerExecutorService);
            this.processWriteTaskSubmitList(this.producerExecutorServiceTaskList);
            this.processingComplete = true;
        }
        catch (InterruptedException e) {
            LOGGER.error((Throwable)e, e.getMessage());
            throw new CarbonDataWriterException(e.getMessage(), (Throwable)e);
        }
    }

    private void closeWriterExecutionService(ExecutorService service) throws CarbonDataWriterException {
        try {
            service.shutdown();
            service.awaitTermination(1L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            LOGGER.error((Throwable)e, e.getMessage());
            throw new CarbonDataWriterException(e.getMessage());
        }
    }

    private void processWriteTaskSubmitList(List<Future<Void>> taskList) throws CarbonDataWriterException {
        for (int i = 0; i < taskList.size(); ++i) {
            try {
                taskList.get(i).get();
                continue;
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error((Throwable)e, e.getMessage());
                throw new CarbonDataWriterException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private int getExpandedComplexColsCount() {
        return this.model.getExpandedComplexColsCount();
    }

    @Override
    public void closeHandler() throws CarbonDataWriterException {
        if (null != this.dataWriter) {
            while (this.blockletProcessingCount.get() > 0) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    throw new CarbonDataWriterException(e.getMessage());
                }
            }
            this.consumerExecutorService.shutdownNow();
            this.processWriteTaskSubmitList(this.consumerExecutorServiceTaskList);
            this.dataWriter.writeFooter();
            LOGGER.info("All blocklets have been finished writing");
            this.dataWriter.closeWriter();
        }
        this.dataWriter = null;
    }

    private void setWritingConfiguration() throws CarbonDataWriterException {
        int i;
        this.pageSize = Integer.parseInt(CarbonProperties.getInstance().getProperty("carbon.blocklet.size", "120000"));
        if (this.version == ColumnarFormatVersion.V3) {
            this.pageSize = this.pageSize < 32000 ? this.pageSize : 32000;
        }
        LOGGER.info("Number of rows per column page is configured as pageSize = " + this.pageSize);
        this.dataRows = new ArrayList<CarbonRow>(this.pageSize);
        if (this.model.getVarcharDimIdxInNoDict().size() > 0) {
            LOGGER.info("Number of rows per column blocklet is constrained by pageSize and actual size of long string column(s)");
            this.varcharColumnSizeInByte = new int[this.model.getVarcharDimIdxInNoDict().size()];
        }
        int dimSet = Integer.parseInt("1");
        int[] keyBlockSize = new int[this.getExpandedComplexColsCount()];
        ArrayList<Integer> otherMeasureIndexList = new ArrayList<Integer>(16);
        ArrayList<Integer> customMeasureIndexList = new ArrayList<Integer>(16);
        DataType[] type = this.model.getMeasureDataType();
        for (int j = 0; j < type.length; ++j) {
            if (type[j] != DataTypes.BYTE && !DataTypes.isDecimal((DataType)type[j])) {
                otherMeasureIndexList.add(j);
                continue;
            }
            customMeasureIndexList.add(j);
        }
        int[] otherMeasureIndex = new int[otherMeasureIndexList.size()];
        int[] customMeasureIndex = new int[customMeasureIndexList.size()];
        for (i = 0; i < otherMeasureIndex.length; ++i) {
            otherMeasureIndex[i] = (Integer)otherMeasureIndexList.get(i);
        }
        for (i = 0; i < customMeasureIndex.length; ++i) {
            customMeasureIndex[i] = (Integer)customMeasureIndexList.get(i);
        }
        this.setComplexMapSurrogateIndex(this.model.getDimensionCount());
        int[] blockKeySize = this.getBlockKeySizeWithComplexTypes(new MultiDimKeyVarLengthEquiSplitGenerator(CarbonUtil.getIncrementedCardinalityFullyFilled((int[])((int[])this.model.getDimLens().clone())), (byte)dimSet).getBlockKeySize());
        System.arraycopy(blockKeySize, 0, keyBlockSize, 0, blockKeySize.length);
        this.dataWriter = this.getFactDataWriter();
        this.dataWriter.initializeWriter();
    }

    private int[] getBlockKeySizeWithComplexTypes(int[] primitiveBlockKeySize) {
        int i;
        int allColsCount = this.getExpandedComplexColsCount();
        int[] blockKeySizeWithComplexTypes = new int[allColsCount];
        ArrayList<Integer> blockKeySizeWithComplex = new ArrayList<Integer>(blockKeySizeWithComplexTypes.length);
        int dictDimensionCount = this.model.getDimensionCount();
        for (i = 0; i < dictDimensionCount; ++i) {
            GenericDataType complexDataType = this.model.getComplexIndexMap().get(i);
            if (complexDataType != null) {
                complexDataType.fillBlockKeySize(blockKeySizeWithComplex, primitiveBlockKeySize);
                continue;
            }
            blockKeySizeWithComplex.add(primitiveBlockKeySize[i]);
        }
        for (i = 0; i < blockKeySizeWithComplexTypes.length; ++i) {
            blockKeySizeWithComplexTypes[i] = (Integer)blockKeySizeWithComplex.get(i);
        }
        return blockKeySizeWithComplexTypes;
    }

    private CarbonFactDataWriter getFactDataWriter() {
        return CarbonDataWriterFactory.getInstance().getFactDataWriter(this.version, this.model);
    }

    private void resetBlockletProcessingCount() {
        this.blockletProcessingCount.set(0);
    }

    private final class Consumer
    implements Callable<Void> {
        private TablePageList tablePageList;

        private Consumer(TablePageList tablePageList) {
            this.tablePageList = tablePageList;
        }

        @Override
        public Void call() throws Exception {
            while (!CarbonFactDataHandlerColumnar.this.processingComplete || CarbonFactDataHandlerColumnar.this.blockletProcessingCount.get() > 0) {
                TablePage tablePage = null;
                try {
                    tablePage = this.tablePageList.get();
                    if (null != tablePage) {
                        CarbonFactDataHandlerColumnar.this.dataWriter.writeTablePage(tablePage);
                        tablePage.freeMemory();
                    }
                    CarbonFactDataHandlerColumnar.this.blockletProcessingCount.decrementAndGet();
                }
                catch (Throwable throwable) {
                    if (CarbonFactDataHandlerColumnar.this.processingComplete && CarbonFactDataHandlerColumnar.this.blockletProcessingCount.get() <= 0) continue;
                    CarbonFactDataHandlerColumnar.this.producerExecutorService.shutdownNow();
                    CarbonFactDataHandlerColumnar.this.resetBlockletProcessingCount();
                    LOGGER.error(throwable, "Problem while writing the carbon data file");
                    throw new CarbonDataWriterException(throwable.getMessage());
                }
                finally {
                    CarbonFactDataHandlerColumnar.this.semaphore.release();
                }
            }
            return null;
        }
    }

    private final class Producer
    implements Callable<Void> {
        private TablePageList tablePageList;
        private List<CarbonRow> dataRows;
        private int pageId;
        private boolean isLastPage;

        private Producer(TablePageList tablePageList, List<CarbonRow> dataRows, int pageId, boolean isLastPage) {
            this.tablePageList = tablePageList;
            this.dataRows = dataRows;
            this.pageId = pageId;
            this.isLastPage = isLastPage;
        }

        @Override
        public Void call() throws Exception {
            try {
                TablePage tablePage = CarbonFactDataHandlerColumnar.this.processDataRows(this.dataRows);
                this.dataRows = null;
                tablePage.setIsLastPage(this.isLastPage);
                int indexInNodeHolderArray = (this.pageId - 1) % CarbonFactDataHandlerColumnar.this.numberOfCores;
                this.tablePageList.put(tablePage, indexInNodeHolderArray);
                return null;
            }
            catch (Throwable throwable) {
                LOGGER.error(throwable, "Error in producer");
                CarbonFactDataHandlerColumnar.this.consumerExecutorService.shutdownNow();
                CarbonFactDataHandlerColumnar.this.resetBlockletProcessingCount();
                throw new CarbonDataWriterException(throwable.getMessage(), throwable);
            }
        }
    }

    private final class TablePageList {
        private TablePage[] tablePages;
        private AtomicBoolean available;
        private int currentIndex;

        private TablePageList() {
            this.tablePages = new TablePage[CarbonFactDataHandlerColumnar.this.numberOfCores];
            this.available = new AtomicBoolean(false);
        }

        public synchronized TablePage get() throws InterruptedException {
            TablePage tablePage = this.tablePages[this.currentIndex];
            if (null == tablePage && !CarbonFactDataHandlerColumnar.this.processingComplete) {
                this.available.set(false);
            }
            while (!this.available.get()) {
                this.wait();
            }
            tablePage = this.tablePages[this.currentIndex];
            this.tablePages[this.currentIndex] = null;
            ++this.currentIndex;
            if (this.currentIndex >= this.tablePages.length) {
                this.currentIndex = 0;
            }
            return tablePage;
        }

        public synchronized void put(TablePage tablePage, int index) {
            this.tablePages[index] = tablePage;
            if (index == this.currentIndex) {
                this.available.set(true);
                this.notifyAll();
            }
        }
    }
}

