/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.store.writer.v3;

import java.util.concurrent.ExecutorService;
import org.apache.carbondata.core.datastore.blocklet.EncodedBlocklet;
import org.apache.carbondata.core.datastore.page.EncodedTablePage;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.processing.store.CarbonFactDataHandlerModel;
import org.apache.carbondata.processing.store.TablePage;

public class BlockletDataHolder {
    private long currentSize;
    private EncodedBlocklet encodedBlocklet;

    public BlockletDataHolder(ExecutorService fallbackpool, CarbonFactDataHandlerModel model) {
        this.encodedBlocklet = new EncodedBlocklet(fallbackpool, Boolean.parseBoolean(CarbonProperties.getInstance().getProperty("carbon.local.dictionary.decoder.fallback", "true")), model.getColumnLocalDictGenMap());
    }

    public void clear() {
        this.currentSize = 0L;
        this.encodedBlocklet.clear();
    }

    public void addPage(TablePage rawTablePage) {
        EncodedTablePage encodedTablePage = rawTablePage.getEncodedTablePage();
        this.currentSize += (long)encodedTablePage.getEncodedSize();
        this.encodedBlocklet.addEncodedTablePage(encodedTablePage);
    }

    public long getSize() {
        return this.currentSize + this.currentSize * 15L / 100L;
    }

    public int getNumberOfPagesAdded() {
        return this.encodedBlocklet.getNumberOfPages();
    }

    public int getTotalRows() {
        return this.encodedBlocklet.getBlockletSize();
    }

    public EncodedBlocklet getEncodedBlocklet() {
        return this.encodedBlocklet;
    }
}

