/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.store.writer.v3;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.blocklet.BlockletEncodedColumnPage;
import org.apache.carbondata.core.datastore.blocklet.EncodedBlocklet;
import org.apache.carbondata.core.datastore.exception.CarbonDataWriterException;
import org.apache.carbondata.core.datastore.page.encoding.EncodedColumnPage;
import org.apache.carbondata.core.metadata.blocklet.BlockletInfo;
import org.apache.carbondata.core.metadata.blocklet.index.BlockletBTreeIndex;
import org.apache.carbondata.core.metadata.blocklet.index.BlockletMinMaxIndex;
import org.apache.carbondata.core.metadata.index.BlockIndexInfo;
import org.apache.carbondata.core.util.CarbonMetadataUtil;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.DataFileFooterConverterV3;
import org.apache.carbondata.format.BlockletIndex;
import org.apache.carbondata.format.BlockletInfo3;
import org.apache.carbondata.format.FileFooter3;
import org.apache.carbondata.processing.loading.sort.SortScopeOptions;
import org.apache.carbondata.processing.store.CarbonFactDataHandlerModel;
import org.apache.carbondata.processing.store.TablePage;
import org.apache.carbondata.processing.store.writer.AbstractFactDataWriter;
import org.apache.carbondata.processing.store.writer.v3.BlockletDataHolder;
import org.apache.thrift.TBase;

public class CarbonFactDataWriterImplV3
extends AbstractFactDataWriter {
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)CarbonFactDataWriterImplV3.class.getName());
    private BlockletDataHolder blockletDataHolder;
    private long blockletSizeThreshold;
    private boolean isSorted;

    public CarbonFactDataWriterImplV3(CarbonFactDataHandlerModel model) {
        super(model);
        String blockletSize = (String)model.getTableSpec().getCarbonTable().getTableInfo().getFactTable().getTableProperties().get("table_blocklet_size");
        if (blockletSize == null) {
            blockletSize = CarbonProperties.getInstance().getProperty("carbon.blockletgroup.size.in.mb", "64");
        }
        this.blockletSizeThreshold = Long.parseLong(blockletSize) << 20;
        if (this.blockletSizeThreshold > this.fileSizeInBytes) {
            this.blockletSizeThreshold = this.fileSizeInBytes;
            LOGGER.info("Blocklet size configure for table is: " + this.blockletSizeThreshold);
        }
        this.blockletDataHolder = new BlockletDataHolder(this.fallbackExecutorService, model);
        this.isSorted = model.getSortScope() != SortScopeOptions.SortScope.NO_SORT;
    }

    @Override
    protected void writeFooterToFile() throws CarbonDataWriterException {
        try {
            long currentPosition = this.currentOffsetInFile;
            FileFooter3 convertFileMeta = CarbonMetadataUtil.convertFileFooterVersion3((List)this.blockletMetadata, (List)this.blockletIndex, (int[])this.localCardinality, (int)this.thriftColumnSchemaList.size());
            convertFileMeta.setIs_sort(this.isSorted);
            this.fillBlockIndexInfoDetails(convertFileMeta.getNum_rows(), this.carbonDataFileName, currentPosition);
            byte[] byteArray = CarbonUtil.getByteArray((TBase)convertFileMeta);
            ByteBuffer buffer = ByteBuffer.allocate(byteArray.length + 8);
            buffer.put(byteArray);
            buffer.putLong(currentPosition);
            buffer.flip();
            this.currentOffsetInFile += (long)this.fileChannel.write(buffer);
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e, "Problem while writing the carbon file");
            throw new CarbonDataWriterException("Problem while writing the carbon file: ", (Throwable)e);
        }
    }

    @Override
    public void writeTablePage(TablePage tablePage) throws CarbonDataWriterException, IOException {
        if (!tablePage.isLastPage()) {
            boolean isAdded = false;
            if (this.blockletDataHolder.getSize() + (long)tablePage.getEncodedTablePage().getEncodedSize() >= this.blockletSizeThreshold) {
                if (this.blockletDataHolder.getNumberOfPagesAdded() == 0) {
                    isAdded = true;
                    this.addPageData(tablePage);
                }
                LOGGER.info("Number of Pages for blocklet is: " + this.blockletDataHolder.getNumberOfPagesAdded() + " :Rows Added: " + this.blockletDataHolder.getTotalRows());
                this.writeBlockletToFile();
            }
            if (!isAdded) {
                this.addPageData(tablePage);
            }
        } else {
            if (tablePage.getPageSize() > 0) {
                this.addPageData(tablePage);
            }
            if (this.blockletDataHolder.getNumberOfPagesAdded() > 0) {
                LOGGER.info("Number of Pages for blocklet is: " + this.blockletDataHolder.getNumberOfPagesAdded() + " :Rows Added: " + this.blockletDataHolder.getTotalRows());
                this.writeBlockletToFile();
            }
        }
    }

    private void addPageData(TablePage tablePage) throws IOException {
        this.blockletDataHolder.addPage(tablePage);
        if (this.listener != null && this.model.getDatabaseName().equalsIgnoreCase(this.listener.getTblIdentifier().getDatabaseName()) && this.model.getTableName().equalsIgnoreCase(this.listener.getTblIdentifier().getTableName())) {
            if (this.pageId == 0) {
                this.listener.onBlockletStart(this.blockletId);
            }
            this.listener.onPageAdded(this.blockletId, this.pageId++, tablePage);
        }
    }

    private void writeBlockletToFile() {
        EncodedBlocklet encodedBlocklet = this.blockletDataHolder.getEncodedBlocklet();
        int numDimensions = encodedBlocklet.getNumberOfDimension();
        int numMeasures = encodedBlocklet.getNumberOfMeasure();
        byte[][] dataChunkBytes = new byte[numDimensions + numMeasures][];
        long metadataSize = this.fillDataChunk(encodedBlocklet, dataChunkBytes);
        long blockletSize = this.blockletDataHolder.getSize() + metadataSize;
        this.createNewFileIfReachThreshold(blockletSize);
        try {
            if (this.currentOffsetInFile == 0L) {
                this.writeHeaderToFile();
            }
            this.writeBlockletToFile(dataChunkBytes);
            if (this.listener != null && this.model.getDatabaseName().equalsIgnoreCase(this.listener.getTblIdentifier().getDatabaseName()) && this.model.getTableName().equalsIgnoreCase(this.listener.getTblIdentifier().getTableName())) {
                this.listener.onBlockletEnd(this.blockletId++);
            }
            this.pageId = 0;
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e, "Problem while writing file");
            throw new CarbonDataWriterException("Problem while writing file", (Throwable)e);
        }
        finally {
            this.blockletDataHolder.clear();
        }
    }

    private long fillDataChunk(EncodedBlocklet encodedBlocklet, byte[][] dataChunkBytes) {
        int i;
        int size = 0;
        int numDimensions = encodedBlocklet.getNumberOfDimension();
        int numMeasures = encodedBlocklet.getNumberOfMeasure();
        int measureStartIndex = numDimensions;
        for (i = 0; i < numDimensions; ++i) {
            dataChunkBytes[i] = CarbonUtil.getByteArray((TBase)CarbonMetadataUtil.getDimensionDataChunk3((EncodedBlocklet)encodedBlocklet, (int)i));
            size += dataChunkBytes[i].length;
        }
        for (i = 0; i < numMeasures; ++i) {
            dataChunkBytes[measureStartIndex] = CarbonUtil.getByteArray((TBase)CarbonMetadataUtil.getMeasureDataChunk3((EncodedBlocklet)encodedBlocklet, (int)i));
            size += dataChunkBytes[measureStartIndex].length;
            ++measureStartIndex;
        }
        return size;
    }

    private void writeHeaderToFile() throws IOException {
        byte[] fileHeader = CarbonUtil.getByteArray((TBase)CarbonMetadataUtil.getFileHeader((boolean)true, (List)this.thriftColumnSchemaList, (long)this.model.getSchemaUpdatedTimeStamp()));
        ByteBuffer buffer = ByteBuffer.wrap(fileHeader);
        this.currentOffsetInFile += (long)this.fileChannel.write(buffer);
    }

    private void writeBlockletToFile(byte[][] dataChunkBytes) throws IOException {
        long offset = this.currentOffsetInFile;
        ArrayList<Long> currentDataChunksOffset = new ArrayList<Long>();
        ArrayList<Integer> currentDataChunksLength = new ArrayList<Integer>();
        EncodedBlocklet encodedBlocklet = this.blockletDataHolder.getEncodedBlocklet();
        int numberOfDimension = encodedBlocklet.getNumberOfDimension();
        int numberOfMeasures = encodedBlocklet.getNumberOfMeasure();
        ByteBuffer buffer = null;
        long dimensionOffset = 0L;
        long measureOffset = 0L;
        for (int i = 0; i < numberOfDimension; ++i) {
            currentDataChunksOffset.add(offset);
            currentDataChunksLength.add(dataChunkBytes[i].length);
            buffer = ByteBuffer.wrap(dataChunkBytes[i]);
            this.currentOffsetInFile += (long)this.fileChannel.write(buffer);
            offset += (long)dataChunkBytes[i].length;
            BlockletEncodedColumnPage blockletEncodedColumnPage = (BlockletEncodedColumnPage)encodedBlocklet.getEncodedDimensionColumnPages().get(i);
            for (EncodedColumnPage dimensionPage : blockletEncodedColumnPage.getEncodedColumnPageList()) {
                buffer = dimensionPage.getEncodedData();
                int bufferSize = buffer.limit();
                this.currentOffsetInFile += (long)this.fileChannel.write(buffer);
                offset += (long)bufferSize;
            }
        }
        dimensionOffset = offset;
        int dataChunkStartIndex = encodedBlocklet.getNumberOfDimension();
        for (int i = 0; i < numberOfMeasures; ++i) {
            currentDataChunksOffset.add(offset);
            currentDataChunksLength.add(dataChunkBytes[dataChunkStartIndex].length);
            buffer = ByteBuffer.wrap(dataChunkBytes[dataChunkStartIndex]);
            this.currentOffsetInFile += (long)this.fileChannel.write(buffer);
            offset += (long)dataChunkBytes[dataChunkStartIndex].length;
            ++dataChunkStartIndex;
            BlockletEncodedColumnPage blockletEncodedColumnPage = (BlockletEncodedColumnPage)encodedBlocklet.getEncodedMeasureColumnPages().get(i);
            for (EncodedColumnPage measurePage : blockletEncodedColumnPage.getEncodedColumnPageList()) {
                buffer = measurePage.getEncodedData();
                int bufferSize = buffer.limit();
                this.currentOffsetInFile += (long)this.fileChannel.write(buffer);
                offset += (long)bufferSize;
            }
        }
        measureOffset = offset;
        this.blockletIndex.add(CarbonMetadataUtil.getBlockletIndex((EncodedBlocklet)encodedBlocklet, (List)this.model.getSegmentProperties().getMeasures()));
        BlockletInfo3 blockletInfo3 = new BlockletInfo3(encodedBlocklet.getBlockletSize(), currentDataChunksOffset, currentDataChunksLength, dimensionOffset, measureOffset, encodedBlocklet.getNumberOfPages());
        this.blockletMetadata.add(blockletInfo3);
    }

    @Override
    protected void fillBlockIndexInfoDetails(long numberOfRows, String carbonDataFileName, long currentPosition) {
        int i = 0;
        DataFileFooterConverterV3 converterV3 = new DataFileFooterConverterV3();
        for (BlockletIndex index : this.blockletIndex) {
            BlockletInfo3 blockletInfo3 = (BlockletInfo3)this.blockletMetadata.get(i);
            BlockletInfo blockletInfo = converterV3.getBlockletInfo(blockletInfo3, this.model.getSegmentProperties().getDimensions().size());
            BlockletBTreeIndex bTreeIndex = new BlockletBTreeIndex(index.b_tree_index.getStart_key(), index.b_tree_index.getEnd_key());
            BlockletMinMaxIndex minMaxIndex = new BlockletMinMaxIndex(index.getMin_max_index().getMin_values(), index.getMin_max_index().getMax_values(), index.getMin_max_index().getMin_max_presence());
            org.apache.carbondata.core.metadata.blocklet.index.BlockletIndex bIndex = new org.apache.carbondata.core.metadata.blocklet.index.BlockletIndex(bTreeIndex, minMaxIndex);
            BlockIndexInfo biInfo = new BlockIndexInfo(numberOfRows, carbonDataFileName, currentPosition, bIndex, blockletInfo);
            this.blockIndexInfoList.add(biInfo);
            ++i;
        }
    }

    private byte[][] toByteArray(List<ByteBuffer> buffers) {
        byte[][] arrays = new byte[buffers.size()][];
        for (int i = 0; i < arrays.length; ++i) {
            arrays[i] = buffers.get(i).array();
        }
        return arrays;
    }

    @Override
    public void closeWriter() throws CarbonDataWriterException {
        CarbonDataWriterException exception = null;
        try {
            this.commitCurrentFile(true);
            this.writeIndexFile();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e, "Problem while writing the index file");
            exception = new CarbonDataWriterException("Problem while writing the index file", (Throwable)e);
        }
        finally {
            block13: {
                try {
                    this.closeExecutorService();
                }
                catch (CarbonDataWriterException e) {
                    if (null != exception) break block13;
                    exception = e;
                }
            }
        }
        if (null != exception) {
            throw exception;
        }
    }

    @Override
    public void writeFooter() throws CarbonDataWriterException {
        if (this.blockletMetadata.size() > 0) {
            this.writeFooterToFile();
        }
    }
}

