/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.imaging.FormatCompliance;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.ImagingParameters;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.common.BinaryFileParser;
import org.apache.commons.imaging.common.BufferedImageFactory;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.common.SimpleBufferedImageFactory;
import org.apache.commons.imaging.formats.bmp.BmpImageParser;
import org.apache.commons.imaging.formats.dcx.DcxImageParser;
import org.apache.commons.imaging.formats.gif.GifImageParser;
import org.apache.commons.imaging.formats.icns.IcnsImageParser;
import org.apache.commons.imaging.formats.ico.IcoImageParser;
import org.apache.commons.imaging.formats.jpeg.JpegImageParser;
import org.apache.commons.imaging.formats.pcx.PcxImageParser;
import org.apache.commons.imaging.formats.png.PngImageParser;
import org.apache.commons.imaging.formats.pnm.PnmImageParser;
import org.apache.commons.imaging.formats.psd.PsdImageParser;
import org.apache.commons.imaging.formats.rgbe.RgbeImageParser;
import org.apache.commons.imaging.formats.tiff.TiffImageParser;
import org.apache.commons.imaging.formats.wbmp.WbmpImageParser;
import org.apache.commons.imaging.formats.webp.WebPImageParser;
import org.apache.commons.imaging.formats.xbm.XbmImageParser;
import org.apache.commons.imaging.formats.xpm.XpmImageParser;

public abstract class AbstractImageParser<T extends ImagingParameters<T>>
extends BinaryFileParser {
    private static final Logger LOGGER = Logger.getLogger(AbstractImageParser.class.getName());

    public static List<AbstractImageParser<?>> getAllImageParsers() {
        return Arrays.asList(new BmpImageParser(), new DcxImageParser(), new GifImageParser(), new IcnsImageParser(), new IcoImageParser(), new JpegImageParser(), new PcxImageParser(), new PngImageParser(), new PnmImageParser(), new PsdImageParser(), new RgbeImageParser(), new TiffImageParser(), new WebPImageParser(), new WbmpImageParser(), new XbmImageParser(), new XpmImageParser());
    }

    public AbstractImageParser() {
    }

    public AbstractImageParser(ByteOrder byteOrder) {
        super(byteOrder);
    }

    public boolean canAcceptExtension(File file) {
        return this.canAcceptExtension(file.getName());
    }

    public final boolean canAcceptExtension(String fileName) {
        String[] extensions = this.getAcceptedExtensions();
        if (extensions == null) {
            return true;
        }
        int index = fileName.lastIndexOf(46);
        if (index >= 0) {
            String fileNameExtension = fileName.substring(index + 1).toLowerCase(Locale.ENGLISH);
            for (String extension : extensions) {
                if (!extension.equals(fileNameExtension)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canAcceptType(ImageFormat type) {
        ImageFormat[] types;
        for (ImageFormat type2 : types = this.getAcceptedTypes()) {
            if (!type2.equals(type)) continue;
            return true;
        }
        return false;
    }

    public final String dumpImageFile(byte[] bytes) throws ImagingException, IOException {
        return this.dumpImageFile(ByteSource.array(bytes));
    }

    public final String dumpImageFile(ByteSource byteSource) throws ImagingException, IOException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.dumpImageFile(pw, byteSource);
        pw.flush();
        return sw.toString();
    }

    public final String dumpImageFile(File file) throws ImagingException, IOException {
        if (!this.canAcceptExtension(file)) {
            return null;
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(this.getName() + ": " + file.getName());
        }
        return this.dumpImageFile(ByteSource.file(file));
    }

    public boolean dumpImageFile(PrintWriter pw, ByteSource byteSource) throws ImagingException, IOException {
        return false;
    }

    protected abstract String[] getAcceptedExtensions();

    protected abstract ImageFormat[] getAcceptedTypes();

    public final List<BufferedImage> getAllBufferedImages(byte[] bytes) throws ImagingException, IOException {
        return this.getAllBufferedImages(ByteSource.array(bytes));
    }

    public List<BufferedImage> getAllBufferedImages(ByteSource byteSource) throws ImagingException, IOException {
        BufferedImage bi = this.getBufferedImage(byteSource, null);
        ArrayList<BufferedImage> result = new ArrayList<BufferedImage>();
        result.add(bi);
        return result;
    }

    public final List<BufferedImage> getAllBufferedImages(File file) throws ImagingException, IOException {
        if (!this.canAcceptExtension(file)) {
            return null;
        }
        return this.getAllBufferedImages(ByteSource.file(file));
    }

    public final BufferedImage getBufferedImage(byte[] bytes, T params) throws ImagingException, IOException {
        return this.getBufferedImage(ByteSource.array(bytes), params);
    }

    public abstract BufferedImage getBufferedImage(ByteSource var1, T var2) throws ImagingException, IOException;

    public final BufferedImage getBufferedImage(File file, T params) throws ImagingException, IOException {
        if (!this.canAcceptExtension(file)) {
            return null;
        }
        return this.getBufferedImage(ByteSource.file(file), params);
    }

    protected BufferedImageFactory getBufferedImageFactory(T params) {
        if (params == null) {
            return new SimpleBufferedImageFactory();
        }
        BufferedImageFactory result = ((ImagingParameters)params).getBufferedImageFactory();
        if (null != result) {
            return result;
        }
        return new SimpleBufferedImageFactory();
    }

    public abstract String getDefaultExtension();

    public abstract T getDefaultParameters();

    public final FormatCompliance getFormatCompliance(byte[] bytes) throws ImagingException, IOException {
        return this.getFormatCompliance(ByteSource.array(bytes));
    }

    public FormatCompliance getFormatCompliance(ByteSource byteSource) throws ImagingException, IOException {
        return null;
    }

    public final FormatCompliance getFormatCompliance(File file) throws ImagingException, IOException {
        if (!this.canAcceptExtension(file)) {
            return null;
        }
        return this.getFormatCompliance(ByteSource.file(file));
    }

    public final byte[] getIccProfileBytes(byte[] bytes) throws ImagingException, IOException {
        return this.getIccProfileBytes(bytes, null);
    }

    public final byte[] getIccProfileBytes(byte[] bytes, T params) throws ImagingException, IOException {
        return this.getIccProfileBytes(ByteSource.array(bytes), params);
    }

    public abstract byte[] getIccProfileBytes(ByteSource var1, T var2) throws ImagingException, IOException;

    public final byte[] getIccProfileBytes(File file) throws ImagingException, IOException {
        return this.getIccProfileBytes(file, null);
    }

    public final byte[] getIccProfileBytes(File file, T params) throws ImagingException, IOException {
        if (!this.canAcceptExtension(file)) {
            return null;
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(this.getName() + ": " + file.getName());
        }
        return this.getIccProfileBytes(ByteSource.file(file), params);
    }

    public final ImageInfo getImageInfo(byte[] bytes, T params) throws ImagingException, IOException {
        return this.getImageInfo(ByteSource.array(bytes), params);
    }

    public final ImageInfo getImageInfo(ByteSource byteSource) throws ImagingException, IOException {
        return this.getImageInfo(byteSource, null);
    }

    public abstract ImageInfo getImageInfo(ByteSource var1, T var2) throws ImagingException, IOException;

    public final ImageInfo getImageInfo(File file, T params) throws ImagingException, IOException {
        if (!this.canAcceptExtension(file)) {
            return null;
        }
        return this.getImageInfo(ByteSource.file(file), params);
    }

    public final Dimension getImageSize(byte[] bytes) throws ImagingException, IOException {
        return this.getImageSize(bytes, null);
    }

    public final Dimension getImageSize(byte[] bytes, T params) throws ImagingException, IOException {
        return this.getImageSize(ByteSource.array(bytes), params);
    }

    public abstract Dimension getImageSize(ByteSource var1, T var2) throws ImagingException, IOException;

    public final Dimension getImageSize(File file) throws ImagingException, IOException {
        return this.getImageSize(file, null);
    }

    public final Dimension getImageSize(File file, T params) throws ImagingException, IOException {
        if (!this.canAcceptExtension(file)) {
            return null;
        }
        return this.getImageSize(ByteSource.file(file), params);
    }

    public final ImageMetadata getMetadata(byte[] bytes) throws ImagingException, IOException {
        return this.getMetadata(bytes, null);
    }

    public final ImageMetadata getMetadata(byte[] bytes, T params) throws ImagingException, IOException {
        return this.getMetadata(ByteSource.array(bytes), params);
    }

    public final ImageMetadata getMetadata(ByteSource byteSource) throws ImagingException, IOException {
        return this.getMetadata(byteSource, null);
    }

    public abstract ImageMetadata getMetadata(ByteSource var1, T var2) throws ImagingException, IOException;

    public final ImageMetadata getMetadata(File file) throws ImagingException, IOException {
        return this.getMetadata(file, null);
    }

    public final ImageMetadata getMetadata(File file, T params) throws ImagingException, IOException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(this.getName() + ".getMetadata: " + file.getName());
        }
        if (!this.canAcceptExtension(file)) {
            return null;
        }
        return this.getMetadata(ByteSource.file(file), params);
    }

    public abstract String getName();

    public void writeImage(BufferedImage src, OutputStream os, T params) throws ImagingException, IOException {
        throw new ImagingException("This image format (" + this.getName() + ") cannot be written.");
    }
}

