/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging;

import java.awt.Dimension;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.imaging.AbstractImageParser;
import org.apache.commons.imaging.FormatCompliance;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.common.XmpEmbeddable;
import org.apache.commons.imaging.icc.IccProfileInfo;
import org.apache.commons.imaging.icc.IccProfileParser;
import org.apache.commons.imaging.internal.ImageParserFactory;

public final class Imaging {
    private static final int[] MAGIC_NUMBERS_GIF = new int[]{71, 73};
    private static final int[] MAGIC_NUMBERS_PNG = new int[]{137, 80};
    private static final int[] MAGIC_NUMBERS_JPEG = new int[]{255, 216};
    private static final int[] MAGIC_NUMBERS_BMP = new int[]{66, 77};
    private static final int[] MAGIC_NUMBERS_TIFF_MOTOROLA = new int[]{77, 77};
    private static final int[] MAGIC_NUMBERS_TIFF_INTEL = new int[]{73, 73};
    private static final int[] MAGIC_NUMBERS_PAM = new int[]{80, 55};
    private static final int[] MAGIC_NUMBERS_PSD = new int[]{56, 66};
    private static final int[] MAGIC_NUMBERS_PBM_A = new int[]{80, 49};
    private static final int[] MAGIC_NUMBERS_PBM_B = new int[]{80, 52};
    private static final int[] MAGIC_NUMBERS_PGM_A = new int[]{80, 50};
    private static final int[] MAGIC_NUMBERS_PGM_B = new int[]{80, 53};
    private static final int[] MAGIC_NUMBERS_PPM_A = new int[]{80, 51};
    private static final int[] MAGIC_NUMBERS_PPM_B = new int[]{80, 54};
    private static final int[] MAGIC_NUMBERS_JBIG2_1 = new int[]{151, 74};
    private static final int[] MAGIC_NUMBERS_JBIG2_2 = new int[]{66, 50};
    private static final int[] MAGIC_NUMBERS_ICNS = new int[]{105, 99};
    private static final int[] MAGIC_NUMBERS_DCX = new int[]{177, 104};
    private static final int[] MAGIC_NUMBERS_RGBE = new int[]{35, 63};
    private static final int[] MAGIC_NUMBERS_RIFF_1 = new int[]{82, 73};
    private static final int[] MAGIC_NUMBERS_RIFF_2 = new int[]{70, 70};
    private static final byte[] MAGIC_NUMBERS_WEBP = new byte[]{87, 69, 66, 80};

    private static boolean compareBytePair(int[] a, int[] b) {
        if (a.length != 2 && b.length != 2) {
            throw new IllegalArgumentException("Invalid Byte Pair.");
        }
        return a[0] == b[0] && a[1] == b[1];
    }

    public static String dumpImageFile(byte[] bytes) throws ImagingException, IOException {
        return Imaging.dumpImageFile(ByteSource.array(bytes));
    }

    private static String dumpImageFile(ByteSource byteSource) throws ImagingException, IOException {
        AbstractImageParser imageParser = ImageParserFactory.getImageParser(byteSource);
        return imageParser.dumpImageFile(byteSource);
    }

    public static String dumpImageFile(File file) throws ImagingException, IOException {
        return Imaging.dumpImageFile(ByteSource.file(file));
    }

    public static List<BufferedImage> getAllBufferedImages(byte[] bytes) throws ImagingException, IOException {
        return Imaging.getAllBufferedImages(ByteSource.array(bytes));
    }

    private static List<BufferedImage> getAllBufferedImages(ByteSource byteSource) throws ImagingException, IOException {
        AbstractImageParser imageParser = ImageParserFactory.getImageParser(byteSource);
        return imageParser.getAllBufferedImages(byteSource);
    }

    public static List<BufferedImage> getAllBufferedImages(File file) throws ImagingException, IOException {
        return Imaging.getAllBufferedImages(ByteSource.file(file));
    }

    public static List<BufferedImage> getAllBufferedImages(InputStream is, String fileName) throws ImagingException, IOException {
        return Imaging.getAllBufferedImages(ByteSource.inputStream(is, fileName));
    }

    public static BufferedImage getBufferedImage(byte[] bytes) throws ImagingException, IOException {
        return Imaging.getBufferedImage(ByteSource.array(bytes));
    }

    private static BufferedImage getBufferedImage(ByteSource byteSource) throws ImagingException, IOException {
        AbstractImageParser<Object> imageParser = ImageParserFactory.getImageParser(byteSource);
        return imageParser.getBufferedImage(byteSource, null);
    }

    public static BufferedImage getBufferedImage(File file) throws ImagingException, IOException {
        return Imaging.getBufferedImage(ByteSource.file(file));
    }

    public static BufferedImage getBufferedImage(InputStream is) throws ImagingException, IOException {
        return Imaging.getBufferedImage(is, null);
    }

    public static BufferedImage getBufferedImage(InputStream is, String fileName) throws ImagingException, IOException {
        return Imaging.getBufferedImage(ByteSource.inputStream(is, fileName));
    }

    public static FormatCompliance getFormatCompliance(byte[] bytes) throws ImagingException, IOException {
        return Imaging.getFormatCompliance(ByteSource.array(bytes));
    }

    private static FormatCompliance getFormatCompliance(ByteSource byteSource) throws ImagingException, IOException {
        AbstractImageParser imageParser = ImageParserFactory.getImageParser(byteSource);
        return imageParser.getFormatCompliance(byteSource);
    }

    public static FormatCompliance getFormatCompliance(File file) throws ImagingException, IOException {
        return Imaging.getFormatCompliance(ByteSource.file(file));
    }

    public static ICC_Profile getIccProfile(byte[] bytes) throws ImagingException, IOException {
        return Imaging.getIccProfile(ByteSource.array(bytes));
    }

    protected static ICC_Profile getIccProfile(ByteSource byteSource) throws ImagingException, IOException {
        byte[] bytes = Imaging.getIccProfileBytes(byteSource);
        if (bytes == null) {
            return null;
        }
        IccProfileParser parser = new IccProfileParser();
        IccProfileInfo info = parser.getIccProfileInfo(bytes);
        if (info == null) {
            return null;
        }
        if (info.isSrgb()) {
            return null;
        }
        return ICC_Profile.getInstance(bytes);
    }

    public static ICC_Profile getIccProfile(File file) throws ImagingException, IOException {
        return Imaging.getIccProfile(ByteSource.file(file));
    }

    public static ICC_Profile getIccProfile(InputStream is, String fileName) throws ImagingException, IOException {
        return Imaging.getIccProfile(ByteSource.inputStream(is, fileName));
    }

    public static byte[] getIccProfileBytes(byte[] bytes) throws ImagingException, IOException {
        return Imaging.getIccProfileBytes(ByteSource.array(bytes));
    }

    private static byte[] getIccProfileBytes(ByteSource byteSource) throws ImagingException, IOException {
        AbstractImageParser<Object> imageParser = ImageParserFactory.getImageParser(byteSource);
        return imageParser.getIccProfileBytes(byteSource, null);
    }

    public static byte[] getIccProfileBytes(File file) throws ImagingException, IOException {
        return Imaging.getIccProfileBytes(ByteSource.file(file));
    }

    public static ImageInfo getImageInfo(byte[] bytes) throws ImagingException, IOException {
        return Imaging.getImageInfo(ByteSource.array(bytes));
    }

    private static ImageInfo getImageInfo(ByteSource byteSource) throws ImagingException, IOException {
        return ImageParserFactory.getImageParser(byteSource).getImageInfo(byteSource, null);
    }

    public static ImageInfo getImageInfo(File file) throws ImagingException, IOException {
        return Imaging.getImageInfo(ByteSource.file(file));
    }

    public static ImageInfo getImageInfo(InputStream is, String fileName) throws ImagingException, IOException {
        return Imaging.getImageInfo(ByteSource.inputStream(is, fileName));
    }

    public static ImageInfo getImageInfo(String fileName, byte[] bytes) throws ImagingException, IOException {
        return Imaging.getImageInfo(ByteSource.array(bytes, fileName));
    }

    public static Dimension getImageSize(byte[] bytes) throws ImagingException, IOException {
        return Imaging.getImageSize(ByteSource.array(bytes));
    }

    public static Dimension getImageSize(ByteSource byteSource) throws ImagingException, IOException {
        AbstractImageParser<Object> imageParser = ImageParserFactory.getImageParser(byteSource);
        return imageParser.getImageSize(byteSource, null);
    }

    public static Dimension getImageSize(File file) throws ImagingException, IOException {
        return Imaging.getImageSize(ByteSource.file(file));
    }

    public static Dimension getImageSize(InputStream is, String fileName) throws ImagingException, IOException {
        return Imaging.getImageSize(ByteSource.inputStream(is, fileName));
    }

    public static ImageMetadata getMetadata(byte[] bytes) throws ImagingException, IOException {
        return Imaging.getMetadata(ByteSource.array(bytes));
    }

    private static ImageMetadata getMetadata(ByteSource byteSource) throws ImagingException, IOException {
        AbstractImageParser<Object> imageParser = ImageParserFactory.getImageParser(byteSource);
        return imageParser.getMetadata(byteSource, null);
    }

    public static ImageMetadata getMetadata(File file) throws ImagingException, IOException {
        return Imaging.getMetadata(ByteSource.file(file));
    }

    public static ImageMetadata getMetadata(InputStream is, String fileName) throws ImagingException, IOException {
        return Imaging.getMetadata(ByteSource.inputStream(is, fileName));
    }

    public static String getXmpXml(byte[] bytes) throws ImagingException, IOException {
        return Imaging.getXmpXml(ByteSource.array(bytes));
    }

    public static String getXmpXml(ByteSource byteSource) throws ImagingException, IOException {
        AbstractImageParser imageParser = ImageParserFactory.getImageParser(byteSource);
        if (imageParser instanceof XmpEmbeddable) {
            return ((XmpEmbeddable)((Object)imageParser)).getXmpXml(byteSource, null);
        }
        return null;
    }

    public static String getXmpXml(File file) throws ImagingException, IOException {
        return Imaging.getXmpXml(ByteSource.file(file));
    }

    public static String getXmpXml(InputStream is, String fileName) throws ImagingException, IOException {
        return Imaging.getXmpXml(ByteSource.inputStream(is, fileName));
    }

    public static ImageFormat guessFormat(byte[] bytes) throws IOException {
        return Imaging.guessFormat(ByteSource.array(bytes));
    }

    public static ImageFormat guessFormat(ByteSource byteSource) throws IOException {
        if (byteSource == null) {
            return ImageFormats.UNKNOWN;
        }
        try (InputStream is = byteSource.getInputStream();){
            int i32;
            int i1 = is.read();
            int i2 = is.read();
            if (i1 < 0 || i2 < 0) {
                throw new IllegalArgumentException("Couldn't read magic numbers to guess format.");
            }
            int b1 = i1 & 0xFF;
            int b2 = i2 & 0xFF;
            int[] bytePair = new int[]{b1, b2};
            if (Imaging.compareBytePair(MAGIC_NUMBERS_GIF, bytePair)) {
                ImageFormats imageFormats = ImageFormats.GIF;
                return imageFormats;
            }
            if (Imaging.compareBytePair(MAGIC_NUMBERS_PNG, bytePair)) {
                ImageFormats imageFormats = ImageFormats.PNG;
                return imageFormats;
            }
            if (Imaging.compareBytePair(MAGIC_NUMBERS_JPEG, bytePair)) {
                ImageFormats imageFormats = ImageFormats.JPEG;
                return imageFormats;
            }
            if (Imaging.compareBytePair(MAGIC_NUMBERS_BMP, bytePair)) {
                ImageFormats imageFormats = ImageFormats.BMP;
                return imageFormats;
            }
            if (Imaging.compareBytePair(MAGIC_NUMBERS_TIFF_MOTOROLA, bytePair)) {
                ImageFormats imageFormats = ImageFormats.TIFF;
                return imageFormats;
            }
            if (Imaging.compareBytePair(MAGIC_NUMBERS_TIFF_INTEL, bytePair)) {
                ImageFormats imageFormats = ImageFormats.TIFF;
                return imageFormats;
            }
            if (Imaging.compareBytePair(MAGIC_NUMBERS_PSD, bytePair)) {
                ImageFormats imageFormats = ImageFormats.PSD;
                return imageFormats;
            }
            if (Imaging.compareBytePair(MAGIC_NUMBERS_PAM, bytePair)) {
                ImageFormats imageFormats = ImageFormats.PAM;
                return imageFormats;
            }
            if (Imaging.compareBytePair(MAGIC_NUMBERS_PBM_A, bytePair)) {
                ImageFormats imageFormats = ImageFormats.PBM;
                return imageFormats;
            }
            if (Imaging.compareBytePair(MAGIC_NUMBERS_PBM_B, bytePair)) {
                ImageFormats imageFormats = ImageFormats.PBM;
                return imageFormats;
            }
            if (Imaging.compareBytePair(MAGIC_NUMBERS_PGM_A, bytePair)) {
                ImageFormats imageFormats = ImageFormats.PGM;
                return imageFormats;
            }
            if (Imaging.compareBytePair(MAGIC_NUMBERS_PGM_B, bytePair)) {
                ImageFormats imageFormats = ImageFormats.PGM;
                return imageFormats;
            }
            if (Imaging.compareBytePair(MAGIC_NUMBERS_PPM_A, bytePair)) {
                ImageFormats imageFormats = ImageFormats.PPM;
                return imageFormats;
            }
            if (Imaging.compareBytePair(MAGIC_NUMBERS_PPM_B, bytePair)) {
                ImageFormats imageFormats = ImageFormats.PPM;
                return imageFormats;
            }
            if (Imaging.compareBytePair(MAGIC_NUMBERS_JBIG2_1, bytePair)) {
                i32 = is.read();
                int i4 = is.read();
                if (i32 < 0 || i4 < 0) {
                    throw new IllegalArgumentException("Couldn't read magic numbers to guess format.");
                }
                int b3 = i32 & 0xFF;
                int b4 = i4 & 0xFF;
                int[] bytePair2 = new int[]{b3, b4};
                if (Imaging.compareBytePair(MAGIC_NUMBERS_JBIG2_2, bytePair2)) {
                    ImageFormats imageFormats = ImageFormats.JBIG2;
                    return imageFormats;
                }
            } else {
                if (Imaging.compareBytePair(MAGIC_NUMBERS_ICNS, bytePair)) {
                    ImageFormats i32 = ImageFormats.ICNS;
                    return i32;
                }
                if (Imaging.compareBytePair(MAGIC_NUMBERS_DCX, bytePair)) {
                    ImageFormats i32 = ImageFormats.DCX;
                    return i32;
                }
                if (Imaging.compareBytePair(MAGIC_NUMBERS_RGBE, bytePair)) {
                    ImageFormats i32 = ImageFormats.RGBE;
                    return i32;
                }
                if (Imaging.compareBytePair(MAGIC_NUMBERS_RIFF_1, bytePair)) {
                    i32 = is.read();
                    int i4 = is.read();
                    if (i32 < 0 || i4 < 0) {
                        throw new IllegalArgumentException("Couldn't read magic numbers to guess format.");
                    }
                    int b3 = i32 & 0xFF;
                    int b4 = i4 & 0xFF;
                    int[] bytePair2 = new int[]{b3, b4};
                    if (Imaging.compareBytePair(MAGIC_NUMBERS_RIFF_2, bytePair2)) {
                        byte[] bytes = new byte[4];
                        if (is.read(bytes) < 4) {
                            throw new IllegalArgumentException("Couldn't read magic numbers to guess format.");
                        }
                        if (is.read(bytes) == 4 && Arrays.equals(MAGIC_NUMBERS_WEBP, bytes)) {
                            ImageFormats imageFormats = ImageFormats.WEBP;
                            return imageFormats;
                        }
                    }
                }
            }
            ImageFormat imageFormat2 = Stream.of(ImageFormats.values()).filter(imageFormat -> Stream.of(imageFormat.getExtensions()).anyMatch(extension -> {
                String fileName = byteSource.getFileName();
                if (fileName == null || fileName.trim().isEmpty()) {
                    return false;
                }
                String fileExtension = fileName.substring(fileName.lastIndexOf(46) + 1);
                return extension != null && !extension.trim().isEmpty() && fileExtension.equalsIgnoreCase((String)extension);
            })).findFirst().orElse(ImageFormats.UNKNOWN);
            return imageFormat2;
        }
    }

    public static ImageFormat guessFormat(File file) throws IOException {
        return Imaging.guessFormat(ByteSource.file(file));
    }

    public static boolean hasImageFileExtension(File file) {
        if (file == null || !file.isFile()) {
            return false;
        }
        return Imaging.hasImageFileExtension(file.getName());
    }

    public static boolean hasImageFileExtension(String fileName) {
        if (fileName == null) {
            return false;
        }
        String normalizedFileName = fileName.toLowerCase(Locale.ENGLISH);
        for (AbstractImageParser<?> imageParser : AbstractImageParser.getAllImageParsers()) {
            for (String extension : imageParser.getAcceptedExtensions()) {
                if (!normalizedFileName.endsWith(extension.toLowerCase(Locale.ENGLISH))) continue;
                return true;
            }
        }
        return false;
    }

    public static void writeImage(BufferedImage src, File file, ImageFormat format) throws ImagingException, IOException {
        try (FileOutputStream fos = new FileOutputStream(file);
             BufferedOutputStream os = new BufferedOutputStream(fos);){
            Imaging.writeImage(src, os, format);
        }
    }

    public static void writeImage(BufferedImage src, OutputStream outputStream, ImageFormat format) throws ImagingException, IOException {
        Objects.requireNonNull(src, "src");
        Objects.requireNonNull(outputStream, "outputStream");
        Objects.requireNonNull(format, "format");
        AbstractImageParser<Object> imageParser = ImageParserFactory.getImageParser(format);
        imageParser.writeImage(src, outputStream, null);
    }

    public static byte[] writeImageToBytes(BufferedImage src, ImageFormat format) throws ImagingException, IOException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            Imaging.writeImage(src, os, format);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
    }

    private Imaging() {
    }
}

